/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.cglib;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.cglib.proxy.Factory;
import org.mockito.Incubating;
import org.mockito.exceptions.base.MockitoSerializationIssue;
import org.mockito.internal.creation.cglib.ClassImposterizer;
import org.mockito.internal.creation.instance.InstantiatorProvider;
import org.mockito.internal.creation.settings.CreationSettings;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.StringJoiner;
import org.mockito.internal.util.reflection.FieldSetter;
import org.mockito.mock.MockCreationSettings;
import org.mockito.mock.MockName;
import org.mockito.mock.SerializableMode;

@Incubating
class AcrossJVMSerializationFeature
implements Serializable {
    private static final long serialVersionUID = 7411152578314420778L;
    private static final String MOCKITO_PROXY_MARKER = "MockitoProxyMarker";
    private boolean instanceLocalCurrentlySerializingFlag = false;
    private final Lock mutex = new ReentrantLock();

    AcrossJVMSerializationFeature() {
    }

    public boolean isWriteReplace(Method method) {
        return method.getReturnType() == Object.class && method.getParameterTypes().length == 0 && method.getName().equals("writeReplace");
    }

    public Object writeReplace(Object object) throws ObjectStreamException {
        try {
            this.mutex.lock();
            if (this.mockIsCurrentlyBeingReplaced()) {
                Object object2 = object;
                return object2;
            }
            this.mockReplacementStarted();
            AcrossJVMMockSerializationProxy acrossJVMMockSerializationProxy = new AcrossJVMMockSerializationProxy(object);
            return acrossJVMMockSerializationProxy;
        }
        catch (IOException iOException) {
            MockUtil mockUtil = new MockUtil();
            MockName mockName = mockUtil.getMockName(object);
            String string = mockUtil.getMockSettings(object).getTypeToMock().getCanonicalName();
            throw new MockitoSerializationIssue(StringJoiner.join("The mock '" + mockName + "' of type '" + string + "'", "The Java Standard Serialization reported an '" + iOException.getClass().getSimpleName() + "' saying :", "  " + iOException.getMessage()), iOException);
        }
        finally {
            this.mockReplacementCompleted();
            this.mutex.unlock();
        }
    }

    private void mockReplacementCompleted() {
        this.instanceLocalCurrentlySerializingFlag = false;
    }

    private void mockReplacementStarted() {
        this.instanceLocalCurrentlySerializingFlag = true;
    }

    private boolean mockIsCurrentlyBeingReplaced() {
        return this.instanceLocalCurrentlySerializingFlag;
    }

    public <T> void enableSerializationAcrossJVM(MockCreationSettings<T> mockCreationSettings) {
        if (mockCreationSettings.getSerializableMode() == SerializableMode.ACROSS_CLASSLOADERS) {
            mockCreationSettings.getExtraInterfaces().add(AcrossJVMMockitoMockSerializable.class);
        }
    }

    public static interface AcrossJVMMockitoMockSerializable {
        public Object writeReplace() throws ObjectStreamException;
    }

    private static class MockitoMockObjectOutputStream
    extends ObjectOutputStream {
        private static final String NOTHING = "";

        public MockitoMockObjectOutputStream(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
            super(byteArrayOutputStream);
        }

        @Override
        protected void annotateClass(Class<?> clazz) throws IOException {
            this.writeObject(this.mockitoProxyClassMarker(clazz));
        }

        private String mockitoProxyClassMarker(Class<?> clazz) {
            if (AcrossJVMMockitoMockSerializable.class.isAssignableFrom(clazz)) {
                return AcrossJVMSerializationFeature.MOCKITO_PROXY_MARKER;
            }
            return NOTHING;
        }
    }

    public static class MockitoMockObjectInputStream
    extends ObjectInputStream {
        private final Class typeToMock;
        private final Set<Class> extraInterfaces;

        public MockitoMockObjectInputStream(InputStream inputStream, Class clazz, Set<Class> set) throws IOException {
            super(inputStream);
            this.typeToMock = clazz;
            this.extraInterfaces = set;
            this.enableResolveObject(true);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            if (this.notMarkedAsAMockitoMock(this.readObject())) {
                return super.resolveClass(objectStreamClass);
            }
            ClassImposterizer classImposterizer = new ClassImposterizer(new InstantiatorProvider().getInstantiator(new CreationSettings()));
            classImposterizer.setConstructorsAccessible(this.typeToMock, true);
            Class<Factory> clazz = classImposterizer.createProxyClass(this.typeToMock, this.extraInterfaces.toArray(new Class[this.extraInterfaces.size()]));
            this.hackClassNameToMatchNewlyCreatedClass(objectStreamClass, clazz);
            return clazz;
        }

        private void hackClassNameToMatchNewlyCreatedClass(ObjectStreamClass objectStreamClass, Class<?> clazz) throws ObjectStreamException {
            try {
                Field field = objectStreamClass.getClass().getDeclaredField("name");
                new FieldSetter(objectStreamClass, field).set(clazz.getCanonicalName());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new MockitoSerializationIssue(StringJoiner.join("Wow, the class 'ObjectStreamClass' in the JDK don't have the field 'name',", "this is definitely a bug in our code as it means the JDK team changed a few internal things.", "", "Please report an issue with the JDK used, a code sample and a link to download the JDK would be welcome."), noSuchFieldException);
            }
        }

        private boolean notMarkedAsAMockitoMock(Object object) throws IOException, ClassNotFoundException {
            return !AcrossJVMSerializationFeature.MOCKITO_PROXY_MARKER.equals(object);
        }
    }

    public static class AcrossJVMMockSerializationProxy
    implements Serializable {
        private static final long serialVersionUID = -7600267929109286514L;
        private final byte[] serializedMock;
        private final Class typeToMock;
        private final Set<Class> extraInterfaces;

        public AcrossJVMMockSerializationProxy(Object object) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            MockitoMockObjectOutputStream mockitoMockObjectOutputStream = new MockitoMockObjectOutputStream(byteArrayOutputStream);
            mockitoMockObjectOutputStream.writeObject(object);
            mockitoMockObjectOutputStream.close();
            byteArrayOutputStream.close();
            MockCreationSettings mockCreationSettings = new MockUtil().getMockSettings(object);
            this.serializedMock = byteArrayOutputStream.toByteArray();
            this.typeToMock = mockCreationSettings.getTypeToMock();
            this.extraInterfaces = mockCreationSettings.getExtraInterfaces();
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.serializedMock);
                MockitoMockObjectInputStream mockitoMockObjectInputStream = new MockitoMockObjectInputStream(byteArrayInputStream, this.typeToMock, this.extraInterfaces);
                Object object = mockitoMockObjectInputStream.readObject();
                byteArrayInputStream.close();
                mockitoMockObjectInputStream.close();
                return object;
            }
            catch (IOException iOException) {
                throw new MockitoSerializationIssue(StringJoiner.join("Mockito mock cannot be deserialized to a mock of '" + this.typeToMock.getCanonicalName() + "'. The error was :", "  " + iOException.getMessage(), "If you are unsure what is the reason of this exception, feel free to contact us on the mailing list."), iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MockitoSerializationIssue(StringJoiner.join("A class couldn't be found while deserializing a Mockito mock, you should check your classpath. The error was :", "  " + classNotFoundException.getMessage(), "If you are still unsure what is the reason of this exception, feel free to contact us on the mailing list."), classNotFoundException);
            }
        }
    }
}

