/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.injection.scanner;

import java.lang.reflect.Field;
import java.util.Set;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.collections.Sets;
import org.mockito.internal.util.reflection.FieldReader;

public class MockScanner {
    private final MockUtil mockUtil = new MockUtil();
    private final Object instance;
    private final Class<?> clazz;

    public MockScanner(Object object, Class<?> clazz) {
        this.instance = object;
        this.clazz = clazz;
    }

    public void addPreparedMocks(Set<Object> set) {
        set.addAll(this.scan());
    }

    private Set<Object> scan() {
        Set<Object> set = Sets.newMockSafeHashSet(new Object[0]);
        for (Field field : this.clazz.getDeclaredFields()) {
            FieldReader fieldReader = new FieldReader(this.instance, field);
            Object object = this.preparedMock(fieldReader.read(), field);
            if (object == null) continue;
            set.add(object);
        }
        return set;
    }

    private Object preparedMock(Object object, Field field) {
        if (this.isAnnotatedByMockOrSpy(field)) {
            return object;
        }
        if (this.isMockOrSpy(object)) {
            this.mockUtil.maybeRedefineMockName(object, field.getName());
            return object;
        }
        return null;
    }

    private boolean isAnnotatedByMockOrSpy(Field field) {
        return null != field.getAnnotation(Spy.class) || null != field.getAnnotation(Mock.class) || null != field.getAnnotation(MockitoAnnotations.Mock.class);
    }

    private boolean isMockOrSpy(Object object) {
        return this.mockUtil.isMock(object) || this.mockUtil.isSpy(object);
    }
}

