/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration.injection;

import java.lang.reflect.Field;
import java.util.Set;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.injection.MockInjectionStrategy;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.util.reflection.FieldReader;
import org.mockito.internal.util.reflection.FieldSetter;

public class SpyOnInjectedFieldsHandler
extends MockInjectionStrategy {
    @Override
    protected boolean processInjection(Field field, Object object, Set<Object> set) {
        FieldReader fieldReader = new FieldReader(object, field);
        if (!fieldReader.isNull() && field.isAnnotationPresent(Spy.class)) {
            try {
                Object object2 = fieldReader.read();
                if (new MockUtil().isMock(object2)) {
                    Mockito.reset(object2);
                } else {
                    new FieldSetter(object, field).set(Mockito.mock(object2.getClass(), Mockito.withSettings().spiedInstance(object2).defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field.getName())));
                }
            }
            catch (Exception exception) {
                throw new MockitoException("Problems initiating spied field " + field.getName(), exception);
            }
        }
        return false;
    }
}

