/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal;

import java.util.Arrays;
import java.util.List;
import org.mockito.InOrder;
import org.mockito.MockSettings;
import org.mockito.MockingDetails;
import org.mockito.exceptions.Reporter;
import org.mockito.exceptions.misusing.NotAMockException;
import org.mockito.internal.InOrderImpl;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.creation.MockSettingsImpl;
import org.mockito.internal.invocation.finder.VerifiableInvocationsFinder;
import org.mockito.internal.progress.IOngoingStubbing;
import org.mockito.internal.progress.MockingProgress;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.stubbing.OngoingStubbingImpl;
import org.mockito.internal.stubbing.StubberImpl;
import org.mockito.internal.util.DefaultMockingDetails;
import org.mockito.internal.util.MockUtil;
import org.mockito.internal.verification.MockAwareVerificationMode;
import org.mockito.internal.verification.VerificationDataImpl;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.internal.verification.api.InOrderContext;
import org.mockito.internal.verification.api.VerificationDataInOrderImpl;
import org.mockito.invocation.Invocation;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.DeprecatedOngoingStubbing;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.stubbing.Stubber;
import org.mockito.stubbing.VoidMethodStubbable;
import org.mockito.verification.VerificationMode;

public class MockitoCore {
    private final Reporter reporter = new Reporter();
    private final MockUtil mockUtil = new MockUtil();
    private final MockingProgress mockingProgress = new ThreadSafeMockingProgress();

    public boolean isTypeMockable(Class<?> clazz) {
        return this.mockUtil.isTypeMockable(clazz);
    }

    public <T> T mock(Class<T> clazz, MockSettings mockSettings) {
        if (!MockSettingsImpl.class.isInstance(mockSettings)) {
            throw new IllegalArgumentException("Unexpected implementation of '" + mockSettings.getClass().getCanonicalName() + "'\n" + "At the moment, you cannot provide your own implementations that class.");
        }
        MockSettingsImpl mockSettingsImpl = (MockSettingsImpl)MockSettingsImpl.class.cast(mockSettings);
        MockCreationSettings<T> mockCreationSettings = mockSettingsImpl.confirm(clazz);
        T t = this.mockUtil.createMock(mockCreationSettings);
        this.mockingProgress.mockingStarted(t, clazz);
        return t;
    }

    public IOngoingStubbing stub() {
        IOngoingStubbing iOngoingStubbing = this.mockingProgress.pullOngoingStubbing();
        if (iOngoingStubbing == null) {
            this.mockingProgress.reset();
            this.reporter.missingMethodInvocation();
        }
        return iOngoingStubbing;
    }

    public <T> DeprecatedOngoingStubbing<T> stub(T t) {
        this.mockingProgress.stubbingStarted();
        return (DeprecatedOngoingStubbing)this.stub();
    }

    public <T> OngoingStubbing<T> when(T t) {
        this.mockingProgress.stubbingStarted();
        return (OngoingStubbing)this.stub();
    }

    public <T> T verify(T t, VerificationMode verificationMode) {
        if (t == null) {
            this.reporter.nullPassedToVerify();
        } else if (!this.mockUtil.isMock(t)) {
            this.reporter.notAMockPassedToVerify(t.getClass());
        }
        this.mockingProgress.verificationStarted(new MockAwareVerificationMode(t, verificationMode));
        return t;
    }

    public <T> void reset(T ... TArray) {
        this.mockingProgress.validateState();
        this.mockingProgress.reset();
        this.mockingProgress.resetOngoingStubbing();
        for (T t : TArray) {
            this.mockUtil.resetMock(t);
        }
    }

    public void verifyNoMoreInteractions(Object ... objectArray) {
        this.assertMocksNotEmpty(objectArray);
        this.mockingProgress.validateState();
        for (Object object : objectArray) {
            try {
                if (object == null) {
                    this.reporter.nullPassedToVerifyNoMoreInteractions();
                }
                InvocationContainer invocationContainer = this.mockUtil.getMockHandler(object).getInvocationContainer();
                VerificationDataImpl verificationDataImpl = new VerificationDataImpl(invocationContainer, null);
                VerificationModeFactory.noMoreInteractions().verify(verificationDataImpl);
            }
            catch (NotAMockException notAMockException) {
                this.reporter.notAMockPassedToVerifyNoMoreInteractions();
            }
        }
    }

    public void verifyNoMoreInteractionsInOrder(List<Object> list, InOrderContext inOrderContext) {
        this.mockingProgress.validateState();
        VerifiableInvocationsFinder verifiableInvocationsFinder = new VerifiableInvocationsFinder();
        VerificationDataInOrderImpl verificationDataInOrderImpl = new VerificationDataInOrderImpl(inOrderContext, verifiableInvocationsFinder.find(list), null);
        VerificationModeFactory.noMoreInteractions().verifyInOrder(verificationDataInOrderImpl);
    }

    private void assertMocksNotEmpty(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            this.reporter.mocksHaveToBePassedToVerifyNoMoreInteractions();
        }
    }

    public InOrder inOrder(Object ... objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            this.reporter.mocksHaveToBePassedWhenCreatingInOrder();
        }
        for (Object object : objectArray) {
            if (object == null) {
                this.reporter.nullPassedWhenCreatingInOrder();
                continue;
            }
            if (this.mockUtil.isMock(object)) continue;
            this.reporter.notAMockPassedWhenCreatingInOrder();
        }
        return new InOrderImpl(Arrays.asList(objectArray));
    }

    public Stubber doAnswer(Answer answer) {
        this.mockingProgress.stubbingStarted();
        this.mockingProgress.resetOngoingStubbing();
        return new StubberImpl().doAnswer(answer);
    }

    public <T> VoidMethodStubbable<T> stubVoid(T t) {
        InternalMockHandler<T> internalMockHandler = this.mockUtil.getMockHandler(t);
        this.mockingProgress.stubbingStarted();
        return internalMockHandler.voidMethodStubbable(t);
    }

    public void validateMockitoUsage() {
        this.mockingProgress.validateState();
    }

    public Invocation getLastInvocation() {
        OngoingStubbingImpl ongoingStubbingImpl = (OngoingStubbingImpl)this.mockingProgress.pullOngoingStubbing();
        List<Invocation> list = ongoingStubbingImpl.getRegisteredInvocations();
        return list.get(list.size() - 1);
    }

    public Object[] ignoreStubs(Object ... objectArray) {
        for (Object object : objectArray) {
            InvocationContainer invocationContainer = new MockUtil().getMockHandler(object).getInvocationContainer();
            List<Invocation> list = invocationContainer.getInvocations();
            for (Invocation invocation : list) {
                if (invocation.stubInfo() == null) continue;
                invocation.ignoreForVerification();
            }
        }
        return objectArray;
    }

    public MockingDetails mockingDetails(Object object) {
        return new DefaultMockingDetails(object, new MockUtil());
    }
}

