/*
 * Decompiled with CFR 0.152.
 */
package tightvnc;

import java.awt.Button;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import tightvnc.VncViewer;

class RecordingFrame
extends Frame
implements WindowListener,
ActionListener {
    boolean recording;
    TextField fnameField;
    Button browseButton;
    Label statusLabel;
    Button recordButton;
    Button nextButton;
    Button closeButton;
    VncViewer viewer;

    public static boolean checkSecurity() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            try {
                security.checkPropertyAccess("user.dir");
                security.checkPropertyAccess("file.separator");
                System.getProperty("user.dir");
            }
            catch (SecurityException e) {
                System.out.println("SecurityManager restricts session recording.");
                return false;
            }
        }
        return true;
    }

    RecordingFrame(VncViewer v) {
        super("TightVNC Session Recording");
        this.viewer = v;
        String fname = this.nextNewFilename(System.getProperty("user.dir") + System.getProperty("file.separator") + "vncsession.fbs");
        Panel fnamePanel = new Panel();
        GridBagLayout fnameGridbag = new GridBagLayout();
        fnamePanel.setLayout(fnameGridbag);
        GridBagConstraints fnameConstraints = new GridBagConstraints();
        fnameConstraints.gridwidth = -1;
        fnameConstraints.fill = 1;
        fnameConstraints.weightx = 4.0;
        this.fnameField = new TextField(fname, 64);
        fnameGridbag.setConstraints(this.fnameField, fnameConstraints);
        fnamePanel.add(this.fnameField);
        this.fnameField.addActionListener(this);
        fnameConstraints.gridwidth = 0;
        fnameConstraints.weightx = 1.0;
        this.browseButton = new Button("Browse");
        fnameGridbag.setConstraints(this.browseButton, fnameConstraints);
        fnamePanel.add(this.browseButton);
        this.browseButton.addActionListener(this);
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(10, 0, 0, 0);
        Label helpLabel = new Label("File name to save next recorded session in:", 1);
        gridbag.setConstraints(helpLabel, gbc);
        this.add(helpLabel);
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gridbag.setConstraints(fnamePanel, gbc);
        this.add(fnamePanel);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(10, 0, 10, 0);
        this.statusLabel = new Label("", 1);
        gridbag.setConstraints(this.statusLabel, gbc);
        this.add(this.statusLabel);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.recordButton = new Button("Record");
        gridbag.setConstraints(this.recordButton, gbc);
        this.add(this.recordButton);
        this.recordButton.addActionListener(this);
        this.nextButton = new Button("Next file");
        gridbag.setConstraints(this.nextButton, gbc);
        this.add(this.nextButton);
        this.nextButton.addActionListener(this);
        this.closeButton = new Button("Close");
        gridbag.setConstraints(this.closeButton, gbc);
        this.add(this.closeButton);
        this.closeButton.addActionListener(this);
        this.stopRecording();
        this.pack();
        this.addWindowListener(this);
    }

    protected String nextFilename(String fname) {
        int len;
        int suffixPos = len = fname.length();
        int suffixNum = 1;
        if (len > 4 && fname.charAt(len - 4) == '.') {
            try {
                suffixNum = Integer.parseInt(fname.substring(len - 3, len)) + 1;
                suffixPos = len - 4;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        char[] zeroes = new char[]{'0', '0', '0'};
        String suffix = String.valueOf(suffixNum);
        if (suffix.length() < 3) {
            suffix = new String(zeroes, 0, 3 - suffix.length()) + suffix;
        }
        return fname.substring(0, suffixPos) + '.' + suffix;
    }

    protected String nextNewFilename(String fname) {
        String newName = fname;
        try {
            File f;
            while ((f = new File(newName = this.nextFilename(newName))).exists()) {
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        return newName;
    }

    protected boolean browseFile() {
        File currentFile = new File(this.fnameField.getText());
        FileDialog fd = new FileDialog((Frame)this, "Save next session as...", 1);
        fd.setDirectory(currentFile.getParent());
        fd.setVisible(true);
        if (fd.getFile() != null) {
            String newFname;
            String newDir = fd.getDirectory();
            String sep = System.getProperty("file.separator");
            if (newDir.length() > 0 && !sep.equals(newDir.substring(newDir.length() - sep.length()))) {
                newDir = newDir + sep;
            }
            if ((newFname = newDir + fd.getFile()).equals(this.fnameField.getText())) {
                this.fnameField.setText(newFname);
                return true;
            }
        }
        return false;
    }

    public void startRecording() {
        this.statusLabel.setText("Status: Recording...");
        this.statusLabel.setFont(new Font("Helvetica", 1, 12));
        this.statusLabel.setForeground(Color.red);
        this.recordButton.setLabel("Stop recording");
        this.recording = true;
        this.viewer.setRecordingStatus(this.fnameField.getText());
    }

    public void stopRecording() {
        this.statusLabel.setText("Status: Not recording.");
        this.statusLabel.setFont(new Font("Helvetica", 0, 12));
        this.statusLabel.setForeground(Color.black);
        this.recordButton.setLabel("Record");
        this.recording = false;
        this.viewer.setRecordingStatus(null);
    }

    @Override
    public void windowClosing(WindowEvent evt) {
        this.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent evt) {
    }

    @Override
    public void windowDeactivated(WindowEvent evt) {
    }

    @Override
    public void windowOpened(WindowEvent evt) {
    }

    @Override
    public void windowClosed(WindowEvent evt) {
    }

    @Override
    public void windowIconified(WindowEvent evt) {
    }

    @Override
    public void windowDeiconified(WindowEvent evt) {
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.browseButton) {
            if (this.browseFile() && this.recording) {
                this.startRecording();
            }
        } else if (evt.getSource() == this.recordButton) {
            if (!this.recording) {
                this.startRecording();
            } else {
                this.stopRecording();
                this.fnameField.setText(this.nextNewFilename(this.fnameField.getText()));
            }
        } else if (evt.getSource() == this.nextButton) {
            this.fnameField.setText(this.nextNewFilename(this.fnameField.getText()));
            if (this.recording) {
                this.startRecording();
            }
        } else if (evt.getSource() == this.closeButton) {
            this.setVisible(false);
        }
    }
}

