/*
 * Decompiled with CFR 0.152.
 */
package tightvnc;

import java.util.Hashtable;
import java.util.Vector;
import tightvnc.CapabilityInfo;

class CapsContainer {
    protected Hashtable infoMap = new Hashtable(64, 0.25f);
    protected Vector orderedList = new Vector(32, 8);

    public void add(CapabilityInfo capinfo) {
        Integer key = new Integer(capinfo.getCode());
        this.infoMap.put(key, capinfo);
    }

    public void add(int code, String vendor, String name, String desc) {
        Integer key = new Integer(code);
        this.infoMap.put(key, new CapabilityInfo(code, vendor, name, desc));
    }

    public boolean isKnown(int code) {
        return this.infoMap.containsKey(new Integer(code));
    }

    public CapabilityInfo getInfo(int code) {
        return (CapabilityInfo)this.infoMap.get(new Integer(code));
    }

    public String getDescription(int code) {
        CapabilityInfo capinfo = (CapabilityInfo)this.infoMap.get(new Integer(code));
        if (capinfo == null) {
            return null;
        }
        return capinfo.getDescription();
    }

    public boolean enable(CapabilityInfo other) {
        Integer key = new Integer(other.getCode());
        CapabilityInfo capinfo = (CapabilityInfo)this.infoMap.get(key);
        if (capinfo == null) {
            return false;
        }
        boolean enabled = capinfo.enableIfEquals(other);
        if (enabled) {
            this.orderedList.addElement(key);
        }
        return enabled;
    }

    public boolean isEnabled(int code) {
        CapabilityInfo capinfo = (CapabilityInfo)this.infoMap.get(new Integer(code));
        if (capinfo == null) {
            return false;
        }
        return capinfo.isEnabled();
    }

    public int numEnabled() {
        return this.orderedList.size();
    }

    public int getByOrder(int idx) {
        int code;
        try {
            code = (Integer)this.orderedList.elementAt(idx);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            code = 0;
        }
        return code;
    }
}

