/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.InStream;
import rfb.CMsgHandler;
import rfb.Decoder;
import rfb.Exception;
import rfb.LogWriter;

public abstract class CMsgReader {
    CMsgHandler handler;
    InStream is;
    Decoder[] decoders;
    byte[] imageBuf;
    int imageBufSize;
    int imageBufIdealSize;
    static LogWriter vlog = new LogWriter("CMsgReader");

    public abstract void readServerInit();

    public abstract void readMsg();

    public InStream getInStream() {
        return this.is;
    }

    public byte[] getImageBuf(int required, int requested) {
        int requiredBytes = required * (this.handler.cp.pf().bpp / 8);
        int requestedBytes = requested * (this.handler.cp.pf().bpp / 8);
        int size = requestedBytes;
        if (size > this.imageBufIdealSize) {
            size = this.imageBufIdealSize;
        }
        if (size < requiredBytes) {
            size = requiredBytes;
        }
        if (this.imageBufSize < size) {
            this.imageBufSize = size;
            this.imageBuf = new byte[this.imageBufSize];
        }
        return this.imageBuf;
    }

    public final int bpp() {
        return this.handler.cp.pf().bpp;
    }

    protected CMsgReader(CMsgHandler handler_, InStream is_) {
        this.handler = handler_;
        this.is = is_;
        this.decoders = new Decoder[256];
    }

    protected void readSetColourMapEntries() {
        this.is.skip(1);
        int firstColour = this.is.readU16();
        int nColours = this.is.readU16();
        int[] rgbs = new int[nColours * 3];
        for (int i = 0; i < nColours * 3; ++i) {
            rgbs[i] = this.is.readU16();
        }
        this.endMsg();
        this.handler.setColourMapEntries(firstColour, nColours, rgbs);
    }

    protected void readBell() {
        this.endMsg();
        this.handler.bell();
    }

    protected void readServerCutText() {
        this.is.skip(3);
        int len = this.is.readU32();
        if (len > 262144) {
            this.is.skip(len);
            vlog.error("cut text too long (" + len + " bytes) - ignoring");
            return;
        }
        byte[] buf = new byte[len];
        this.is.readBytes(buf, 0, len);
        this.endMsg();
        this.handler.serverCutText(new String(buf, 0, len));
    }

    protected void endMsg() {
    }

    protected void readFramebufferUpdateStart() {
        this.endMsg();
        this.handler.framebufferUpdateStart();
    }

    protected void readFramebufferUpdateEnd() {
        this.endMsg();
        this.handler.framebufferUpdateEnd();
    }

    protected void readRect(int x, int y, int w, int h, int encoding) {
        if (x + w > this.handler.cp.width || y + h > this.handler.cp.height) {
            vlog.error("Rect too big: " + w + "x" + h + " at " + x + "," + y + " exceeds " + this.handler.cp.width + "x" + this.handler.cp.height);
            throw new Exception("Rect too big");
        }
        if (w * h == 0) {
            vlog.info("Ignoring zero size rect");
            return;
        }
        this.handler.beginRect(x, y, w, h, encoding);
        if (encoding == 1) {
            this.readCopyRect(x, y, w, h);
        } else {
            if (this.decoders[encoding] == null) {
                this.decoders[encoding] = Decoder.createDecoder(encoding, this);
                if (this.decoders[encoding] == null) {
                    vlog.error("Unknown rect encoding " + encoding);
                    throw new Exception("Unknown rect encoding");
                }
            }
            this.decoders[encoding].readRect(x, y, w, h, this.handler);
        }
        this.handler.endRect(x, y, w, h, encoding);
    }

    protected void readCopyRect(int x, int y, int w, int h) {
        int srcX = this.is.readU16();
        int srcY = this.is.readU16();
        this.handler.copyRect(x, y, w, h, srcX, srcY);
    }

    protected void readSetCursor(int hotspotX, int hotspotY, int w, int h) {
        int data_len = w * h * (this.handler.cp.pf().bpp / 8);
        int mask_len = (w + 7) / 8 * h;
        byte[] data = new byte[data_len];
        byte[] mask = new byte[mask_len];
        this.is.readBytes(data, 0, data_len);
        this.is.readBytes(mask, 0, mask_len);
        this.handler.setCursor(hotspotX, hotspotY, w, h, data, mask);
    }
}

