/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.vm;

import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.vm.Filesystem;
import lcmc.gui.dialog.vm.InstallationDisk;
import lcmc.gui.dialog.vm.VMConfig;
import lcmc.gui.resources.VMSVirtualDomainInfo;
import lcmc.gui.widget.Widget;
import lcmc.utilities.Tools;

public final class Domain
extends VMConfig {
    private static final long serialVersionUID = 1L;
    private JComponent inputPane = null;
    private Widget domainNameWi;
    private static final String[] PARAMS = new String[]{"domain-type", "name", "virsh-options", "emulator", "vcpu", "currentMemory", "boot", "boot2", "loader", "type", "init", "arch", "machine"};
    private WizardDialog nextDialogObject = null;

    public Domain(WizardDialog previousDialog, VMSVirtualDomainInfo vmsVirtualDomainInfo) {
        super(previousDialog, vmsVirtualDomainInfo);
    }

    @Override
    public WizardDialog nextDialog() {
        if (this.nextDialogObject == null) {
            this.nextDialogObject = this.getVMSVirtualDomainInfo().needFilesystem() ? new Filesystem(this, this.getVMSVirtualDomainInfo()) : new InstallationDisk(this, this.getVMSVirtualDomainInfo());
        }
        return this.nextDialogObject;
    }

    @Override
    protected String getDialogTitle() {
        return Tools.getString("Dialog.vm.Domain.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.vm.Domain.Description");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        super.initDialogAfterVisible();
        VMSVirtualDomainInfo vdi = this.getVMSVirtualDomainInfo();
        boolean ch = vdi.checkResourceFieldsChanged(null, PARAMS);
        boolean cor = vdi.checkResourceFieldsCorrect(null, PARAMS);
        if (cor || this.nextDialogObject != null) {
            this.enableComponents();
        } else {
            this.enableComponents(new JComponent[]{this.buttonClass(this.nextButton())});
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Domain.this.makeDefaultButton(Domain.this.buttonClass(Domain.this.nextButton()));
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Domain.this.domainNameWi.requestFocus();
            }
        });
    }

    @Override
    protected JComponent getInputPane() {
        VMSVirtualDomainInfo vdi = this.getVMSVirtualDomainInfo();
        vdi.getInfoPanel();
        vdi.waitForInfoPanel();
        if (this.inputPane != null) {
            return this.inputPane;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setAlignmentY(0.0f);
        vdi.getResource().setValue("boot", "CD-ROM");
        vdi.savePreferredValues();
        vdi.addWizardParams(optionsPanel, PARAMS, this.buttonClass(this.nextButton()), Tools.getDefaultSize("Dialog.vm.Resource.LabelWidth"), Tools.getDefaultSize("Dialog.vm.Resource.FieldWidth"), null);
        this.domainNameWi = vdi.getWidget("name", "widget");
        panel.add(optionsPanel);
        JScrollPane sp = new JScrollPane(panel);
        sp.setMaximumSize(new Dimension(Short.MAX_VALUE, 200));
        sp.setPreferredSize(new Dimension(Short.MAX_VALUE, 200));
        this.inputPane = sp;
        return sp;
    }
}

