/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.host.CheckInstallation;
import lcmc.gui.dialog.host.DialogHost;
import lcmc.utilities.ConvertCmdCallback;
import lcmc.utilities.ExecCallback;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

final class DrbdCommandInst
extends DialogHost {
    private static final long serialVersionUID = 1L;
    private WizardDialog nextDialogObject = null;

    DrbdCommandInst(WizardDialog previousDialog, Host host) {
        super(previousDialog, host);
    }

    void checkAnswer(String ans) {
        this.nextDialogObject = new CheckInstallation(this.getPreviousDialog().getPreviousDialog().getPreviousDialog(), this.getHost());
        this.progressBarDone();
        this.answerPaneSetText(Tools.getString("Dialog.Host.DrbdCommandInst.InstOk"));
        this.enableComponents(new JComponent[]{this.buttonClass(this.backButton())});
        this.buttonClass(this.nextButton()).requestFocus();
        if (Tools.getConfigData().getAutoOptionHost("drbdinst") != null) {
            Tools.sleep(1000);
            this.pressNextButton();
        }
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.nextButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.getProgressBar().start(50000);
        this.installDrbd();
    }

    private void installDrbd() {
        String arch = this.getHost().getDistString("DrbdInst.install." + this.getHost().getArch());
        if (arch == null) {
            arch = this.getHost().getArch();
        }
        final String archString = arch;
        String installCommand = "DrbdInst.install";
        String installMethod = this.getHost().getDrbdInstallMethod();
        if (installMethod != null) {
            installCommand = "DrbdInst.install." + installMethod;
        }
        final String drbdVersion = this.getHost().getDrbdVersionToInstall();
        final String drbdVersionUrlString = this.getHost().getDrbdVersionUrlStringToInstall();
        Tools.getConfigData().setLastDrbdInstalledMethod(this.getHost().getDistString("DrbdInst.install.text." + installMethod));
        this.getHost().execCommandInBash(installCommand + ";;;DRBD.load", this.getProgressBar(), new ExecCallback(){

            @Override
            public void done(String ans) {
                DrbdCommandInst.this.checkAnswer(ans);
            }

            @Override
            public void doneError(String ans, int exitCode) {
                DrbdCommandInst.this.printErrorAndRetry(Tools.getString("Dialog.Host.DrbdCommandInst.InstError"), ans, exitCode);
            }
        }, new ConvertCmdCallback(){

            @Override
            public String convert(String command) {
                return command.replaceAll("@ARCH@", archString).replaceAll("@VERSIONSTRING@", drbdVersionUrlString).replaceAll("@VERSION@", drbdVersion);
            }
        }, true, SSH.DEFAULT_COMMAND_TIMEOUT_LONG);
    }

    @Override
    public WizardDialog nextDialog() {
        return this.nextDialogObject;
    }

    @Override
    protected String getHostDialogTitle() {
        return Tools.getString("Dialog.Host.DrbdCommandInst.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.Host.DrbdCommandInst.Description");
    }

    @Override
    protected JComponent getInputPane() {
        JPanel pane = new JPanel(new SpringLayout());
        pane.add(this.getProgressBarPane());
        pane.add(this.getAnswerPane(Tools.getString("Dialog.Host.DrbdCommandInst.Executing")));
        SpringUtilities.makeCompactGrid(pane, 2, 1, 0, 0, 0, 0);
        return pane;
    }
}

