/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.drbdConfig;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.Exceptions;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.dialog.drbdConfig.DrbdConfig;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import lcmc.utilities.WidgetListener;

final class CreateFS
extends DrbdConfig {
    private static final long serialVersionUID = 1L;
    private Widget hostW;
    private Widget filesystemW;
    private Widget skipSyncW;
    private JLabel skipSyncLabel;
    private final MyButton makeFsButton = new MyButton(Tools.getString("Dialog.DrbdConfig.CreateFS.CreateFsButton"));
    private static final String NO_HOST_STRING = Tools.getString("Dialog.DrbdConfig.CreateFS.NoHostString");
    private static final String NO_FILESYSTEM_STRING = Tools.getString("Dialog.DrbdConfig.CreateFS.SelectFilesystem");
    private static final int COMBOBOX_WIDTH = 250;
    private static final String SKIP_SYNC_FALSE = "false";
    private static final String SKIP_SYNC_TRUE = "true";

    CreateFS(WizardDialog previousDialog, DrbdVolumeInfo drbdVolumeInfo) {
        super(previousDialog, drbdVolumeInfo);
    }

    @Override
    protected void finishDialog() {
        BlockDevInfo bdiPri = this.getPrimaryBD();
        if (bdiPri != null) {
            boolean testOnly = false;
            if (SKIP_SYNC_TRUE.equals(this.skipSyncW.getStringValue())) {
                bdiPri.skipInitialFullSync(false);
            }
            bdiPri.forcePrimary(false);
        }
    }

    protected BlockDevInfo getPrimaryBD() {
        BlockDevInfo bdi1 = this.getDrbdVolumeInfo().getFirstBlockDevInfo();
        BlockDevInfo bdi2 = this.getDrbdVolumeInfo().getSecondBlockDevInfo();
        String h = this.hostW.getStringValue();
        if (h.equals(bdi1.getHost().getName())) {
            return bdi1;
        }
        if (h.equals(bdi2.getHost().getName())) {
            return bdi2;
        }
        return null;
    }

    protected BlockDevInfo getSecondaryBD() {
        BlockDevInfo bdi1 = this.getDrbdVolumeInfo().getFirstBlockDevInfo();
        BlockDevInfo bdi2 = this.getDrbdVolumeInfo().getSecondBlockDevInfo();
        String h = this.hostW.getStringValue();
        if (h.equals(bdi1.getHost().getName())) {
            return bdi2;
        }
        if (h.equals(bdi2.getHost().getName())) {
            return bdi1;
        }
        Tools.appError("unknown host: " + h);
        return null;
    }

    protected void createFilesystem() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CreateFS.this.getProgressBar().start(1);
                CreateFS.this.answerPaneSetText(Tools.getString("Dialog.DrbdConfig.CreateFS.MakeFS"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CreateFS.this.buttonClass(CreateFS.this.finishButton()).setEnabled(false);
                        CreateFS.this.makeFsButton.setEnabled(false);
                    }
                });
                BlockDevInfo bdiPri = CreateFS.this.getPrimaryBD();
                BlockDevInfo bdiSec = CreateFS.this.getSecondaryBD();
                boolean testOnly = false;
                if (CreateFS.SKIP_SYNC_TRUE.equals(CreateFS.this.skipSyncW.getStringValue())) {
                    bdiPri.skipInitialFullSync(false);
                }
                bdiPri.forcePrimary(false);
                String fs = CreateFS.this.filesystemW.getStringValue();
                bdiPri.makeFilesystem(fs, false);
                if (bdiPri.getDrbdVolumeInfo() != null) {
                    CreateFS.this.getDrbdVolumeInfo().setCreatedFs(fs);
                    bdiPri.setSecondary(false);
                    CreateFS.this.hostW.setValue(NO_HOST_STRING);
                    CreateFS.this.filesystemW.setValue(NO_FILESYSTEM_STRING);
                    CreateFS.this.answerPaneSetText(Tools.getString("Dialog.DrbdConfig.CreateFS.MakeFS.Done"));
                }
                CreateFS.this.progressBarDone();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    @Override
    public WizardDialog nextDialog() {
        return null;
    }

    @Override
    protected String getDialogTitle() {
        return Tools.getString("Dialog.DrbdConfig.CreateFS.Title");
    }

    @Override
    protected String getDescription() {
        return Tools.getString("Dialog.DrbdConfig.CreateFS.Description");
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.makeFsButton.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Button"));
        this.enableComponentsLater(new JComponent[]{this.buttonClass(this.finishButton())});
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
        if (Tools.getConfigData().getAutoOptionGlobal("autodrbd") != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateFS.this.makeFsButton.pressButton();
                }
            });
        }
    }

    protected void checkButtons() {
        final boolean noHost = this.hostW.getStringValue().equals(NO_HOST_STRING);
        boolean noFileSystem = this.filesystemW.getStringValue().equals(NO_FILESYSTEM_STRING);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (noHost) {
                    CreateFS.this.skipSyncW.setEnabled(false);
                    CreateFS.this.skipSyncLabel.setEnabled(false);
                    CreateFS.this.skipSyncW.setValue(CreateFS.SKIP_SYNC_FALSE);
                } else if (CreateFS.this.skipSyncAvailable()) {
                    CreateFS.this.skipSyncW.setEnabled(true);
                    CreateFS.this.skipSyncLabel.setEnabled(true);
                }
            }
        });
        if (noFileSystem) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateFS.this.buttonClass(CreateFS.this.finishButton()).setEnabled(true);
                    CreateFS.this.makeFsButton.setEnabled(false);
                    CreateFS.this.skipSyncW.setValue(CreateFS.SKIP_SYNC_FALSE);
                }
            });
        } else if (noHost) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateFS.this.buttonClass(CreateFS.this.finishButton()).setEnabled(false);
                }
            });
            this.makeFsButton.setEnabled(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CreateFS.this.buttonClass(CreateFS.this.finishButton()).setEnabled(false);
                    CreateFS.this.makeFsButton.setEnabled(true);
                    if (CreateFS.this.skipSyncAvailable()) {
                        CreateFS.this.skipSyncW.setValue(CreateFS.SKIP_SYNC_TRUE);
                        CreateFS.this.skipSyncW.setEnabled(true);
                    }
                }
            });
        }
    }

    @Override
    protected JComponent getInputPane() {
        this.makeFsButton.setEnabled(false);
        JPanel pane = new JPanel(new SpringLayout());
        JPanel inputPane = new JPanel(new SpringLayout());
        Object[] hostNames = new String[3];
        hostNames[0] = NO_HOST_STRING;
        int i = 1;
        for (Host host : this.getDrbdVolumeInfo().getHosts()) {
            hostNames[i] = host.getName();
            ++i;
        }
        JLabel hostLabel = new JLabel(Tools.getString("Dialog.DrbdConfig.CreateFS.ChooseHost"));
        String defaultHost = NO_HOST_STRING;
        if (Tools.getConfigData().getAutoOptionGlobal("autodrbd") != null) {
            defaultHost = hostNames[1];
        }
        this.hostW = WidgetFactory.createInstance(Widget.Type.COMBOBOX, defaultHost, hostNames, Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        this.hostW.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                CreateFS.this.checkButtons();
            }
        });
        inputPane.add(hostLabel);
        inputPane.add(this.hostW);
        inputPane.add(new JLabel(""));
        JLabel filesystemLabel = new JLabel(Tools.getString("Dialog.DrbdConfig.CreateFS.Filesystem"));
        String defaultValue = NO_FILESYSTEM_STRING;
        if (Tools.getConfigData().getAutoOptionGlobal("autodrbd") != null) {
            defaultValue = "ext3";
        }
        Object[] filesystems = this.getDrbdVolumeInfo().getDrbdResourceInfo().getCommonFileSystems(defaultValue);
        this.filesystemW = WidgetFactory.createInstance(Widget.Type.COMBOBOX, defaultValue, filesystems, Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        inputPane.add(filesystemLabel);
        inputPane.add(this.filesystemW);
        this.filesystemW.addListeners(new WidgetListener((String[])hostNames){
            final /* synthetic */ String[] val$hostNames;
            {
                this.val$hostNames = stringArray;
            }

            @Override
            public void check(Object value) {
                if (NO_HOST_STRING.equals(CreateFS.this.hostW.getStringValue()) && !NO_FILESYSTEM_STRING.equals(CreateFS.this.filesystemW.getStringValue())) {
                    CreateFS.this.hostW.setValue(this.val$hostNames[1]);
                } else {
                    CreateFS.this.checkButtons();
                }
            }
        });
        this.makeFsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateFS.this.createFilesystem();
            }
        });
        inputPane.add(this.makeFsButton);
        this.skipSyncLabel = new JLabel(Tools.getString("Dialog.DrbdConfig.CreateFS.SkipSync"));
        this.skipSyncLabel.setEnabled(false);
        this.skipSyncW = WidgetFactory.createInstance(Widget.Type.CHECKBOX, SKIP_SYNC_FALSE, new String[]{SKIP_SYNC_TRUE, SKIP_SYNC_FALSE}, Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        this.skipSyncW.setEnabled(false);
        this.skipSyncW.setBackgroundColor(Tools.getDefaultColor("ConfigDialog.Background.Light"));
        inputPane.add(this.skipSyncLabel);
        inputPane.add(this.skipSyncW);
        inputPane.add(new JLabel(""));
        SpringUtilities.makeCompactGrid(inputPane, 3, 3, 1, 1, 1, 1);
        pane.add(inputPane);
        pane.add(this.getProgressBarPane(null));
        pane.add(this.getAnswerPane(""));
        SpringUtilities.makeCompactGrid(pane, 3, 1, 0, 0, 0, 0);
        return pane;
    }

    private boolean skipSyncAvailable() {
        BlockDevInfo bdi1 = this.getDrbdVolumeInfo().getFirstBlockDevInfo();
        BlockDevInfo bdi2 = this.getDrbdVolumeInfo().getSecondBlockDevInfo();
        try {
            return Tools.compareVersions(bdi1.getHost().getDrbdVersion(), "8.3.2") >= 0 && Tools.compareVersions(bdi2.getHost().getDrbdVersion(), "8.3.2") >= 0;
        }
        catch (Exceptions.IllegalVersionException e) {
            Tools.appWarning(e.getMessage(), e);
            return false;
        }
    }
}

