/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import lcmc.data.AccessMode;
import lcmc.data.Cluster;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.data.resources.BlockDevice;
import lcmc.data.resources.NetInterface;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.DrbdGraph;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.CategoryInfo;
import lcmc.gui.resources.FSInfo;
import lcmc.gui.resources.HostDrbdInfo;
import lcmc.gui.resources.HostInfo;
import lcmc.gui.resources.NetInfo;
import lcmc.gui.resources.ProxyHostInfo;
import lcmc.utilities.MyMenu;
import lcmc.utilities.MyMenuItem;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;

public final class HostBrowser
extends Browser {
    private DefaultMutableTreeNode netInterfacesNode;
    private DefaultMutableTreeNode blockDevicesNode;
    private DefaultMutableTreeNode fileSystemsNode;
    private final Set<String> usedPorts = new HashSet<String>();
    private final Set<String> usedProxyPorts = new HashSet<String>();
    private final Host host;
    private final HostInfo hostInfo;
    private final HostDrbdInfo hostDrbdInfo;
    private ProxyHostInfo proxyHostInfo = null;
    public static final ImageIcon HOST_ICON = Tools.createImageIcon(Tools.getDefault("HostBrowser.HostIconSmall"));
    public static final ImageIcon HOST_ON_ICON = Tools.createImageIcon(Tools.getDefault("HostBrowser.HostOnIconSmall"));
    public static final ImageIcon HOST_OFF_ICON = Tools.createImageIcon(Tools.getDefault("HostBrowser.HostOffIconSmall"));
    public static final ImageIcon HOST_ON_ICON_LARGE = Tools.createImageIcon(Tools.getDefault("HostBrowser.HostOnIcon"));
    public static final ImageIcon HOST_OFF_ICON_LARGE = Tools.createImageIcon(Tools.getDefault("HostBrowser.HostOffIcon"));
    public static final ImageIcon HOST_ICON_LARGE = Tools.createImageIcon(Tools.getDefault("HostBrowser.HostIcon"));
    public static final ImageIcon HOST_REMOVE_ICON = Tools.createImageIcon(Tools.getDefault("HostBrowser.RemoveIcon"));
    public static final ImageIcon HOST_IN_CLUSTER_ICON_RIGHT_SMALL = Tools.createImageIcon(Tools.getDefault("HostBrowser.HostInClusterIconRightSmall"));
    static final ImageIcon HOST_IN_CLUSTER_ICON_LEFT_SMALL = Tools.createImageIcon(Tools.getDefault("HostBrowser.HostInClusterIconLeftSmall"));
    private final Map<BlockDevice, BlockDevInfo> blockDevInfos = new LinkedHashMap<BlockDevice, BlockDevInfo>();
    private final ReadWriteLock mBlockDevInfosLock = new ReentrantReadWriteLock();
    private final Lock mBlockDevInfosReadLock = this.mBlockDevInfosLock.readLock();
    private final Lock mBlockDevInfosWriteLock = this.mBlockDevInfosLock.writeLock();
    private final ReadWriteLock mNetInfosLock = new ReentrantReadWriteLock();
    private final Lock mNetInfosReadLock = this.mNetInfosLock.readLock();
    private final Lock mNetInfosWriteLock = this.mNetInfosLock.writeLock();
    private final ReadWriteLock mFileSystemsLock = new ReentrantReadWriteLock();
    private final Lock mFileSystemsReadLock = this.mFileSystemsLock.readLock();
    private final Lock mFileSystemsWriteLock = this.mFileSystemsLock.writeLock();

    public HostBrowser(Host host) {
        this.host = host;
        this.hostInfo = new HostInfo(host, (Browser)this);
        this.hostDrbdInfo = new HostDrbdInfo(host, (Browser)this);
        this.setTreeTop(this.hostInfo);
    }

    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    public Host getHost() {
        return this.host;
    }

    public HostDrbdInfo getHostDrbdInfo() {
        return this.hostDrbdInfo;
    }

    public ProxyHostInfo getProxyHostInfo() {
        return this.proxyHostInfo;
    }

    public void setProxyHostInfo(ProxyHostInfo proxyHostInfo) {
        this.proxyHostInfo = proxyHostInfo;
    }

    public void initHostResources() {
        this.netInterfacesNode = new DefaultMutableTreeNode(new CategoryInfo(Tools.getString("HostBrowser.NetInterfaces"), this));
        this.setNode(this.netInterfacesNode);
        this.topAdd(this.netInterfacesNode);
        this.blockDevicesNode = new DefaultMutableTreeNode(new CategoryInfo(Tools.getString("HostBrowser.BlockDevices"), this));
        this.setNode(this.blockDevicesNode);
        this.topAdd(this.blockDevicesNode);
        this.fileSystemsNode = new DefaultMutableTreeNode(new CategoryInfo(Tools.getString("HostBrowser.FileSystems"), this));
        this.setNode(this.fileSystemsNode);
        this.topAdd(this.fileSystemsNode);
    }

    public ClusterBrowser getClusterBrowser() {
        Cluster c = this.host.getCluster();
        if (c == null) {
            return null;
        }
        return c.getBrowser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHWResources(final NetInterface[] nis, BlockDevice[] bds, final String[] fss) {
        final Map<NetInterface, NetInfo> oldNetInterfaces = this.getNetInterfacesMap();
        final HostBrowser thisClass = this;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HostBrowser.this.mNetInfosWriteLock.lock();
                try {
                    HostBrowser.this.netInterfacesNode.removeAllChildren();
                    for (NetInterface ni : nis) {
                        NetInfo nii = oldNetInterfaces.containsKey(ni) ? (NetInfo)oldNetInterfaces.get(ni) : new NetInfo(ni.getName(), ni, thisClass);
                        DefaultMutableTreeNode resource = new DefaultMutableTreeNode(nii);
                        HostBrowser.this.setNode(resource);
                        HostBrowser.this.netInterfacesNode.add(resource);
                    }
                    HostBrowser.this.reloadAndWait(HostBrowser.this.netInterfacesNode, false);
                }
                finally {
                    HostBrowser.this.mNetInfosWriteLock.unlock();
                }
            }
        });
        this.mBlockDevInfosWriteLock.lock();
        boolean changed = false;
        try {
            HashMap<BlockDevice, BlockDevInfo> oldBlockDevices = new HashMap<BlockDevice, BlockDevInfo>(this.blockDevInfos);
            if (oldBlockDevices.size() != this.blockDevInfos.size()) {
                changed = true;
            }
            this.blockDevInfos.clear();
            for (BlockDevice bd : bds) {
                BlockDevInfo bdi;
                if (oldBlockDevices.containsKey(bd)) {
                    bdi = (BlockDevInfo)oldBlockDevices.get(bd);
                    bdi.updateInfo();
                } else {
                    changed = true;
                    bdi = new BlockDevInfo(bd.getName(), bd, thisClass);
                }
                this.blockDevInfos.put(bd, bdi);
            }
        }
        finally {
            this.mBlockDevInfosWriteLock.unlock();
        }
        if (changed) {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HostBrowser.this.mBlockDevInfosWriteLock.lock();
                    try {
                        HostBrowser.this.blockDevicesNode.removeAllChildren();
                        for (BlockDevice bd : HostBrowser.this.blockDevInfos.keySet()) {
                            BlockDevInfo bdi = (BlockDevInfo)HostBrowser.this.blockDevInfos.get(bd);
                            DefaultMutableTreeNode resource = new DefaultMutableTreeNode(bdi);
                            HostBrowser.this.blockDevicesNode.add(resource);
                        }
                        HostBrowser.this.reloadAndWait(HostBrowser.this.blockDevicesNode, false);
                    }
                    finally {
                        HostBrowser.this.mBlockDevInfosWriteLock.unlock();
                    }
                }
            });
        }
        final Map<String, FSInfo> oldFilesystems = this.getFilesystemsMap();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HostBrowser.this.mFileSystemsWriteLock.lock();
                try {
                    HostBrowser.this.fileSystemsNode.removeAllChildren();
                    for (String fs : fss) {
                        FSInfo fsi = oldFilesystems.containsKey(fs) ? (FSInfo)oldFilesystems.get(fs) : new FSInfo(fs, thisClass);
                        DefaultMutableTreeNode resource = new DefaultMutableTreeNode(fsi);
                        HostBrowser.this.setNode(resource);
                        HostBrowser.this.fileSystemsNode.add(resource);
                    }
                    HostBrowser.this.reloadAndWait(HostBrowser.this.fileSystemsNode, false);
                }
                finally {
                    HostBrowser.this.mFileSystemsWriteLock.unlock();
                }
            }
        });
    }

    public Set<BlockDevInfo> getBlockDevInfos() {
        this.mBlockDevInfosReadLock.lock();
        LinkedHashSet<BlockDevInfo> values = new LinkedHashSet<BlockDevInfo>(new TreeSet<BlockDevInfo>(this.blockDevInfos.values()));
        this.mBlockDevInfosReadLock.unlock();
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<NetInterface, NetInfo> getNetInterfacesMap() {
        HashMap<NetInterface, NetInfo> netInterfaces = new HashMap<NetInterface, NetInfo>();
        this.mNetInfosReadLock.lock();
        try {
            Enumeration<TreeNode> e = this.netInterfacesNode.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode niNode = (DefaultMutableTreeNode)e.nextElement();
                NetInfo nii = (NetInfo)niNode.getUserObject();
                netInterfaces.put(nii.getNetInterface(), nii);
            }
        }
        finally {
            this.mNetInfosReadLock.unlock();
        }
        return netInterfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, FSInfo> getFilesystemsMap() {
        HashMap<String, FSInfo> filesystems = new HashMap<String, FSInfo>();
        this.mFileSystemsReadLock.lock();
        try {
            Enumeration<TreeNode> e = this.fileSystemsNode.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode fsiNode = (DefaultMutableTreeNode)e.nextElement();
                FSInfo fsi = (FSInfo)fsiNode.getUserObject();
                filesystems.put(fsi.getName(), fsi);
            }
        }
        finally {
            this.mFileSystemsReadLock.unlock();
        }
        return filesystems;
    }

    List<NetInfo> getNetInfos() {
        Enumeration<TreeNode> e = this.netInterfacesNode.children();
        ArrayList<NetInfo> netInfos = new ArrayList<NetInfo>();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode niNode = (DefaultMutableTreeNode)e.nextElement();
            NetInfo ni = (NetInfo)niNode.getUserObject();
            netInfos.add(ni);
        }
        return netInfos;
    }

    public void addAdvancedMenu(MyMenu submenu) {
        if (submenu.getItemCount() > 0) {
            return;
        }
        MyMenuItem panicMenuItem = new MyMenuItem(Tools.getString("HostBrowser.MakeKernelPanic") + this.host.getName(), null, new AccessMode(ConfigData.AccessType.GOD, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (!HostBrowser.this.host.isConnected()) {
                    return "not connected to the host";
                }
                return null;
            }

            @Override
            public void action() {
                String hostName = HostBrowser.this.host.getName();
                String command = "MakeKernelPanic";
                Tools.startProgressIndicator(hostName, HostBrowser.this.host.getDistString("MakeKernelPanic"));
                HostBrowser.this.host.execCommand("MakeKernelPanic", null, null, true, SSH.DEFAULT_COMMAND_TIMEOUT);
                Tools.stopProgressIndicator(hostName, HostBrowser.this.host.getDistString("MakeKernelPanic"));
            }
        };
        submenu.add(panicMenuItem);
        MyMenuItem rebootMenuItem = new MyMenuItem(Tools.getString("HostBrowser.MakeKernelReboot") + this.host.getName(), null, new AccessMode(ConfigData.AccessType.GOD, false), new AccessMode(ConfigData.AccessType.ADMIN, false)){
            private static final long serialVersionUID = 1L;

            @Override
            public String enablePredicate() {
                if (!HostBrowser.this.host.isConnected()) {
                    return "not connected to the host";
                }
                return null;
            }

            @Override
            public void action() {
                String hostName = HostBrowser.this.host.getName();
                String command = "MakeKernelReboot";
                Tools.startProgressIndicator(hostName, HostBrowser.this.host.getDistString("MakeKernelReboot"));
                HostBrowser.this.host.execCommand("MakeKernelReboot", null, null, true, SSH.DEFAULT_COMMAND_TIMEOUT);
                Tools.stopProgressIndicator(hostName, HostBrowser.this.host.getDistString("MakeKernelReboot"));
            }
        };
        submenu.add(rebootMenuItem);
    }

    public String getDrbdInfo() {
        StringBuilder tt = new StringBuilder(40);
        String drbdV = this.host.getDrbdVersion();
        String drbdModuleV = this.host.getDrbdModuleVersion();
        String drbdS = null;
        drbdS = drbdV == null || "".equals(drbdV) ? "not installed" : drbdV;
        String drbdModuleS = null;
        drbdModuleS = drbdModuleV == null || "".equals(drbdModuleV) ? "not installed" : drbdModuleV;
        tt.append("\nDRBD ");
        tt.append(drbdS);
        if (!drbdS.equals(drbdModuleS)) {
            tt.append("\nDRBD module ");
            tt.append(drbdModuleS);
        }
        if (this.host.isDrbdLoaded()) {
            tt.append(" (running)");
        } else {
            tt.append(" (not loaded)");
        }
        return tt.toString();
    }

    public String getPacemakerInfo() {
        StringBuilder tt = new StringBuilder(40);
        String pmV = this.host.getPacemakerVersion();
        String hbV = this.host.getHeartbeatVersion();
        StringBuilder hbRunning = new StringBuilder(20);
        if (this.host.isHeartbeatRunning()) {
            hbRunning.append("running");
            if (!this.host.isHeartbeatRc()) {
                hbRunning.append("/no rc.d");
            }
        } else {
            hbRunning.append("not running");
        }
        if (this.host.isHeartbeatRc()) {
            hbRunning.append("/rc.d");
        }
        if (pmV == null) {
            if (hbV != null) {
                tt.append(" \nHeartbeat ");
                tt.append(hbV);
                tt.append(" (");
                tt.append(hbRunning.toString());
                tt.append(')');
            }
        } else {
            String pmRunning = this.host.isClStatus() ? "running" : "not running";
            tt.append(" \nPacemaker ");
            tt.append(pmV);
            tt.append(" (");
            tt.append(pmRunning);
            tt.append(')');
            String corOrAis = null;
            String corV = this.host.getCorosyncVersion();
            String aisV = this.host.getOpenaisVersion();
            if (corV != null) {
                corOrAis = "Corosync " + corV;
            } else if (aisV != null) {
                corOrAis = "Openais " + aisV;
            }
            if (hbV != null && this.host.isHeartbeatRunning()) {
                tt.append(" \nHeartbeat ");
                tt.append(hbV);
                tt.append(" (");
                tt.append(hbRunning.toString());
                tt.append(')');
            }
            if (corOrAis != null) {
                tt.append(" \n");
                tt.append(corOrAis);
                tt.append(" (");
                if (this.host.isCsRunning() || this.host.isAisRunning()) {
                    tt.append("running");
                    if (!this.host.isCsRc() && !this.host.isAisRc()) {
                        tt.append("/no rc.d");
                    }
                } else {
                    tt.append("not running");
                }
                if (this.host.isCsRc() || this.host.isAisRc()) {
                    tt.append("/rc.d");
                }
                tt.append(')');
            }
            if (hbV != null && !this.host.isHeartbeatRunning()) {
                tt.append(" \nHeartbeat ");
                tt.append(hbV);
                tt.append(" (");
                tt.append(hbRunning.toString());
                tt.append(')');
            }
        }
        return tt.toString();
    }

    public String getHostToolTip(Host host) {
        StringBuilder tt = new StringBuilder(80);
        tt.append("<b>" + host.getName() + "</b>");
        ClusterBrowser b = this.getClusterBrowser();
        if (b != null && b.isRealDcHost(host)) {
            tt.append(" (designated co-ordinator)");
        }
        if (!host.isConnected()) {
            tt.append('\n');
            tt.append(Tools.getString("ClusterBrowser.Host.Disconnected"));
        } else if (!host.isDrbdStatus() && !host.isClStatus()) {
            tt.append('\n');
            tt.append(Tools.getString("ClusterBrowser.Host.Offline"));
        }
        tt.append(this.getDrbdInfo());
        tt.append(this.getPacemakerInfo());
        return tt.toString();
    }

    public DrbdGraph getDrbdGraph() {
        ClusterBrowser b = this.getClusterBrowser();
        if (b == null) {
            return null;
        }
        return b.getDrbdGraph();
    }

    public Set<String> getUsedPorts() {
        return this.usedPorts;
    }

    public Set<String> getUsedProxyPorts() {
        return this.usedProxyPorts;
    }

    public void lockBlockDevInfosRead() {
        this.mBlockDevInfosReadLock.lock();
    }

    public void unlockBlockDevInfosRead() {
        this.mBlockDevInfosReadLock.unlock();
    }

    public DefaultMutableTreeNode getNetInterfacesNode() {
        return this.netInterfacesNode;
    }
}

