/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lcmc.AddClusterDialog;
import lcmc.AddHostDialog;
import lcmc.data.Host;
import lcmc.gui.Browser;
import lcmc.gui.EmptyBrowser;
import lcmc.gui.ViewPanel;
import lcmc.utilities.AllHostsUpdatable;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;

final class EmptyViewPanel
extends ViewPanel
implements AllHostsUpdatable {
    private static final long serialVersionUID = 1L;
    private final EmptyBrowser browser = new EmptyBrowser();
    private static final Color STATUS_BACKGROUND = Tools.getDefaultColor("ViewPanel.Status.Background");
    private static final ImageIcon CLUSTER_ICON = Tools.createImageIcon(Tools.getDefault("ClusterTab.ClusterIcon"));
    private static final ImageIcon HOST_ICON = Tools.createImageIcon(Tools.getDefault("HostTab.HostIcon"));
    private static final Dimension BIG_BUTTON_DIMENSION = new Dimension(300, 100);
    private static final String LOGO_PANEL_STRING = "LOGO-STRING";

    EmptyViewPanel() {
        Tools.getGUIData().setEmptyBrowser(this.browser);
        this.browser.setEmptyViewPanel(this);
        this.browser.initHosts();
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.setMinimumSize(new Dimension(0, 110));
        buttonPanel.setPreferredSize(new Dimension(0, 110));
        buttonPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 110));
        buttonPanel.setBackground(STATUS_BACKGROUND);
        this.add((Component)buttonPanel, "North");
        JPanel logoPanel = new JPanel(new CardLayout());
        logoPanel.setBackground(Color.WHITE);
        ImageIcon logoImage = Tools.createImageIcon("startpage_head.jpg");
        JLabel logo = new JLabel(logoImage);
        JPanel lPanel = new JPanel(new FlowLayout(0, 0, 0));
        lPanel.setBackground(Color.WHITE);
        lPanel.add(logo);
        logoPanel.add((Component)lPanel, LOGO_PANEL_STRING);
        JPanel smallButtonPanel = new JPanel();
        smallButtonPanel.setBackground(STATUS_BACKGROUND);
        smallButtonPanel.setLayout(new BoxLayout(smallButtonPanel, 1));
        buttonPanel.add(smallButtonPanel);
        smallButtonPanel.add(Tools.getGUIData().getClustersPanel().registerUpgradeTextField());
        final MyButton addHostButton = new MyButton(Tools.getString("ClusterTab.AddNewHost"), HOST_ICON);
        addHostButton.setBackgroundColor(Browser.STATUS_BACKGROUND);
        addHostButton.setPreferredSize(BIG_BUTTON_DIMENSION);
        addHostButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        AddHostDialog ahd = new AddHostDialog(new Host());
                        ahd.showDialogs();
                    }
                });
                thread.start();
            }
        });
        Tools.getGUIData().registerAddHostButton(addHostButton);
        buttonPanel.add(addHostButton);
        this.createEmptyView();
        this.add((Component)logoPanel, "South");
        Tools.getGUIData().registerAllHostsUpdate(this);
        Tools.getGUIData().allHostsUpdate();
        MyButton addClusterButton = new MyButton(Tools.getString("ClusterTab.AddNewCluster"), CLUSTER_ICON);
        addClusterButton.setBackgroundColor(Browser.STATUS_BACKGROUND);
        addClusterButton.setPreferredSize(BIG_BUTTON_DIMENSION);
        addClusterButton.setMinimumSize(BIG_BUTTON_DIMENSION);
        addClusterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        AddClusterDialog acd = new AddClusterDialog();
                        acd.showDialogs();
                    }
                });
                thread.start();
            }
        });
        Tools.getGUIData().registerAddClusterButton(addClusterButton);
        Tools.getGUIData().checkAddClusterButtons();
        buttonPanel.add(addClusterButton);
        if (!Tools.getConfigData().getAutoHosts().isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    addHostButton.pressButton();
                }
            });
        }
    }

    private void createEmptyView() {
        this.getTree(this.browser);
        this.browser.updateHosts();
    }

    @Override
    public void allHostsUpdate() {
        this.browser.updateHosts();
    }
}

