/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.util.VertexShapeFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import lcmc.data.Host;
import lcmc.data.Subtext;
import lcmc.data.resources.BlockDevice;
import lcmc.gui.Browser;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.HostBrowser;
import lcmc.gui.ResourceGraph;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.resources.DrbdInfo;
import lcmc.gui.resources.DrbdMultiSelectionInfo;
import lcmc.gui.resources.DrbdVolumeInfo;
import lcmc.gui.resources.HostDrbdInfo;
import lcmc.gui.resources.Info;
import lcmc.utilities.Tools;

public final class DrbdGraph
extends ResourceGraph {
    private final Map<ResourceGraph.Vertex, HostDrbdInfo> vertexToHostMap = new LinkedHashMap<ResourceGraph.Vertex, HostDrbdInfo>();
    private final Map<HostDrbdInfo, ResourceGraph.Vertex> hostToVertexMap = new LinkedHashMap<HostDrbdInfo, ResourceGraph.Vertex>();
    private final Map<BlockDevInfo, ResourceGraph.Vertex> bdiToVertexMap = new LinkedHashMap<BlockDevInfo, ResourceGraph.Vertex>();
    private final Map<BlockDevice, ResourceGraph.Vertex> blockDeviceToVertexMap = new LinkedHashMap<BlockDevice, ResourceGraph.Vertex>();
    private final Map<HostDrbdInfo, List<ResourceGraph.Vertex>> hostBDVerticesMap = new LinkedHashMap<HostDrbdInfo, List<ResourceGraph.Vertex>>();
    private final Map<ResourceGraph.Edge, DrbdVolumeInfo> edgeToDrbdVolumeMap = new LinkedHashMap<ResourceGraph.Edge, DrbdVolumeInfo>();
    private final Map<DrbdVolumeInfo, ResourceGraph.Edge> drbdVolumeToEdgeMap = new LinkedHashMap<DrbdVolumeInfo, ResourceGraph.Edge>();
    private DrbdInfo drbdInfo;
    private Info multiSelectionInfo = null;
    private static final int BD_STEP_Y = 60;
    private static final int HOST_Y_POS = 40;
    private static final int HOST_STEP_X = 280;
    private static final int VERTEX_SIZE_BD = 200;
    private static final int VERTEX_SIZE_HOST = 150;
    private static final int HOST_VERTEX_HEIGHT = 50;
    private static final int VERTEX_HEIGHT = 50;
    private static final int MAX_VERTEX_STRING_LENGTH = 18;
    private static final int BD_X_OFFSET = 15;
    private int hostDefaultXPos = 10;
    private static final int MIN_Y_POS = 20;
    private static final int MAX_X_POS = 2600;
    private static final int MAX_Y_POS = 2600;

    public DrbdGraph(ClusterBrowser clusterBrowser) {
        super(clusterBrowser);
    }

    @Override
    protected void initGraph() {
        super.initGraph(new DirectedSparseGraph<ResourceGraph.Vertex, ResourceGraph.Edge>());
    }

    public void setDrbdInfo(DrbdInfo drbdInfo) {
        this.drbdInfo = drbdInfo;
    }

    public DrbdInfo getDrbdInfo() {
        return this.drbdInfo;
    }

    private boolean isVertexBlockDevice(ResourceGraph.Vertex v) {
        return this.vertexToHostMap.get(v) != this.getInfo(v);
    }

    void addHost(HostDrbdInfo hostDrbdInfo) {
        ResourceGraph.Vertex bdv;
        ResourceGraph.Vertex v = this.getVertex(hostDrbdInfo);
        if (v == null) {
            v = new ResourceGraph.Vertex();
            this.somethingChanged();
            this.putInfoToVertex(hostDrbdInfo, v);
            this.vertexToHostMap.put(v, hostDrbdInfo);
            this.hostToVertexMap.put(hostDrbdInfo, v);
            this.putVertexToInfo(v, hostDrbdInfo);
            Point2D hostPos = this.getSavedPosition(hostDrbdInfo);
            if (hostPos == null) {
                hostPos = new Point2D.Double(this.hostDefaultXPos + 75, 40.0);
                this.hostDefaultXPos += 280;
            }
            double hostXPos = hostPos.getX() - 75.0;
            this.getVertexLocations().put(v, hostPos);
            this.putVertexLocations();
            this.lockGraph();
            this.getGraph().addVertex(v);
            this.unlockGraph();
        }
        Host host = hostDrbdInfo.getHost();
        Point2D hostPos = this.getVertexLocations().get(v);
        this.putVertexLocations();
        double hostXPos = hostPos.getX() - 75.0;
        double hostYPos = hostPos.getY();
        int devYPos = (int)hostYPos + 60;
        List<ResourceGraph.Vertex> vertexList = this.hostBDVerticesMap.get(hostDrbdInfo);
        ArrayList<ResourceGraph.Vertex> oldVertexList = null;
        if (vertexList == null) {
            vertexList = new ArrayList<ResourceGraph.Vertex>();
            this.hostBDVerticesMap.put(hostDrbdInfo, vertexList);
        } else {
            oldVertexList = new ArrayList<ResourceGraph.Vertex>(vertexList);
        }
        Set<BlockDevInfo> blockDevInfos = host.getBrowser().getBlockDevInfos();
        if (oldVertexList != null) {
            for (ResourceGraph.Vertex vertex : oldVertexList) {
                BlockDevInfo bdi = (BlockDevInfo)this.getInfo(vertex);
                if (bdi == null || blockDevInfos.contains(bdi)) continue;
                bdv = this.bdiToVertexMap.get(bdi);
                DrbdVolumeInfo dvi = bdi.getDrbdVolumeInfo();
                if (dvi != null) {
                    this.removeDrbdVolume(dvi);
                    dvi.getDrbdResourceInfo().removeDrbdVolumeFromHashes(dvi);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DrbdGraph.this.lockGraph();
                        DrbdGraph.this.getGraph().removeVertex(bdv);
                        DrbdGraph.this.unlockGraph();
                    }
                });
                this.removeInfo(bdv);
                this.removeVertex(bdi);
                this.getVertexToMenus().remove(bdv);
                this.bdiToVertexMap.remove(bdi);
                this.blockDeviceToVertexMap.remove(bdi.getBlockDevice());
                this.vertexToHostMap.remove(bdv);
                vertexList.remove(bdv);
                this.somethingChanged();
            }
        }
        BlockDevInfo prevBdi = null;
        for (BlockDevInfo bdi : blockDevInfos) {
            this.stopAnimation(bdi);
            bdv = null;
            if (!this.blockDeviceToVertexMap.containsKey(bdi.getBlockDevice())) {
                bdv = new ResourceGraph.Vertex();
                this.somethingChanged();
                this.bdiToVertexMap.put(bdi, bdv);
                this.blockDeviceToVertexMap.put(bdi.getBlockDevice(), bdv);
                this.putVertexToInfo(bdv, bdi);
                this.putInfoToVertex(bdi, bdv);
                this.vertexToHostMap.put(bdv, hostDrbdInfo);
                vertexList.add(bdv);
            }
            if (bdv == null) {
                bdv = this.blockDeviceToVertexMap.get(bdi.getBlockDevice());
            }
            if (prevBdi != null && bdi.getBlockDevice().isVolumeGroupOnPhysicalVolume() && bdi.getBlockDevice().getVolumeGroupOnPhysicalVolume().equals(prevBdi.getBlockDevice().getVolumeGroupOnPhysicalVolume())) {
                devYPos -= 8;
            } else if (!(prevBdi == null || bdi.getBlockDevice().isDrbd() && prevBdi.getBlockDevice().isDrbd())) {
                devYPos -= 4;
            } else if (prevBdi != null && bdi.getBlockDevice().isDrbd() && prevBdi.getBlockDevice().isDrbd() && bdi.getDrbdVolumeInfo().getDrbdResourceInfo() == prevBdi.getDrbdVolumeInfo().getDrbdResourceInfo()) {
                devYPos -= 6;
            }
            Point2D.Double pos = null;
            pos = new Point2D.Double(hostXPos + 15.0 + 100.0, devYPos);
            devYPos += 60;
            this.getVertexLocations().put(bdv, pos);
            this.putVertexLocations();
            this.getLayout().setLocation(bdv, pos);
            if (bdv != null) {
                this.lockGraph();
                this.getGraph().addVertex(bdv);
                this.unlockGraph();
            }
            prevBdi = bdi;
        }
    }

    @Override
    public void scale() {
        for (HostDrbdInfo hostDrbdInfo : this.hostBDVerticesMap.keySet()) {
            this.addHost(hostDrbdInfo);
        }
        super.scale();
    }

    public void removeDrbdVolume(DrbdVolumeInfo dvi) {
        final ResourceGraph.Edge e = this.drbdVolumeToEdgeMap.get(dvi);
        if (e == null) {
            return;
        }
        e.reset();
        this.edgeToDrbdVolumeMap.remove(e);
        this.drbdVolumeToEdgeMap.remove(dvi);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DrbdGraph.this.lockGraph();
                    DrbdGraph.this.getGraph().removeEdge(e);
                    DrbdGraph.this.unlockGraph();
                }
                catch (Exception ignore) {
                    DrbdGraph.this.unlockGraph();
                }
            }
        });
    }

    @Override
    protected List<ImageIcon> getIconsForVertex(ResourceGraph.Vertex v, boolean testOnly) {
        ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>();
        if (this.isVertexBlockDevice(v)) {
            BlockDevInfo bdi = (BlockDevInfo)this.getInfo(v);
            if (bdi == null) {
                return icons;
            }
            if (bdi != null && bdi.getBlockDevice().isDrbd()) {
                icons.add(BlockDevInfo.HARDDISK_DRBD_ICON_LARGE);
            } else {
                icons.add(BlockDevInfo.HARDDISK_ICON_LARGE);
            }
            if (bdi.isDiskless(testOnly)) {
                icons.add(BlockDevInfo.NO_HARDDISK_ICON_LARGE);
                return icons;
            }
            return icons;
        }
        HostDrbdInfo hi = this.vertexToHostMap.get(v);
        if (hi == null) {
            return null;
        }
        if (hi.getHost().isDrbdStatus() && hi.getHost().isDrbdLoaded()) {
            icons.add(HostBrowser.HOST_ON_ICON_LARGE);
        } else {
            icons.add(HostBrowser.HOST_ICON_LARGE);
        }
        return icons;
    }

    @Override
    protected String getLabelForEdgeStringer(ResourceGraph.Edge edge) {
        DrbdVolumeInfo dvi = this.edgeToDrbdVolumeMap.get(edge);
        if (dvi != null && dvi.getName() != null && dvi.getDrbdResourceInfo() != null) {
            StringBuilder l;
            ResourceGraph.Vertex source = edge.getSource();
            ResourceGraph.Vertex dest = edge.getDest();
            BlockDevInfo sourceBDI = (BlockDevInfo)this.getInfo(source);
            if (sourceBDI == null) {
                return "";
            }
            BlockDevInfo destBDI = (BlockDevInfo)this.getInfo(dest);
            if (destBDI == null) {
                return "";
            }
            BlockDevice sourceBD = sourceBDI.getBlockDevice();
            BlockDevice destBD = destBDI.getBlockDevice();
            boolean tOnly = this.isTestOnly();
            if (!destBDI.isConnected(tOnly)) {
                if (sourceBDI.isWFConnection(tOnly) && !destBDI.isWFConnection(tOnly)) {
                    edge.setDirection(dest, source);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DrbdGraph.this.repaint();
                        }
                    });
                }
            } else if (!sourceBD.isPrimary() && destBD.isPrimary()) {
                edge.setDirection(dest, source);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DrbdGraph.this.repaint();
                    }
                });
            }
            if ((l = new StringBuilder(dvi.getNameForGraph())) != null) {
                Map<ResourceGraph.Vertex, Point2D> vl = this.getVertexLocations();
                Point2D sp = vl.get(source);
                Point2D dp = vl.get(dest);
                this.putVertexLocations();
                int len = (int)Math.sqrt(Math.pow(sp.getX() - dp.getX(), 2.0) + Math.pow(sp.getY() - dp.getY(), 2.0));
                int maxLen = (len - 200) / 7;
                if (l.length() > maxLen) {
                    l.delete(0, l.length() - maxLen + 3);
                    l.insert(0, "...");
                }
                if (dvi.isSyncing()) {
                    String syncedProgress = dvi.getSyncedProgress();
                    if (syncedProgress == null) {
                        syncedProgress = "?.?";
                    }
                    double sourceX = ((Point2D)this.getLayout().transform((Object)source)).getX();
                    double destX = ((Point2D)this.getLayout().transform((Object)dest)).getX();
                    if (sourceBD.isPausedSync() || destBD.isPausedSync()) {
                        l.append(" (" + syncedProgress + "% paused)");
                    } else if (sourceBD.isSyncSource() && sourceX < destX || destBD.isSyncSource() && sourceX > destX) {
                        l.append(" (" + syncedProgress + "% \u2192)");
                    } else {
                        l.append(" (\u2190 " + syncedProgress + "%)");
                    }
                } else if (dvi.isSplitBrain()) {
                    l.append(" (split-brain)");
                } else if (!dvi.isConnected(tOnly)) {
                    l.append(" (disconnected)");
                } else if (dvi.isVerifying()) {
                    l.append(" (verify)");
                }
                return l.toString();
            }
        }
        return null;
    }

    @Override
    protected String getIconText(ResourceGraph.Vertex v, boolean testOnly) {
        if (this.isVertexBlockDevice(v)) {
            BlockDevInfo bdi = (BlockDevInfo)this.getInfo(v);
            if (bdi != null) {
                return bdi.getIconTextForGraph(testOnly);
            }
        } else {
            HostDrbdInfo hi = this.vertexToHostMap.get(v);
            if (hi != null) {
                return hi.getIconTextForDrbdGraph(testOnly);
            }
        }
        return null;
    }

    @Override
    protected Subtext getRightCornerText(ResourceGraph.Vertex v, boolean testOnly) {
        if (this.isVertexBlockDevice(v)) {
            BlockDevInfo bdi = (BlockDevInfo)this.getInfo(v);
            if (bdi != null) {
                return bdi.getRightCornerTextForDrbdGraph(testOnly);
            }
        } else {
            HostDrbdInfo hi = this.vertexToHostMap.get(v);
            if (hi != null) {
                return hi.getRightCornerTextForDrbdGraph(testOnly);
            }
        }
        return null;
    }

    @Override
    protected Subtext[] getSubtexts(ResourceGraph.Vertex v, boolean testOnly) {
        if (this.isVertexBlockDevice(v)) {
            BlockDevInfo bdi = (BlockDevInfo)this.getInfo(v);
            if (bdi != null && bdi.getBlockDevice().isDrbd() && bdi.getBlockDevice().getConnectionState() != null && bdi.getBlockDevice().getDiskState() != null) {
                String connState = bdi.getBlockDevice().getConnectionState();
                String diskState = bdi.getBlockDevice().getDiskState();
                Color color = null;
                Color textColor = Color.BLACK;
                String proxyState = bdi.getProxyStateForGraph(testOnly);
                if ("StandAlone".equals(connState) || !"UpToDate".equals(diskState) || proxyState != null && !"Proxy Up".equals(proxyState)) {
                    color = Color.RED;
                    textColor = Color.WHITE;
                }
                return new Subtext[]{new Subtext(Tools.join(" / ", new String[]{connState, diskState, proxyState}), color, textColor)};
            }
        } else {
            HostDrbdInfo hi = this.vertexToHostMap.get(v);
            if (hi != null) {
                return hi.getSubtextsForDrbdGraph(testOnly);
            }
        }
        return null;
    }

    @Override
    public String getMainText(ResourceGraph.Vertex v, boolean testOnly) {
        if (this.isVertexBlockDevice(v)) {
            String l;
            if (this.isVertexDrbd(v)) {
                BlockDevInfo bdi = (BlockDevInfo)this.getInfo(v);
                if (bdi == null) {
                    return "";
                }
                l = bdi.getDrbdVolumeInfo().getDevice();
            } else {
                Info info = this.getInfo(v);
                if (info == null) {
                    return "";
                }
                l = info.getMainTextForGraph();
            }
            if (l.length() > 18) {
                l = "..." + l.substring(l.length() - 18 + 3, l.length());
            }
            return l;
        }
        if (this.vertexToHostMap.containsKey(v)) {
            return this.vertexToHostMap.get(v).toString();
        }
        return "";
    }

    @Override
    protected Shape getVertexShape(ResourceGraph.Vertex v, VertexShapeFactory<ResourceGraph.Vertex> factory) {
        return factory.getRectangle(v);
    }

    @Override
    protected JPopupMenu handlePopupVertex(ResourceGraph.Vertex v, List<ResourceGraph.Vertex> pickedV, Point2D p) {
        Info msi;
        if (pickedV.size() > 1 && (msi = this.multiSelectionInfo) != null) {
            return msi.getPopup();
        }
        if (this.isVertexBlockDevice(v)) {
            BlockDevInfo bdi = (BlockDevInfo)this.getInfo(v);
            if (bdi == null) {
                return null;
            }
            return bdi.getPopup();
        }
        HostDrbdInfo hi = (HostDrbdInfo)this.getInfo(v);
        if (hi == null) {
            return null;
        }
        return hi.getPopup();
    }

    public void addDrbdVolume(DrbdVolumeInfo dvi, BlockDevInfo bdi1, BlockDevInfo bdi2) {
        if (bdi1 != null && bdi2 != null) {
            ResourceGraph.Vertex v1 = this.bdiToVertexMap.get(bdi1);
            ResourceGraph.Vertex v2 = this.bdiToVertexMap.get(bdi2);
            this.lockGraph();
            if (this.getGraph().findEdge(v1, v2) != null || this.getGraph().findEdge(v2, v1) != null) {
                this.unlockGraph();
                return;
            }
            ResourceGraph.Edge e = new ResourceGraph.Edge(this, v1, v2);
            this.getGraph().addEdge(e, v1, v2);
            this.unlockGraph();
            this.edgeToDrbdVolumeMap.put(e, dvi);
            this.drbdVolumeToEdgeMap.put(dvi, e);
        }
    }

    public BlockDevInfo getSource(DrbdVolumeInfo dvi) {
        ResourceGraph.Edge edge = this.drbdVolumeToEdgeMap.get(dvi);
        ResourceGraph.Vertex source = edge.getSource();
        return (BlockDevInfo)this.getInfo(source);
    }

    public BlockDevInfo getDest(DrbdVolumeInfo dvi) {
        ResourceGraph.Edge edge = this.drbdVolumeToEdgeMap.get(dvi);
        if (edge == null) {
            return null;
        }
        ResourceGraph.Vertex dest = edge.getDest();
        return (BlockDevInfo)this.getInfo(dest);
    }

    @Override
    public void pickInfo(Info i) {
        ResourceGraph.Edge e = this.drbdVolumeToEdgeMap.get(i);
        if (e == null) {
            super.pickInfo(i);
        } else {
            this.pickEdge(e);
        }
    }

    @Override
    protected JPopupMenu handlePopupEdge(ResourceGraph.Edge edge) {
        DrbdVolumeInfo dvi = this.edgeToDrbdVolumeMap.get(edge);
        return dvi.getPopup();
    }

    @Override
    protected JPopupMenu handlePopupBackground(Point2D pos) {
        return this.getDrbdInfo().getPopup(pos);
    }

    public void pickBlockDevice(BlockDevInfo bdi) {
        ResourceGraph.Vertex v = this.bdiToVertexMap.get(bdi);
        this.pickVertex(v);
        bdi.selectMyself();
    }

    private void pickHost(ResourceGraph.Vertex v) {
        this.pickVertex(v);
        HostDrbdInfo hi = this.vertexToHostMap.get(v);
        if (hi == null) {
            return;
        }
        Tools.getGUIData().setTerminalPanel(hi.getHost().getTerminalPanel());
    }

    @Override
    protected void oneVertexPressed(ResourceGraph.Vertex v) {
        if (this.isVertexBlockDevice(v)) {
            this.pickHost(v);
            BlockDevInfo bdi = (BlockDevInfo)this.getInfo(v);
            if (bdi == null) {
                return;
            }
            this.drbdInfo.setSelectedNode(bdi);
            this.drbdInfo.selectMyself();
            this.getClusterBrowser().setRightComponentInView(bdi);
        } else {
            this.pickHost(v);
            HostDrbdInfo hi = this.vertexToHostMap.get(v);
            if (hi == null) {
                return;
            }
            this.getClusterBrowser().setRightComponentInView(hi);
        }
    }

    @Override
    protected void vertexReleased(ResourceGraph.Vertex v, Point2D pos) {
        double x = pos.getX();
        double y = pos.getY();
        double minPos = (this.getVertexWidth(v) - this.getDefaultVertexWidth(v)) / 2;
        x = x < minPos ? minPos : x;
        x = x > 2600.0 ? 2600.0 : x;
        y = y < 20.0 ? 20.0 : y;
        y = y > 2600.0 ? 2600.0 : y;
        pos.setLocation(x + (double)((this.getDefaultVertexWidth(v) - this.getVertexWidth(v)) / 2), y);
        Point2D.Double loc = new Point2D.Double(x, y);
        this.getVertexLocations().put(v, pos);
        this.putVertexLocations();
        this.getLayout().setLocation(v, loc);
    }

    private boolean isVertexAvailable(ResourceGraph.Vertex v) {
        BlockDevInfo bdi = (BlockDevInfo)this.getInfo(v);
        if (bdi != null) {
            return bdi.getBlockDevice().isAvailable();
        }
        return false;
    }

    private boolean isVertexDrbd(ResourceGraph.Vertex v) {
        BlockDevInfo bdi = (BlockDevInfo)this.getInfo(v);
        if (bdi != null) {
            return bdi.getBlockDevice().isDrbd();
        }
        return false;
    }

    private boolean isVertexPrimary(ResourceGraph.Vertex v) {
        BlockDevInfo bdi = (BlockDevInfo)this.getInfo(v);
        if (bdi != null) {
            return bdi.getBlockDevice().isPrimary();
        }
        return false;
    }

    private boolean isVertexSecondary(ResourceGraph.Vertex v) {
        BlockDevInfo bdi = (BlockDevInfo)this.getInfo(v);
        if (bdi != null) {
            return bdi.getBlockDevice().isSecondary();
        }
        return false;
    }

    @Override
    protected void oneEdgePressed(ResourceGraph.Edge e) {
        DrbdVolumeInfo dvi = this.edgeToDrbdVolumeMap.get(e);
        if (dvi != null) {
            dvi.selectMyself();
        }
    }

    @Override
    protected void backgroundClicked() {
        this.drbdInfo.setSelectedNode(null);
        this.drbdInfo.selectMyself();
    }

    @Override
    protected Color getVertexFillColor(ResourceGraph.Vertex v) {
        HostDrbdInfo hi = this.vertexToHostMap.get(v);
        ResourceGraph.Vertex hostVertex = this.getVertex(hi);
        if (v.equals(hostVertex)) {
            return hi.getHost().getDrbdColors()[0];
        }
        if (hi != null && (hi.getHost() == null || !hi.getHost().isDrbdStatus() && hi.getHost().isDrbdLoaded())) {
            return Tools.getDefaultColor("DrbdGraph.FillPaintUnknown");
        }
        if (!this.isVertexDrbd(v)) {
            if (this.isVertexAvailable(v)) {
                return super.getVertexFillColor(v);
            }
            return Tools.getDefaultColor("DrbdGraph.FillPaintNotAvailable");
        }
        if (this.isVertexPrimary(v)) {
            return Tools.getDefaultColor("DrbdGraph.FillPaintPrimary");
        }
        if (this.isVertexSecondary(v)) {
            return Tools.getDefaultColor("DrbdGraph.FillPaintSecondary");
        }
        return Tools.getDefaultColor("DrbdGraph.FillPaintUnknown");
    }

    @Override
    protected Color getVertexFillSecondaryColor(ResourceGraph.Vertex v) {
        if (!this.isVertexBlockDevice(v)) {
            return Color.WHITE;
        }
        BlockDevInfo bdi = (BlockDevInfo)this.getInfo(v);
        if (bdi == null) {
            return Color.WHITE;
        }
        if (bdi.isFirstDrbdVolume()) {
            return Color.WHITE;
        }
        return this.getVertexFillColor(v);
    }

    BlockDevice findBlockDevice(String hostName, String disk) {
        BlockDevInfo bdi = this.findBlockDevInfo(hostName, disk);
        if (bdi == null) {
            return null;
        }
        return bdi.getBlockDevice();
    }

    public BlockDevInfo findBlockDevInfo(String hostName, String disk) {
        HostDrbdInfo h;
        HostDrbdInfo hi = null;
        Iterator<Object> i$ = this.hostBDVerticesMap.keySet().iterator();
        while (i$.hasNext() && !(hi = (h = i$.next())).toString().equals(hostName)) {
        }
        if (hi == null) {
            return null;
        }
        for (ResourceGraph.Vertex v : this.hostBDVerticesMap.get(hi)) {
            BlockDevInfo bdi = (BlockDevInfo)this.getInfo(v);
            if (bdi == null || !bdi.getName().equals(disk) && !bdi.getBlockDevice().getReadlink().equals(disk)) continue;
            return bdi;
        }
        return null;
    }

    @Override
    String getVertexToolTip(ResourceGraph.Vertex v) {
        Info i = this.getInfo(v);
        if (i == null) {
            return null;
        }
        return i.getToolTipForGraph(this.isTestOnly());
    }

    @Override
    String getEdgeToolTip(ResourceGraph.Edge edge) {
        DrbdVolumeInfo dvi = this.edgeToDrbdVolumeMap.get(edge);
        return dvi.getToolTipForGraph(this.isTestOnly());
    }

    @Override
    protected boolean showEdgeArrow(ResourceGraph.Edge edge) {
        BlockDevInfo sourceBDI = (BlockDevInfo)this.getInfo(edge.getSource());
        BlockDevInfo destBDI = (BlockDevInfo)this.getInfo(edge.getDest());
        if (sourceBDI == null || destBDI == null) {
            return false;
        }
        BlockDevice sourceBD = sourceBDI.getBlockDevice();
        BlockDevice destBD = destBDI.getBlockDevice();
        boolean tOnly = this.isTestOnly();
        if (sourceBDI.isConnected(tOnly) && sourceBD.isPrimary() != destBD.isPrimary()) {
            return true;
        }
        return sourceBDI.isWFConnection(tOnly) ^ destBDI.isWFConnection(tOnly);
    }

    @Override
    protected Paint getEdgeDrawPaint(ResourceGraph.Edge edge) {
        DrbdVolumeInfo dvi = this.edgeToDrbdVolumeMap.get(edge);
        if (dvi != null && dvi.isConnected(this.isTestOnly()) && !dvi.isSplitBrain()) {
            return super.getEdgeDrawPaint(edge);
        }
        return Tools.getDefaultColor("DrbdGraph.EdgeDrawPaintDisconnected");
    }

    @Override
    protected Paint getEdgePickedPaint(ResourceGraph.Edge edge) {
        DrbdVolumeInfo dvi = this.edgeToDrbdVolumeMap.get(edge);
        if (dvi != null && dvi.isConnected(this.isTestOnly()) && !dvi.isSplitBrain()) {
            return super.getEdgePickedPaint(edge);
        }
        return Tools.getDefaultColor("DrbdGraph.EdgeDrawPaintDisconnectedBrighter");
    }

    @Override
    protected String getId(Info i) {
        HostDrbdInfo hi;
        ResourceGraph.Vertex v = this.getVertex(i);
        String hiId = "";
        if (v != null && (hi = this.vertexToHostMap.get(v)) != null) {
            hiId = hi.getId();
        }
        return "dr=" + hiId + i.getId();
    }

    @Override
    protected int getDefaultVertexWidth(ResourceGraph.Vertex v) {
        if (this.isVertexBlockDevice(v)) {
            return 200;
        }
        return 150;
    }

    @Override
    protected int getDefaultVertexHeight(ResourceGraph.Vertex v) {
        if (this.isVertexBlockDevice(v)) {
            return 50;
        }
        return 50;
    }

    protected int getUsed(ResourceGraph.Vertex v) {
        if (this.isVertexBlockDevice(v)) {
            BlockDevInfo bdi = (BlockDevInfo)this.getInfo(v);
            if (bdi == null) {
                return 0;
            }
            return bdi.getUsed();
        }
        HostDrbdInfo hi = this.vertexToHostMap.get(v);
        if (hi == null) {
            return 0;
        }
        return hi.getUsed();
    }

    @Override
    protected void drawInside(ResourceGraph.Vertex v, Graphics2D g2d, double x, double y, Shape shape) {
        double used = this.getUsed(v);
        float height = (float)shape.getBounds().getHeight();
        float width = (float)shape.getBounds().getWidth();
        if (this.isVertexBlockDevice(v)) {
            BlockDevInfo bdi = (BlockDevInfo)this.getInfo(v);
            if (bdi != null && bdi.getBlockDevice().isDrbdMetaDisk()) {
                Color[] colors = new Color[]{null, null};
                colors[1] = this.getVertexFillColor(this.blockDeviceToVertexMap.get(bdi.getBlockDevice().getMetaDiskOfBlockDevices().get(0)));
                this.drawInsideVertex(g2d, v, colors, x, y, height, width);
            }
        } else {
            HostDrbdInfo hi = (HostDrbdInfo)this.getInfo(v);
            if (hi != null) {
                this.drawInsideVertex(g2d, v, hi.getHost().getDrbdColors(), x, y, height, width);
            }
        }
        boolean tOnly = this.isTestOnly();
        if (used > 0.0) {
            double freeWidth = (double)width * (100.0 - used) / 100.0;
            g2d.setColor(new Color(255, 255, 255, 220));
            g2d.fillRect((int)(x + (double)width - freeWidth), (int)y, (int)freeWidth, (int)height);
        }
        if (this.isPicked(v)) {
            if (tOnly) {
                g2d.setColor(Color.RED);
            } else {
                g2d.setColor(Color.BLACK);
            }
        } else {
            boolean pickedResource = false;
            if (tOnly) {
                this.lockGraph();
                for (ResourceGraph.Edge e : this.getGraph().getInEdges(v)) {
                    if (!this.isPicked(e)) continue;
                    pickedResource = true;
                    break;
                }
                if (!pickedResource) {
                    for (ResourceGraph.Edge e : this.getGraph().getOutEdges(v)) {
                        if (!this.isPicked(e)) continue;
                        pickedResource = true;
                        break;
                    }
                }
                this.unlockGraph();
            }
            if (pickedResource) {
                g2d.setColor(Color.RED);
            } else {
                g2d.setColor(Color.WHITE);
            }
        }
        g2d.setStroke(new BasicStroke(1.5f));
        g2d.draw(shape);
    }

    @Override
    protected boolean showHollowArrow(ResourceGraph.Edge e) {
        DrbdVolumeInfo dvi = this.edgeToDrbdVolumeMap.get(e);
        if (dvi == null) {
            return false;
        }
        return !dvi.isConnected(this.isTestOnly());
    }

    @Override
    protected void multiSelection() {
        ArrayList<Info> selectedInfos = new ArrayList<Info>();
        PickedState ps = this.getVisualizationViewer().getRenderContext().getPickedVertexState();
        for (ResourceGraph.Vertex v : ps.getPicked()) {
            selectedInfos.add(this.getInfo(v));
        }
        this.multiSelectionInfo = new DrbdMultiSelectionInfo(selectedInfos, (Browser)this.getClusterBrowser());
        this.getClusterBrowser().setRightComponentInView(this.multiSelectionInfo);
    }

    public Map<DrbdVolumeInfo, ResourceGraph.Edge> getDrbdVolumeToEdgeMap() {
        return this.drbdVolumeToEdgeMap;
    }
}

