/*
 * Decompiled with CFR 0.152.
 */
package lcmc.data;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lcmc.data.Host;
import lcmc.utilities.Tools;
import org.apache.commons.collections15.map.MultiKeyMap;

public final class DRBDtestData {
    private static final long serialVersionUID = 1L;
    private final String toolTip;
    private static final Pattern DRBD_D_PATTERN = Pattern.compile(".*drbdsetup\\s+(\\S+)\\s+(\\S+).*");
    private final MultiKeyMap<String, Integer> connectedHash = new MultiKeyMap();
    private final MultiKeyMap<String, Integer> disconnectedHash = new MultiKeyMap();
    private final MultiKeyMap<String, Integer> attachedHash = new MultiKeyMap();
    private final MultiKeyMap<String, Integer> disklessHash = new MultiKeyMap();

    public DRBDtestData(Map<Host, String> testOutput) {
        if (testOutput == null) {
            this.toolTip = null;
            return;
        }
        StringBuilder sb = new StringBuilder(300);
        sb.append("<html><b>");
        sb.append(Tools.getString("DRBDtestData.ToolTip"));
        sb.append("</b><br>");
        boolean isToolTip = false;
        for (Host host : testOutput.keySet()) {
            sb.append("<b>");
            sb.append(host.getName());
            sb.append("</b><br>");
            String raw = testOutput.get(host);
            if (raw == null) continue;
            for (String line : raw.split("\\r?\\n")) {
                int index;
                Matcher m = DRBD_D_PATTERN.matcher(line);
                if (m.matches()) {
                    String resOrVol = m.group(1);
                    String action = m.group(2);
                    if ("disconnect".equals(action)) {
                        this.disconnectedHash.put(host.getName(), resOrVol, 1);
                    } else if ("net".equals(action)) {
                        this.connectedHash.put(host.getName(), "/dev/drbd" + resOrVol, 1);
                    } else if ("detach".equals(action)) {
                        this.disklessHash.put(host.getName(), "/dev/drbd" + resOrVol, 1);
                    } else if ("disk".equals(action)) {
                        this.attachedHash.put(host.getName(), "/dev/drbd" + resOrVol, 1);
                    }
                }
                if ((index = line.indexOf("--set-defaults")) >= 0) {
                    sb.append(line.substring(0, index));
                } else {
                    sb.append(line);
                }
                sb.append("<br>");
                isToolTip = true;
            }
        }
        if (!isToolTip) {
            sb.append(Tools.getString("DRBDtestData.NoToolTip"));
        }
        sb.append("</html>");
        this.toolTip = sb.toString();
    }

    public String getToolTip() {
        return this.toolTip;
    }

    public boolean isDisconnected(Host host, String resource) {
        return this.disconnectedHash.get((K[])new String[]{host.getName(), resource}) != null;
    }

    public boolean isConnected(Host host, String resource) {
        return this.connectedHash.get((K[])new String[]{host.getName(), resource}) != null;
    }

    public boolean isDiskless(Host host, String dev) {
        return this.disklessHash.get((K[])new String[]{host.getName(), dev}) != null;
    }

    public boolean isAttached(Host host, String dev) {
        return this.attachedHash.get((K[])new String[]{host.getName(), dev}) != null;
    }
}

