/*
 * Decompiled with CFR 0.152.
 */
package lcmc;

import java.awt.Container;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import lcmc.configs.AppDefaults;
import lcmc.data.ConfigData;
import lcmc.data.HostOptions;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.MainMenu;
import lcmc.gui.MainPanel;
import lcmc.gui.ProgressIndicatorPanel;
import lcmc.utilities.RoboTest;
import lcmc.utilities.Tools;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class LCMC
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int TOOLTIP_INITIAL_DELAY = 200;
    private static final int TOOLTIP_DISMISS_DELAY = 100000;
    private static final String HELP_OP = "help";
    private static final String VERSION_OP = "version";
    private static final String NOLRM_OP = "nolrm";
    private static final String AUTO_OP = "auto";
    private static final String RO_OP = "ro";
    private static final String OP_OP = "op";
    private static final String ADMIN_OP = "admin";
    private static final String OP_MODE_OP = "op-mode";
    private static final String NO_UPGRADE_CHECK_OP = "no-upgrade-check";
    private static final String NO_PLUGIN_CHECK_OP = "no-plugin-check";
    private static final String TIGHTVNC_OP = "tightvnc";
    private static final String ULTRAVNC_OP = "ultravnc";
    private static final String REALVNC_OP = "realvnc";
    private static final String BIGDRBDCONF_OP = "big-drbd-conf";
    private static final String STAGING_DRBD_OP = "staging-drbd";
    private static final String STAGING_PACEMAKER_OP = "staging-pacemaker";
    private static final String VNC_PORT_OFFSET_OP = "vnc-port-offset";
    private static final String SLOW_OP = "slow";
    private static final String RESTORE_MOUSE_OP = "restore-mouse";
    private static final String KEEP_HELPER_OP = "keep-helper";
    private static final String SCALE_OP = "scale";
    private static final String ID_DSA_OP = "id-dsa";
    private static final String ID_RSA_OP = "id-rsa";
    private static final String KNOWN_HOSTS_OP = "known-hosts";
    private static final String OUT_OP = "out";
    private static final String DEBUG_OP = "debug";
    private static final String CLUSTER_OP = "cluster";
    private static final String HOST_OP = "host";
    private static final String USER_OP = "user";
    private static final String SUDO_OP = "sudo";
    private static final String PORT_OP = "port";
    private static final String ADVANCED_OP = "advanced";
    private static final String ONE_HOST_CLUSTER_OP = "one-host-cluster";
    private static final String NO_PASSPHRASE = "no-passphrase";

    private LCMC() {
    }

    protected static void createAndShowGUI(Container mainFrame) {
        List<Object> buttonGradient = Arrays.asList(new Float(0.5f), new Float(1.0f), new ColorUIResource(0xFFFFFF), new ColorUIResource(ClusterBrowser.PANEL_BACKGROUND), new ColorUIResource(ClusterBrowser.BUTTON_PANEL_BACKGROUND));
        List<Object> checkboxGradient = Arrays.asList(new Float(0.3f), new Float(0.0f), new ColorUIResource(ClusterBrowser.PANEL_BACKGROUND), new ColorUIResource(ClusterBrowser.PANEL_BACKGROUND), new ColorUIResource(0xFFFFFF));
        ToolTipManager.sharedInstance().setInitialDelay(200);
        ToolTipManager.sharedInstance().setDismissDelay(100000);
        UIManager.put("TableHeader.background", Tools.getDefaultColor("DrbdMC.TableHeader"));
        UIManager.put("TableHeader.font", UIManager.getFont("Label.font"));
        UIManager.put("Button.gradient", buttonGradient);
        UIManager.put("Button.select", ClusterBrowser.PANEL_BACKGROUND);
        UIManager.put("CheckBox.gradient", checkboxGradient);
        UIManager.put("CheckBoxMenuItem.gradient", checkboxGradient);
        UIManager.put("RadioButton.gradient", checkboxGradient);
        UIManager.put("RadioButton.rollover", Boolean.TRUE);
        UIManager.put("RadioButtonMenuItem.gradient", checkboxGradient);
        UIManager.put("ScrollBar.gradient", buttonGradient);
        UIManager.put("ToggleButton.gradient", buttonGradient);
        UIManager.put("Menu.selectionBackground", ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        UIManager.put("MenuItem.selectionBackground", ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        UIManager.put("List.selectionBackground", ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        UIManager.put("ComboBox.selectionBackground", ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        UIManager.put("OptionPane.background", ClusterBrowser.BUTTON_PANEL_BACKGROUND);
        UIManager.put("Panel.background", ClusterBrowser.PANEL_BACKGROUND);
        Tools.getGUIData().setMainFrame(mainFrame);
        mainFrame.setSize(Tools.getDefaultInt("DrbdMC.width"), Tools.getDefaultInt("DrbdMC.height"));
        mainFrame.setVisible(true);
    }

    protected static JPanel getMainPanel() {
        MainPanel mainPanel = new MainPanel();
        Tools.getGUIData().setMainPanel(mainPanel);
        mainPanel.setOpaque(true);
        return mainPanel;
    }

    protected static JMenuBar getMenuBar() {
        MainMenu menu = new MainMenu();
        Tools.getGUIData().setMainMenu(menu);
        return menu.getMenuBar();
    }

    protected static ProgressIndicatorPanel getMainGlassPane() {
        ProgressIndicatorPanel mainGlassPane = new ProgressIndicatorPanel();
        Tools.getGUIData().setMainGlassPane(mainGlassPane);
        return mainGlassPane;
    }

    public static void cleanupBeforeClosing() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("saving...");
                for (int i = 0; i < 10; ++i) {
                    System.out.println(".");
                    System.out.flush();
                    Tools.sleep(2000);
                }
                System.out.println();
                System.out.println("force exit.");
                System.exit(5);
            }
        });
        t.start();
        Tools.getGUIData().getMainFrame().setVisible(false);
        String saveFile = Tools.getConfigData().getSaveFile();
        Tools.save(saveFile, false);
        Tools.getConfigData().disconnectAllHosts();
    }

    protected static String initApp(String[] args) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            MetalLookAndFeel.setCurrentTheme(new OceanTheme(){

                @Override
                protected ColorUIResource getPrimary1() {
                    return new ColorUIResource(ClusterBrowser.STATUS_BACKGROUND);
                }

                @Override
                protected ColorUIResource getPrimary2() {
                    return new ColorUIResource(ClusterBrowser.PANEL_BACKGROUND);
                }

                @Override
                protected ColorUIResource getPrimary3() {
                    return new ColorUIResource(ClusterBrowser.PANEL_BACKGROUND);
                }

                @Override
                protected ColorUIResource getSecondary1() {
                    return new ColorUIResource(AppDefaults.BACKGROUND_DARK);
                }

                @Override
                protected ColorUIResource getSecondary2() {
                    return new ColorUIResource(ClusterBrowser.PANEL_BACKGROUND);
                }

                @Override
                protected ColorUIResource getSecondary3() {
                    return new ColorUIResource(ClusterBrowser.PANEL_BACKGROUND);
                }
            });
        }
        catch (Exception e) {
            // empty catch block
        }
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable ex) {
                Tools.setMaxAccessType(ConfigData.AccessType.RO);
                Tools.appError("Application Error: Switching to read-only mode\nCTRL-A, CTRL-C, CTRL-V to: lcmcgui@gmail.com\nplease...\n", ex.toString(), (Exception)ex);
            }
        });
        float fps = 20.0f;
        Options options = new Options();
        options.addOption("h", HELP_OP, false, "print this help");
        options.addOption(null, KEEP_HELPER_OP, false, "do not overwrite the lcmc-gui-helper program");
        options.addOption(null, RO_OP, false, "read only mode");
        options.addOption(null, OP_OP, false, "operator mode");
        options.addOption(null, ADMIN_OP, false, "administrator mode");
        options.addOption(null, OP_MODE_OP, true, "operating mode. <arg> can be:\nro - read only\nop - operator\nadmin - administrator");
        options.addOption(null, NOLRM_OP, false, "do not show removed resources from LRM.");
        options.addOption(null, AUTO_OP, true, "for testing");
        options.addOption("v", VERSION_OP, false, "print version");
        options.addOption(null, AUTO_OP, true, "for testing");
        options.addOption(null, NO_UPGRADE_CHECK_OP, false, "disable upgrade check");
        options.addOption(null, NO_PLUGIN_CHECK_OP, false, "disable plugin check, DEPRECATED: there are no plugins");
        options.addOption(null, TIGHTVNC_OP, false, "enable tight vnc viewer");
        options.addOption(null, ULTRAVNC_OP, false, "enable ultra vnc viewer");
        options.addOption(null, REALVNC_OP, false, "enable real vnc viewer");
        options.addOption(null, BIGDRBDCONF_OP, false, "create one big drbd.conf, instead of many files in drbd.d/ directory");
        options.addOption(null, STAGING_DRBD_OP, false, "enable more DRBD installation options");
        options.addOption(null, STAGING_PACEMAKER_OP, false, "enable more Pacemaker installation options");
        options.addOption(null, VNC_PORT_OFFSET_OP, true, "offset for port forwarding");
        options.addOption(null, SLOW_OP, false, "specify this if you have slow computer");
        options.addOption(null, RESTORE_MOUSE_OP, false, "for testing");
        options.addOption(null, SCALE_OP, true, "scale fonts and sizes of elements in percent (100)");
        options.addOption(null, ID_DSA_OP, true, "location of id_dsa file ($HOME/.ssh/id_dsa)");
        options.addOption(null, ID_RSA_OP, true, "location of id_rsa file ($HOME/.ssh/id_rsa)");
        options.addOption(null, KNOWN_HOSTS_OP, true, "location of known_hosts file ($HOME/.ssh/known_hosts)");
        options.addOption(null, OUT_OP, true, "where to redirect the standard out");
        options.addOption(null, DEBUG_OP, true, "debug level, 0 - none, 3 - all");
        options.addOption("c", CLUSTER_OP, true, "define a cluster");
        Option hostOp = new Option("h", HOST_OP, true, "define a cluster, used with --cluster option");
        hostOp.setArgs(10000);
        options.addOption(hostOp);
        options.addOption(null, SUDO_OP, false, "whether to use sudo, used with --cluster option");
        options.addOption(null, USER_OP, true, "user to use with sudo, used with --cluster option");
        options.addOption(null, PORT_OP, true, "ssh port, used with --cluster option");
        options.addOption(null, ADVANCED_OP, false, "start in an advanced mode");
        options.addOption(null, ONE_HOST_CLUSTER_OP, false, "allow one host cluster");
        options.addOption(null, NO_PASSPHRASE, false, "try no passphrase first");
        PosixParser parser2 = new PosixParser();
        String autoArgs = null;
        try {
            String vncPortOffsetString;
            String out;
            CommandLine cmd = parser2.parse(options, args);
            if (cmd.hasOption(OUT_OP) && (out = cmd.getOptionValue(OUT_OP)) != null) {
                try {
                    System.setOut(new PrintStream(new FileOutputStream(out)));
                }
                catch (FileNotFoundException e) {
                    System.exit(2);
                }
            }
            if (cmd.hasOption(DEBUG_OP)) {
                String level = cmd.getOptionValue(DEBUG_OP);
                if (level != null && Tools.isNumber(level)) {
                    Tools.setDebugLevel(Integer.parseInt(level));
                } else {
                    throw new ParseException("cannot parse debug level: " + level);
                }
            }
            boolean tightvnc = cmd.hasOption(TIGHTVNC_OP);
            boolean ultravnc = cmd.hasOption(ULTRAVNC_OP);
            boolean realvnc = cmd.hasOption(REALVNC_OP);
            if (!(tightvnc || ultravnc || realvnc)) {
                if (Tools.isLinux()) {
                    tightvnc = true;
                } else {
                    tightvnc = true;
                    ultravnc = true;
                }
            }
            boolean advanced = cmd.hasOption(ADVANCED_OP);
            Tools.getConfigData().setAdvancedMode(advanced);
            Tools.getConfigData().setTightvnc(tightvnc);
            Tools.getConfigData().setUltravnc(ultravnc);
            Tools.getConfigData().setRealvnc(realvnc);
            Tools.getConfigData().setUpgradeCheckEnabled(!cmd.hasOption(NO_UPGRADE_CHECK_OP));
            Tools.getConfigData().setBigDRBDConf(cmd.hasOption(BIGDRBDCONF_OP));
            Tools.getConfigData().setStagingDrbd(cmd.hasOption(STAGING_DRBD_OP));
            Tools.getConfigData().setStagingPacemaker(cmd.hasOption(STAGING_PACEMAKER_OP));
            Tools.getConfigData().setNoLRM(cmd.hasOption(NOLRM_OP));
            Tools.getConfigData().setKeepHelper(cmd.hasOption(KEEP_HELPER_OP));
            Tools.getConfigData().setOneHostCluster(cmd.hasOption(ONE_HOST_CLUSTER_OP));
            Tools.getConfigData().setNoPassphrase(cmd.hasOption(NO_PASSPHRASE));
            String pwd = System.getProperty("user.home");
            String scaleOp = cmd.getOptionValue(SCALE_OP, "100");
            try {
                int scale = Integer.parseInt(scaleOp);
                Tools.getConfigData().setScale(scale);
                Tools.resizeFonts(scale);
            }
            catch (NumberFormatException e) {
                Tools.appWarning("cannot parse scale: " + scaleOp);
            }
            String idDsaPath = cmd.getOptionValue(ID_DSA_OP, pwd + "/.ssh/id_dsa");
            String idRsaPath = cmd.getOptionValue(ID_RSA_OP, pwd + "/.ssh/id_rsa");
            String knownHostsPath = cmd.getOptionValue(KNOWN_HOSTS_OP, pwd + "/.ssh/known_hosts");
            Tools.getConfigData().setIdDSAPath(idDsaPath);
            Tools.getConfigData().setIdRSAPath(idRsaPath);
            Tools.getConfigData().setKnownHostPath(knownHostsPath);
            String opMode = cmd.getOptionValue(OP_MODE_OP);
            autoArgs = cmd.getOptionValue(AUTO_OP);
            if (cmd.hasOption(HELP_OP)) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("java -jar LCMC.jar [OPTIONS]", options);
                System.exit(0);
            }
            if (cmd.hasOption(VERSION_OP)) {
                System.out.println("LINUX CLUSTER MANAGEMENT CONSOLE " + Tools.getRelease() + " by Rasto Levrinc");
                System.exit(0);
            }
            if (cmd.hasOption(RO_OP) || RO_OP.equals(opMode)) {
                Tools.getConfigData().setAccessType(ConfigData.AccessType.RO);
                Tools.getConfigData().setMaxAccessType(ConfigData.AccessType.RO);
            } else if (cmd.hasOption(OP_OP) || OP_OP.equals(opMode)) {
                Tools.getConfigData().setAccessType(ConfigData.AccessType.OP);
                Tools.getConfigData().setMaxAccessType(ConfigData.AccessType.OP);
            } else if (cmd.hasOption(ADMIN_OP) || ADMIN_OP.equals(opMode)) {
                Tools.getConfigData().setAccessType(ConfigData.AccessType.ADMIN);
                Tools.getConfigData().setMaxAccessType(ConfigData.AccessType.ADMIN);
            } else if (opMode != null) {
                Tools.appWarning("unknown operating mode: " + opMode);
            }
            if (cmd.hasOption(SLOW_OP)) {
                fps /= 2.0f;
            }
            if (cmd.hasOption(RESTORE_MOUSE_OP)) {
                RoboTest.restoreMouse();
            }
            if ((vncPortOffsetString = cmd.getOptionValue(VNC_PORT_OFFSET_OP)) != null && Tools.isNumber(vncPortOffsetString)) {
                Tools.getConfigData().setVncPortOffset(Integer.parseInt(vncPortOffsetString));
            }
            Tools.getConfigData().setAnimFPS(fps);
            if (cmd.hasOption(CLUSTER_OP) || cmd.hasOption(HOST_OP)) {
                LCMC.parseClusterOptions(cmd);
            }
        }
        catch (ParseException exp) {
            System.out.println("ERROR: " + exp.getMessage());
            System.exit(1);
        }
        Tools.debug(null, "max mem: " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "m", 1);
        return autoArgs;
    }

    private static void parseClusterOptions(CommandLine cmd) throws ParseException {
        String clusterName = null;
        ArrayList<HostOptions> hostsOptions = null;
        LinkedHashMap<String, List<HostOptions>> clusters = new LinkedHashMap<String, List<HostOptions>>();
        for (Option option : cmd.getOptions()) {
            String op = option.getLongOpt();
            if (CLUSTER_OP.equals(op)) {
                clusterName = option.getValue();
                if (clusterName == null) {
                    throw new ParseException("could not parse cluster option");
                }
                clusters.put(clusterName, new ArrayList());
                continue;
            }
            if (HOST_OP.equals(op)) {
                String[] hostNames = option.getValues();
                if (clusterName == null) {
                    clusterName = "default";
                    clusters.put(clusterName, new ArrayList());
                }
                if (hostNames == null) {
                    throw new ParseException("could not parse host option");
                }
                hostsOptions = new ArrayList<HostOptions>();
                for (String hostNameEntered : hostNames) {
                    String hostName;
                    String port = null;
                    if (hostNameEntered.indexOf(58) > 0) {
                        String[] he = hostNameEntered.split(":");
                        hostName = he[0];
                        port = he[1];
                        if ("".equals(port) || !Tools.isNumber(port)) {
                            throw new ParseException("could not parse host option");
                        }
                    } else {
                        hostName = hostNameEntered;
                    }
                    HostOptions ho = new HostOptions(hostName);
                    if (port != null) {
                        ho.setPort(port);
                    }
                    hostsOptions.add(ho);
                    ((List)clusters.get(clusterName)).add(ho);
                }
                continue;
            }
            if (SUDO_OP.equals(op)) {
                if (hostsOptions == null) {
                    throw new ParseException("sudo must be defined after host");
                }
                for (HostOptions ho : hostsOptions) {
                    ho.setSudo(true);
                }
                continue;
            }
            if (USER_OP.equals(op)) {
                if (hostsOptions == null) {
                    throw new ParseException("user must be defined after host");
                }
                String userName = option.getValue();
                if (userName == null) {
                    throw new ParseException("could not parse user option");
                }
                for (HostOptions ho : hostsOptions) {
                    ho.setUser(userName);
                }
                continue;
            }
            if (!PORT_OP.equals(op)) continue;
            if (hostsOptions == null) {
                throw new ParseException("port must be defined after host");
            }
            String port = option.getValue();
            if (port == null) {
                throw new ParseException("could not parse port option");
            }
            for (HostOptions ho : hostsOptions) {
                ho.setPort(port);
            }
        }
        for (String cn : clusters.keySet()) {
            for (HostOptions hostOptions : (List)clusters.get(cn)) {
                if (hostsOptions.size() >= 1 && (hostsOptions.size() != 1 || Tools.getConfigData().isOneHostCluster())) continue;
                throw new ParseException("not enough hosts for cluster: " + cn);
            }
        }
        String failedHost = Tools.setUserConfigFromOptions(clusters);
        if (failedHost != null) {
            Tools.appWarning("could not resolve host \"" + failedHost + "\" skipping");
        }
    }

    public static void main(String[] args) {
        Tools.init();
        final JFrame mainFrame = new JFrame(Tools.getString("DrbdMC.Title") + " " + Tools.getRelease());
        ArrayList<Image> il = new ArrayList<Image>();
        for (String iconS : new String[]{"LCMC.AppIcon32", "LCMC.AppIcon48", "LCMC.AppIcon64", "LCMC.AppIcon128", "LCMC.AppIcon256"}) {
            il.add(Tools.createImageIcon(Tools.getDefault(iconS)).getImage());
        }
        mainFrame.setIconImages(il);
        String autoArgs = LCMC.initApp(args);
        mainFrame.setGlassPane(LCMC.getMainGlassPane());
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.addWindowListener(new ExitListener());
        mainFrame.setJMenuBar(LCMC.getMenuBar());
        mainFrame.setContentPane(LCMC.getMainPanel());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LCMC.createAndShowGUI(mainFrame);
            }
        });
        if (autoArgs != null) {
            Tools.parseAutoArgs(autoArgs);
        }
    }

    public static class ExitListener
    extends WindowAdapter {
        @Override
        public final void windowClosing(WindowEvent event) {
            LCMC.cleanupBeforeClosing();
            System.exit(0);
        }
    }
}

