/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization3d;

import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class EdgeGroup<E>
extends TransformGroup {
    E edge;
    Node shape;

    public EdgeGroup(E edge, Node shape) {
        this.edge = edge;
        this.shape = shape;
        this.setCapability(1);
        Transform3D t = new Transform3D();
        t.setTranslation(new Vector3f(0.0f, 0.5f, 0.0f));
        TransformGroup group = new TransformGroup(t);
        group.addChild(shape);
        this.addChild((Node)group);
    }

    public String toString() {
        return this.edge.toString();
    }

    public void setEndpoints(Point3f p0, Point3f p1) {
        float length = p0.distance(p1);
        Transform3D tx = new Transform3D();
        Transform3D p0tx = new Transform3D();
        p0tx.setTranslation(new Vector3f(p0.getX(), p0.getY(), p0.getZ()));
        Transform3D scaletx = new Transform3D();
        scaletx.setScale(new Vector3d(1.0, (double)length, 1.0));
        Vector3f yunit = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f v = new Vector3f(p1.getX() - p0.getX(), p1.getY() - p0.getY(), p1.getZ() - p0.getZ());
        Vector3f cross = new Vector3f();
        cross.cross(yunit, v);
        float angle = yunit.angle(v);
        Transform3D rot = new Transform3D();
        rot.setRotation(new AxisAngle4f(cross.getX(), cross.getY(), cross.getZ(), angle));
        tx.mul(rot);
        tx.mul(scaletx);
        tx.setTranslation(new Vector3f(p0.getX(), p0.getY(), p0.getZ()));
        try {
            this.setTransform(tx);
        }
        catch (Exception ex) {
            System.err.println("tx = \n" + tx);
        }
    }
}

