/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.PluggableGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicIconFactory;

public abstract class AbstractModalGraphMouse
extends PluggableGraphMouse
implements ModalGraphMouse,
ItemSelectable {
    protected float in;
    protected float out;
    protected ItemListener modeListener;
    protected JComboBox modeBox;
    protected JMenu modeMenu;
    protected ModalGraphMouse.Mode mode;
    protected EventListenerList listenerList = new EventListenerList();
    protected GraphMousePlugin pickingPlugin;
    protected GraphMousePlugin translatingPlugin;
    protected GraphMousePlugin animatedPickingPlugin;
    protected GraphMousePlugin scalingPlugin;
    protected GraphMousePlugin rotatingPlugin;
    protected GraphMousePlugin shearingPlugin;
    protected KeyListener modeKeyListener;

    protected AbstractModalGraphMouse(float in, float out) {
        this.in = in;
        this.out = out;
    }

    protected abstract void loadPlugins();

    @Override
    public void setMode(ModalGraphMouse.Mode mode) {
        if (this.mode != mode) {
            this.fireItemStateChanged(new ItemEvent(this, 701, (Object)this.mode, 2));
            this.mode = mode;
            if (mode == ModalGraphMouse.Mode.TRANSFORMING) {
                this.setTransformingMode();
            } else if (mode == ModalGraphMouse.Mode.PICKING) {
                this.setPickingMode();
            }
            if (this.modeBox != null) {
                this.modeBox.setSelectedItem((Object)mode);
            }
            this.fireItemStateChanged(new ItemEvent(this, 701, (Object)mode, 1));
        }
    }

    protected void setPickingMode() {
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.add(this.pickingPlugin);
        this.add(this.animatedPickingPlugin);
    }

    protected void setTransformingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.add(this.translatingPlugin);
        this.add(this.rotatingPlugin);
        this.add(this.shearingPlugin);
    }

    public void setZoomAtMouse(boolean zoomAtMouse) {
        ((ScalingGraphMousePlugin)this.scalingPlugin).setZoomAtMouse(zoomAtMouse);
    }

    @Override
    public ItemListener getModeListener() {
        if (this.modeListener == null) {
            this.modeListener = new ModeListener();
        }
        return this.modeListener;
    }

    public KeyListener getModeKeyListener() {
        return this.modeKeyListener;
    }

    public void setModeKeyListener(KeyListener modeKeyListener) {
        this.modeKeyListener = modeKeyListener;
    }

    public JComboBox getModeComboBox() {
        if (this.modeBox == null) {
            this.modeBox = new JComboBox<ModalGraphMouse.Mode>(new ModalGraphMouse.Mode[]{ModalGraphMouse.Mode.TRANSFORMING, ModalGraphMouse.Mode.PICKING});
            this.modeBox.addItemListener(this.getModeListener());
        }
        this.modeBox.setSelectedItem((Object)this.mode);
        return this.modeBox;
    }

    public JMenu getModeMenu() {
        if (this.modeMenu == null) {
            this.modeMenu = new JMenu();
            Icon icon = BasicIconFactory.getMenuArrowIcon();
            this.modeMenu.setIcon(BasicIconFactory.getMenuArrowIcon());
            this.modeMenu.setPreferredSize(new Dimension(icon.getIconWidth() + 10, icon.getIconHeight() + 10));
            final JRadioButtonMenuItem transformingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.TRANSFORMING.toString());
            transformingButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        AbstractModalGraphMouse.this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
                    }
                }
            });
            final JRadioButtonMenuItem pickingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.PICKING.toString());
            pickingButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        AbstractModalGraphMouse.this.setMode(ModalGraphMouse.Mode.PICKING);
                    }
                }
            });
            ButtonGroup radio = new ButtonGroup();
            radio.add(transformingButton);
            radio.add(pickingButton);
            transformingButton.setSelected(true);
            this.modeMenu.add(transformingButton);
            this.modeMenu.add(pickingButton);
            this.modeMenu.setToolTipText("Menu for setting Mouse Mode");
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        if (e.getItem() == ModalGraphMouse.Mode.TRANSFORMING) {
                            transformingButton.setSelected(true);
                        } else if (e.getItem() == ModalGraphMouse.Mode.PICKING) {
                            pickingButton.setSelected(true);
                        }
                    }
                }
            });
        }
        return this.modeMenu;
    }

    @Override
    public void addItemListener(ItemListener aListener) {
        this.listenerList.add(ItemListener.class, aListener);
    }

    @Override
    public void removeItemListener(ItemListener aListener) {
        this.listenerList.remove(ItemListener.class, aListener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(ItemListener.class);
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.mode == null) {
            return new Object[0];
        }
        Object[] result = new Object[]{this.mode};
        return result;
    }

    protected void fireItemStateChanged(ItemEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ItemListener.class) continue;
            ((ItemListener)listeners[i + 1]).itemStateChanged(e);
        }
    }

    class ModeListener
    implements ItemListener {
        ModeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            AbstractModalGraphMouse.this.setMode((ModalGraphMouse.Mode)((Object)e.getItem()));
        }
    }
}

