/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.impl;

import cern.colt.matrix.ObjectMatrix1D;
import cern.colt.matrix.ObjectMatrix2D;
import cern.colt.matrix.impl.DenseObjectMatrix1D;
import cern.colt.matrix.impl.DenseObjectMatrix2D;

class SelectedDenseObjectMatrix1D
extends ObjectMatrix1D {
    protected Object[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseObjectMatrix1D(Object[] elements, int[] offsets) {
        this(offsets.length, elements, 0, 1, offsets, 0);
    }

    protected SelectedDenseObjectMatrix1D(int size, Object[] elements, int zero, int stride, int[] offsets, int offset) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.offsets = offsets;
        this.offset = offset;
        this.isNoView = false;
    }

    @Override
    protected int _offset(int absRank) {
        return this.offsets[absRank];
    }

    @Override
    public Object getQuick(int index) {
        return this.elements[this.offset + this.offsets[this.zero + index * this.stride]];
    }

    @Override
    protected boolean haveSharedCellsRaw(ObjectMatrix1D other) {
        if (other instanceof SelectedDenseObjectMatrix1D) {
            SelectedDenseObjectMatrix1D otherMatrix = (SelectedDenseObjectMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseObjectMatrix1D) {
            DenseObjectMatrix1D otherMatrix = (DenseObjectMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    protected int index(int rank) {
        return this.offset + this.offsets[this.zero + rank * this.stride];
    }

    @Override
    public ObjectMatrix1D like(int size) {
        return new DenseObjectMatrix1D(size);
    }

    @Override
    public ObjectMatrix2D like2D(int rows, int columns) {
        return new DenseObjectMatrix2D(rows, columns);
    }

    @Override
    public void setQuick(int index, Object value) {
        this.elements[this.offset + this.offsets[this.zero + index * this.stride]] = value;
    }

    @Override
    protected void setUp(int size) {
        super.setUp(size);
        this.stride = 1;
        this.offset = 0;
    }

    @Override
    protected ObjectMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseObjectMatrix1D(this.elements, offsets);
    }
}

