/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;

public abstract class DNSMessage {
    public static final boolean MULTICAST = true;
    public static final boolean UNICAST = false;
    private int _id;
    boolean _multicast;
    private int _flags;
    protected final List<DNSQuestion> _questions;
    protected final List<DNSRecord> _answers;
    protected final List<DNSRecord> _authoritativeAnswers;
    protected final List<DNSRecord> _additionals;

    protected DNSMessage(int n, int n2, boolean bl) {
        this._flags = n;
        this._id = n2;
        this._multicast = bl;
        this._questions = Collections.synchronizedList(new LinkedList());
        this._answers = Collections.synchronizedList(new LinkedList());
        this._authoritativeAnswers = Collections.synchronizedList(new LinkedList());
        this._additionals = Collections.synchronizedList(new LinkedList());
    }

    public int getId() {
        return this._multicast ? 0 : this._id;
    }

    public void setId(int n) {
        this._id = n;
    }

    public int getFlags() {
        return this._flags;
    }

    public void setFlags(int n) {
        this._flags = n;
    }

    public boolean isMulticast() {
        return this._multicast;
    }

    public Collection<? extends DNSQuestion> getQuestions() {
        return this._questions;
    }

    public int getNumberOfQuestions() {
        return this.getQuestions().size();
    }

    public Collection<? extends DNSRecord> getAllAnswers() {
        ArrayList<DNSRecord> arrayList = new ArrayList<DNSRecord>(this._answers.size() + this._authoritativeAnswers.size() + this._additionals.size());
        arrayList.addAll(this._answers);
        arrayList.addAll(this._authoritativeAnswers);
        arrayList.addAll(this._additionals);
        return arrayList;
    }

    public Collection<? extends DNSRecord> getAnswers() {
        return this._answers;
    }

    public int getNumberOfAnswers() {
        return this.getAnswers().size();
    }

    public Collection<? extends DNSRecord> getAuthorities() {
        return this._authoritativeAnswers;
    }

    public int getNumberOfAuthorities() {
        return this.getAuthorities().size();
    }

    public Collection<? extends DNSRecord> getAdditionals() {
        return this._additionals;
    }

    public int getNumberOfAdditionals() {
        return this.getAdditionals().size();
    }

    public boolean isTruncated() {
        return (this._flags & 0x200) != 0;
    }

    public boolean isQuery() {
        return (this._flags & 0x8000) == 0;
    }

    public boolean isResponse() {
        return (this._flags & 0x8000) == 32768;
    }

    public boolean isEmpty() {
        return this.getNumberOfQuestions() + this.getNumberOfAnswers() + this.getNumberOfAuthorities() + this.getNumberOfAdditionals() == 0;
    }

    String print() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.toString());
        stringBuffer.append("\n");
        for (DNSQuestion dNSEntry : this._questions) {
            stringBuffer.append("\tquestion:      ");
            stringBuffer.append(dNSEntry);
            stringBuffer.append("\n");
        }
        for (DNSRecord dNSRecord : this._answers) {
            stringBuffer.append("\tanswer:        ");
            stringBuffer.append(dNSRecord);
            stringBuffer.append("\n");
        }
        for (DNSRecord dNSRecord : this._authoritativeAnswers) {
            stringBuffer.append("\tauthoritative: ");
            stringBuffer.append(dNSRecord);
            stringBuffer.append("\n");
        }
        for (DNSRecord dNSRecord : this._additionals) {
            stringBuffer.append("\tadditional:    ");
            stringBuffer.append(dNSRecord);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    protected String print(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(4000);
        int n = byArray.length;
        for (int i = 0; i < n; i += 32) {
            int n2;
            int n3 = Math.min(32, n - i);
            if (i < 16) {
                stringBuilder.append(' ');
            }
            if (i < 256) {
                stringBuilder.append(' ');
            }
            if (i < 4096) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(Integer.toHexString(i));
            stringBuilder.append(':');
            int n4 = 0;
            for (n4 = 0; n4 < n3; ++n4) {
                if (n4 % 8 == 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(Integer.toHexString((byArray[i + n4] & 0xF0) >> 4));
                stringBuilder.append(Integer.toHexString((byArray[i + n4] & 0xF) >> 0));
            }
            if (n4 < 32) {
                for (n2 = n4; n2 < 32; ++n2) {
                    if (n2 % 8 == 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append("  ");
                }
            }
            stringBuilder.append("    ");
            for (n4 = 0; n4 < n3; ++n4) {
                if (n4 % 8 == 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append((n2 = byArray[i + n4] & 0xFF) > 32 && n2 < 127 ? (char)n2 : (char)'.');
            }
            stringBuilder.append("\n");
            if (i + 32 < 2048) continue;
            stringBuilder.append("....\n");
            break;
        }
        return stringBuilder.toString();
    }
}

