/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.securityconfig.masterpassword;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.securityconfig.SecurityConfigActivator;
import net.java.sip.communicator.plugin.securityconfig.masterpassword.MasterPasswordChangeDialog;
import net.java.sip.communicator.service.credentialsstorage.MasterPasswordInputService;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.resources.ResourceManagementService;

public class MasterPasswordPanel
extends TransparentPanel
implements ActionListener {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = Logger.getLogger(MasterPasswordPanel.class);
    private JCheckBox useMasterPasswordCheckBox;
    private JButton changeMasterPasswordButton;
    private final ResourceManagementService resources = SecurityConfigActivator.getResources();

    public MasterPasswordPanel() {
        this.setLayout(new BorderLayout(10, 10));
        this.setAlignmentX(0.0f);
        this.initComponents();
    }

    private void initComponents() {
        this.useMasterPasswordCheckBox = new SIPCommCheckBox(this.resources.getI18NString("plugin.securityconfig.masterpassword.USE_MASTER_PASSWORD"));
        this.useMasterPasswordCheckBox.addActionListener(this);
        this.useMasterPasswordCheckBox.setSelected(SecurityConfigActivator.getCredentialsStorageService().isUsingMasterPassword());
        this.add(this.useMasterPasswordCheckBox, "West");
        this.changeMasterPasswordButton = new JButton();
        this.changeMasterPasswordButton.setText(this.resources.getI18NString("plugin.securityconfig.masterpassword.CHANGE_MASTER_PASSWORD"));
        this.changeMasterPasswordButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MasterPasswordPanel.this.showMasterPasswordChangeDialog();
            }
        });
        this.changeMasterPasswordButton.setEnabled(this.useMasterPasswordCheckBox.isSelected());
        this.add(this.changeMasterPasswordButton, "East");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean isSelected = this.useMasterPasswordCheckBox.isSelected();
        this.useMasterPasswordCheckBox.setSelected(!isSelected);
        if (isSelected) {
            this.showMasterPasswordChangeDialog();
        } else {
            this.removeMasterPassword();
        }
    }

    private void showMasterPasswordChangeDialog() {
        MasterPasswordChangeDialog dialog = MasterPasswordChangeDialog.getInstance();
        dialog.setCallback(new ChangeMasterPasswordCallback());
        dialog.setVisible(true);
    }

    private void removeMasterPassword() {
        String master;
        boolean correct = true;
        MasterPasswordInputService masterPasswordInputService = SecurityConfigActivator.getMasterPasswordInputService();
        if (masterPasswordInputService == null) {
            logger.error((Object)"Missing MasterPasswordInputService to show input dialog");
            return;
        }
        do {
            if ((master = masterPasswordInputService.showInputDialog(correct)) != null) continue;
            return;
        } while (!(correct = master.length() != 0 && SecurityConfigActivator.getCredentialsStorageService().verifyMasterPassword(master)));
        new ChangeMasterPasswordCallback().execute(master, null);
    }

    class ChangeMasterPasswordCallback
    implements MasterPasswordChangeDialog.MasterPasswordExecutable {
        ChangeMasterPasswordCallback() {
        }

        @Override
        public boolean execute(String masterPassword, String newMasterPassword) {
            boolean remove = newMasterPassword == null;
            boolean changed = SecurityConfigActivator.getCredentialsStorageService().changeMasterPassword(masterPassword, newMasterPassword);
            if (!changed) {
                String titleKey = remove ? "plugin.securityconfig.masterpassword.MP_REMOVE_FAILURE" : "plugin.securityconfig.masterpassword.MP_CHANGE_FAILURE";
                SecurityConfigActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)MasterPasswordPanel.this.resources.getI18NString("plugin.securityconfig.masterpassword.MP_CHANGE_FAILURE_MSG"), MasterPasswordPanel.this.resources.getI18NString(titleKey), 0);
                return false;
            }
            String title = null;
            String msg = null;
            if (remove) {
                title = "plugin.securityconfig.masterpassword.MP_REMOVE_SUCCESS";
                msg = "plugin.securityconfig.masterpassword.MP_REMOVE_SUCCESS_MSG";
                MasterPasswordPanel.this.useMasterPasswordCheckBox.setSelected(false);
                MasterPasswordPanel.this.changeMasterPasswordButton.setEnabled(false);
            } else {
                title = "plugin.securityconfig.masterpassword.MP_CHANGE_SUCCESS";
                msg = "plugin.securityconfig.masterpassword.MP_CHANGE_SUCCESS_MSG";
                MasterPasswordPanel.this.useMasterPasswordCheckBox.setSelected(true);
                MasterPasswordPanel.this.changeMasterPasswordButton.setEnabled(true);
            }
            logger.debug((Object)"Master password successfully changed");
            SecurityConfigActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)MasterPasswordPanel.this.resources.getI18NString(msg), MasterPasswordPanel.this.resources.getI18NString(title), 1);
            return true;
        }
    }
}

