/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import java.net.InetSocketAddress;
import java.net.Proxy;
import net.java.sip.communicator.impl.protocol.irc.ClientConfigImpl;
import net.java.sip.communicator.impl.protocol.irc.IrcActivator;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.IrcStack;
import net.java.sip.communicator.impl.protocol.irc.OperationSetBasicInstantMessagingIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.OperationSetMultiUserChatIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.OperationSetPersistentPresenceIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.ProtocolIconIrcImpl;
import net.java.sip.communicator.service.protocol.AbstractProtocolProviderService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessagingTransport;
import net.java.sip.communicator.service.protocol.OperationSetInstantMessageTransform;
import net.java.sip.communicator.service.protocol.OperationSetInstantMessageTransformImpl;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.ProtocolIcon;
import net.java.sip.communicator.service.protocol.ProxyInfo;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.TransportProtocol;
import net.java.sip.communicator.service.protocol.UserCredentials;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;

public class ProtocolProviderServiceIrcImpl
extends AbstractProtocolProviderService {
    private static final int DEFAULT_SECURE_IRC_PORT = 6697;
    private static final Logger LOGGER = Logger.getLogger(ProtocolProviderServiceIrcImpl.class);
    private IrcStack ircstack = null;
    private AccountID accountID = null;
    private final Object initializationLock = new Object();
    private OperationSetMultiUserChatIrcImpl multiUserChat;
    private OperationSetBasicInstantMessagingIrcImpl instantMessaging;
    private OperationSetPersistentPresenceIrcImpl persistentPresence;
    private boolean isInitialized = false;
    private final ProtocolIconIrcImpl ircIcon = new ProtocolIconIrcImpl();
    private RegistrationState currentRegistrationState = RegistrationState.UNREGISTERED;

    public ProtocolProviderServiceIrcImpl() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"Creating a irc provider.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(String userID, AccountID accountID) {
        Object object = this.initializationLock;
        synchronized (object) {
            this.accountID = accountID;
            this.addSupportedOperationSet(OperationSetInstantMessageTransform.class, (OperationSet)new OperationSetInstantMessageTransformImpl());
            this.multiUserChat = new OperationSetMultiUserChatIrcImpl(this);
            this.addSupportedOperationSet(OperationSetMultiUserChat.class, (OperationSet)this.multiUserChat);
            this.instantMessaging = new OperationSetBasicInstantMessagingIrcImpl(this);
            this.addSupportedOperationSet(OperationSetBasicInstantMessaging.class, (OperationSet)this.instantMessaging);
            this.addSupportedOperationSet(OperationSetBasicInstantMessagingTransport.class, (OperationSet)this.instantMessaging);
            this.persistentPresence = new OperationSetPersistentPresenceIrcImpl(this);
            this.addSupportedOperationSet(OperationSetPersistentPresence.class, (OperationSet)this.persistentPresence);
            this.addSupportedOperationSet(OperationSetPresence.class, (OperationSet)this.persistentPresence);
            String user = this.getAccountID().getUserID();
            this.ircstack = new IrcStack(this, user, user, "Jitsi", user);
            this.isInitialized = true;
        }
    }

    public OperationSetMultiUserChatIrcImpl getMUC() {
        return this.multiUserChat;
    }

    public OperationSetBasicInstantMessagingIrcImpl getBasicInstantMessaging() {
        return this.instantMessaging;
    }

    public OperationSetPersistentPresenceIrcImpl getPersistentPresence() {
        return this.persistentPresence;
    }

    public AccountID getAccountID() {
        return this.accountID;
    }

    public String getProtocolName() {
        return "IRC";
    }

    public RegistrationState getRegistrationState() {
        return this.currentRegistrationState;
    }

    public void register(SecurityAuthority authority) throws OperationFailedException {
        AccountID accountID = this.getAccountID();
        String serverAddress = accountID.getAccountPropertyString((Object)"SERVER_ADDRESS");
        int serverPort = accountID.getAccountPropertyInt((Object)"SERVER_PORT", 6697);
        String serverPassword = IrcActivator.getProtocolProviderFactory().loadPassword(this.getAccountID());
        boolean autoNickChange = accountID.getAccountPropertyBoolean((Object)"AUTO_CHANGE_USER_NAME", true);
        boolean resolveDnsThroughProxy = accountID.getAccountPropertyBoolean((Object)"RESOLVE_DNS_THROUGH_PROXY", true);
        boolean passwordRequired = !accountID.getAccountPropertyBoolean((Object)"NO_PASSWORD_REQUIRED", true);
        boolean secureConnection = accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true);
        boolean channelPresenceTask = accountID.getAccountPropertyBoolean((Object)"CHAT_ROOM_PRESENCE_TASK", true);
        boolean contactPresenceTask = accountID.getAccountPropertyBoolean((Object)"CONTACT_PRESENCE_TASK", true);
        boolean saslEnabled = accountID.getAccountPropertyBoolean((Object)"SASL_ENABLED", false);
        String saslUser = accountID.getAccountPropertyString((Object)"SASL_USERNAME");
        String saslRole = accountID.getAccountPropertyString((Object)"SASL_ROLE");
        if (serverPassword == null && passwordRequired) {
            UserCredentials credentials = new UserCredentials();
            credentials.setUserName(this.getAccountID().getUserID());
            credentials = authority.obtainCredentials("IRC", credentials, 0);
            char[] pass = null;
            if (credentials != null) {
                pass = credentials.getPassword();
            }
            if (pass == null) {
                this.fireRegistrationStateChanged(this.getRegistrationState(), RegistrationState.UNREGISTERED, 0, "");
                return;
            }
            serverPassword = new String(pass);
            if (credentials.isPasswordPersistent()) {
                IrcActivator.getProtocolProviderFactory().storePassword(this.getAccountID(), serverPassword);
            }
        }
        ClientConfigImpl config = new ClientConfigImpl();
        config.setVersion3Allowed(true);
        config.setContactPresenceTaskEnabled(contactPresenceTask);
        config.setChannelPresenceTaskEnabled(channelPresenceTask);
        Proxy proxy = this.loadProxy();
        config.setProxy(proxy);
        config.setResolveByProxy(resolveDnsThroughProxy);
        if (saslEnabled) {
            ClientConfigImpl.SASLImpl sasl = new ClientConfigImpl.SASLImpl(saslUser, serverPassword, saslRole);
            config.setSASL(sasl);
        }
        try {
            this.ircstack.connect(serverAddress, serverPort, serverPassword, secureConnection, autoNickChange, config);
        }
        catch (OperationFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OperationFailedException(e.getMessage(), 1, (Throwable)e);
        }
    }

    private Proxy loadProxy() throws OperationFailedException {
        int globalProxyPort;
        ConfigurationService configSvc = IrcActivator.getConfigurationService();
        if (configSvc == null) {
            return null;
        }
        String globalProxyType = configSvc.getString("net.java.sip.communicator.service.connectionProxyType");
        if (globalProxyType == null || !globalProxyType.equals(ProxyInfo.ProxyType.SOCKS4.name()) && !globalProxyType.equals(ProxyInfo.ProxyType.SOCKS5.name())) {
            return null;
        }
        String globalProxyAddress = configSvc.getString("net.java.sip.communicator.service.connectionProxyAddress");
        String globalProxyPortStr = configSvc.getString("net.java.sip.communicator.service.connectionProxyPort");
        try {
            globalProxyPort = Integer.parseInt(globalProxyPortStr);
        }
        catch (NumberFormatException e) {
            throw new OperationFailedException("invalid proxy port", 7, (Throwable)e);
        }
        return new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(globalProxyAddress, globalProxyPort));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.isInitialized) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)"Killing the Irc Protocol Provider.");
        }
        try {
            Object object = this.initializationLock;
            synchronized (object) {
                this.unregister();
                this.ircstack.dispose();
                this.ircstack = null;
            }
        }
        catch (OperationFailedException ex) {
            LOGGER.error((Object)("Failed to properly unregister before shutting down. " + this.getAccountID()), (Throwable)ex);
        }
    }

    public void unregister() throws OperationFailedException {
        if (this.ircstack == null) {
            return;
        }
        this.ircstack.disconnect();
    }

    public boolean isSignalingTransportSecure() {
        IrcConnection connection = this.ircstack.getConnection();
        return connection != null && connection.isSecureConnection();
    }

    public TransportProtocol getTransportProtocol() {
        return TransportProtocol.TCP;
    }

    public ProtocolIcon getProtocolIcon() {
        return this.ircIcon;
    }

    public IrcStack getIrcStack() {
        return this.ircstack;
    }

    protected RegistrationState getCurrentRegistrationState() {
        return this.currentRegistrationState;
    }

    protected void setCurrentRegistrationState(RegistrationState regState, int reason) {
        RegistrationState oldState = this.currentRegistrationState;
        this.currentRegistrationState = regState;
        this.fireRegistrationStateChanged(oldState, this.currentRegistrationState, reason, null);
    }
}

