/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.domain.messages.ClientErrorMessage;
import com.ircclouds.irc.api.domain.messages.ErrorMessage;
import com.ircclouds.irc.api.domain.messages.QuitMessage;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import com.ircclouds.irc.api.listeners.IMessageListener;
import com.ircclouds.irc.api.state.IIRCState;
import java.io.IOException;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import net.java.sip.communicator.impl.protocol.irc.AbstractIrcMessageListener;
import net.java.sip.communicator.impl.protocol.irc.BasicPollerPresenceWatcher;
import net.java.sip.communicator.impl.protocol.irc.ClientConfig;
import net.java.sip.communicator.impl.protocol.irc.ISupport;
import net.java.sip.communicator.impl.protocol.irc.IdentityManager;
import net.java.sip.communicator.impl.protocol.irc.IrcStatusEnum;
import net.java.sip.communicator.impl.protocol.irc.MonitorPresenceWatcher;
import net.java.sip.communicator.impl.protocol.irc.OperationSetPersistentPresenceIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.PresenceWatcher;
import net.java.sip.communicator.impl.protocol.irc.Result;
import net.java.sip.communicator.impl.protocol.irc.WatchPresenceWatcher;
import net.java.sip.communicator.impl.protocol.irc.collection.DynamicDifferenceSet;
import net.java.sip.communicator.util.Logger;

public class PresenceManager {
    private static final Logger LOGGER = Logger.getLogger(PresenceManager.class);
    private final IRCApi irc;
    private final IIRCState connectionState;
    private final OperationSetPersistentPresenceIrcImpl operationSet;
    private final PresenceWatcher watcher;
    private final Integer isupportAwayLen;
    private final Integer isupportMonitor;
    private final Integer isupportWatch;
    private final AtomicReference<String> serverIdentity = new AtomicReference<Object>(null);
    private volatile boolean away = false;
    private volatile String currentMessage = "";
    private volatile String submittedMessage = "Away";

    public PresenceManager(IRCApi irc, IIRCState connectionState, OperationSetPersistentPresenceIrcImpl operationSet, ClientConfig config, SortedSet<String> persistentNickWatchList) {
        if (connectionState == null) {
            throw new IllegalArgumentException("connectionState cannot be null");
        }
        this.connectionState = connectionState;
        if (operationSet == null) {
            throw new IllegalArgumentException("operationSet cannot be null");
        }
        this.operationSet = operationSet;
        if (irc == null) {
            throw new IllegalArgumentException("irc cannot be null");
        }
        this.irc = irc;
        SortedSet<String> nickWatchList = persistentNickWatchList == null ? Collections.synchronizedSortedSet(new TreeSet()) : persistentNickWatchList;
        this.irc.addListener((IMessageListener)new LocalUserPresenceListener());
        this.isupportAwayLen = this.parseISupportAwayLen(this.connectionState);
        this.isupportMonitor = this.parseISupportMonitor(this.connectionState);
        this.isupportWatch = this.parseISupportWatch(this.connectionState);
        boolean enablePresencePolling = config.isContactPresenceTaskEnabled();
        if (this.isupportMonitor != null) {
            SortedSet<String> monitoredNicks = Collections.synchronizedSortedSet(new TreeSet());
            this.watcher = new MonitorPresenceWatcher(this.irc, this.connectionState, nickWatchList, monitoredNicks, this.operationSet, this.isupportMonitor);
            if (enablePresencePolling) {
                DynamicDifferenceSet<String> unmonitoredNicks = new DynamicDifferenceSet<String>(nickWatchList, monitoredNicks);
                new BasicPollerPresenceWatcher(this.irc, this.connectionState, this.operationSet, unmonitoredNicks, this.serverIdentity);
            }
        } else if (this.isupportWatch != null) {
            SortedSet<String> monitoredNicks = Collections.synchronizedSortedSet(new TreeSet());
            this.watcher = new WatchPresenceWatcher(this.irc, this.connectionState, nickWatchList, monitoredNicks, this.operationSet, this.isupportWatch);
            if (enablePresencePolling) {
                DynamicDifferenceSet<String> unmonitoredNicks = new DynamicDifferenceSet<String>(nickWatchList, monitoredNicks);
                new BasicPollerPresenceWatcher(this.irc, this.connectionState, this.operationSet, unmonitoredNicks, this.serverIdentity);
            }
        } else {
            this.watcher = enablePresencePolling ? new BasicPollerPresenceWatcher(this.irc, this.connectionState, this.operationSet, nickWatchList, this.serverIdentity) : null;
        }
    }

    private Integer parseISupportAwayLen(IIRCState state) {
        String value = state.getServerOptions().getKey(ISupport.AWAYLEN.name());
        if (value == null) {
            LOGGER.trace((Object)("No ISUPPORT parameter " + ISupport.AWAYLEN.name() + " available."));
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Setting ISUPPORT parameter " + ISupport.AWAYLEN.name() + " to " + value));
        }
        try {
            return new Integer(value);
        }
        catch (RuntimeException e) {
            LOGGER.warn((Object)"Failed to parse AWAYLEN value.", (Throwable)e);
            return null;
        }
    }

    private Integer parseISupportMonitor(IIRCState state) {
        String value = state.getServerOptions().getKey(ISupport.MONITOR.name());
        if (value == null) {
            LOGGER.trace((Object)("No ISUPPORT parameter " + ISupport.MONITOR.name() + " available."));
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Setting ISUPPORT parameter " + ISupport.MONITOR.name() + " to " + value));
        }
        try {
            return new Integer(value);
        }
        catch (RuntimeException e) {
            LOGGER.warn((Object)"Failed to parse MONITOR value.", (Throwable)e);
            return null;
        }
    }

    private Integer parseISupportWatch(IIRCState state) {
        String value = state.getServerOptions().getKey(ISupport.WATCH.name());
        if (value == null) {
            LOGGER.trace((Object)("No ISUPPORT parameter " + ISupport.WATCH.name() + " available."));
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Setting ISUPPORT parameter " + ISupport.WATCH.name() + " to " + value));
        }
        try {
            return new Integer(value);
        }
        catch (RuntimeException e) {
            LOGGER.warn((Object)"Failed to parse WATCH value.", (Throwable)e);
            return null;
        }
    }

    public boolean isAway() {
        return this.away;
    }

    public String getMessage() {
        return this.currentMessage;
    }

    public void away(boolean isAway, String awayMessage) {
        if (awayMessage != null) {
            this.submittedMessage = this.verifyMessage(awayMessage);
        }
        if (isAway && (!this.away || awayMessage != null)) {
            this.irc.rawMessage("AWAY :" + this.submittedMessage);
        } else if (isAway != this.away) {
            this.irc.rawMessage("AWAY");
        }
    }

    private String verifyMessage(String message) {
        if (message == null || message.isEmpty()) {
            throw new IllegalArgumentException("away message must be non-null and non-empty");
        }
        if (this.isupportAwayLen != null && message.length() > this.isupportAwayLen) {
            throw new IllegalArgumentException("the away message must not be longer than " + this.isupportAwayLen + " characters according to server's parameters.");
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IrcStatusEnum query(String nick) throws InterruptedException, IOException {
        Result result;
        Result result2 = result = new Result(IrcStatusEnum.OFFLINE);
        synchronized (result2) {
            this.irc.addListener((IMessageListener)new WhoisReplyListener(nick, result));
            this.irc.rawMessage("WHOIS " + IdentityManager.checkNick(nick, null));
            while (!result.isDone()) {
                LOGGER.debug((Object)"Waiting for presence status based on WHOIS reply ...");
                result.wait();
            }
        }
        Object exception = result.getException();
        if (exception == null) {
            return result.getValue();
        }
        throw new IOException("An exception occured while querying whois info.", (Throwable)result.getException());
    }

    public void addNickWatch(String nick) {
        if (this.watcher != null) {
            this.watcher.add(nick);
        }
    }

    public void removeNickWatch(String nick) {
        if (this.watcher != null) {
            this.watcher.remove(nick);
        }
    }

    private final class WhoisReplyListener
    extends AbstractIrcMessageListener {
        private static final int IRC_RPL_AWAY = 301;
        private static final int IRC_RPL_WHOISUSER = 311;
        private static final int IRC_RPL_ENDOFWHOIS = 318;
        private final String nick;
        private final Result<IrcStatusEnum, IllegalStateException> result;
        private IrcStatusEnum presence;

        private WhoisReplyListener(String nick, Result<IrcStatusEnum, IllegalStateException> result) {
            super(PresenceManager.this.irc, PresenceManager.this.connectionState);
            if (nick == null) {
                throw new IllegalArgumentException("Invalid nick specified.");
            }
            this.nick = nick;
            if (result == null) {
                throw new IllegalArgumentException("Invalid result.");
            }
            this.result = result;
            this.presence = IrcStatusEnum.OFFLINE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServerNumericMessage(ServerNumericMessage msg) {
            if (!this.nick.equals(msg.getTarget())) {
                return;
            }
            switch (msg.getNumericCode()) {
                case 311: {
                    if (this.presence == IrcStatusEnum.AWAY) break;
                    this.presence = IrcStatusEnum.ONLINE;
                    break;
                }
                case 301: {
                    this.presence = IrcStatusEnum.AWAY;
                    break;
                }
                case 318: {
                    this.irc.deleteListener((IMessageListener)this);
                    Result<IrcStatusEnum, IllegalStateException> result = this.result;
                    synchronized (result) {
                        this.result.setDone((IllegalStateException)((Object)this.presence));
                        this.result.notifyAll();
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUserQuit(QuitMessage msg) {
            super.onUserQuit(msg);
            if (this.localUser(msg.getSource().getNick())) {
                Result<IrcStatusEnum, IllegalStateException> result = this.result;
                synchronized (result) {
                    this.result.setDone(new IllegalStateException("Local user quit."));
                    this.result.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(ErrorMessage msg) {
            super.onError(msg);
            Result<IrcStatusEnum, IllegalStateException> result = this.result;
            synchronized (result) {
                this.result.setDone(new IllegalStateException("An error occurred: " + msg.getText()));
                this.result.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClientError(ClientErrorMessage msg) {
            super.onClientError(msg);
            Result<IrcStatusEnum, IllegalStateException> result = this.result;
            synchronized (result) {
                this.result.setDone(new IllegalStateException("An error occurred: " + msg.asRaw()));
                this.result.notifyAll();
            }
        }
    }

    private final class LocalUserPresenceListener
    extends AbstractIrcMessageListener {
        private static final int IRC_RPL_UNAWAY = 305;
        private static final int IRC_RPL_NOWAWAY = 306;

        public LocalUserPresenceListener() {
            super(PresenceManager.this.irc, PresenceManager.this.connectionState);
        }

        public void onServerNumericMessage(ServerNumericMessage msg) {
            Integer msgCode;
            if (PresenceManager.this.serverIdentity.get() == null) {
                PresenceManager.this.serverIdentity.set(msg.getSource().getHostname());
            }
            if ((msgCode = msg.getNumericCode()) == null) {
                return;
            }
            int code = msgCode;
            switch (code) {
                case 305: {
                    PresenceManager.this.currentMessage = "";
                    PresenceManager.this.away = false;
                    PresenceManager.this.operationSet.updatePresenceStatus(IrcStatusEnum.AWAY, IrcStatusEnum.ONLINE);
                    LOGGER.debug((Object)"Away status disabled.");
                    break;
                }
                case 306: {
                    PresenceManager.this.currentMessage = PresenceManager.this.submittedMessage;
                    PresenceManager.this.away = true;
                    PresenceManager.this.operationSet.updatePresenceStatus(IrcStatusEnum.ONLINE, IrcStatusEnum.AWAY);
                    LOGGER.debug((Object)("Away status enabled with message \"" + PresenceManager.this.currentMessage + "\""));
                    break;
                }
            }
        }
    }
}

