/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.fileaccess;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import net.java.sip.communicator.slick.fileaccess.FileAccessServiceLick;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.fileaccess.FileCategory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TestFileAccessService
extends TestCase {
    private FileAccessService fileAccessService = null;
    private static final byte[] testData = "The quick brown fox jumped over the lazy dog".getBytes();
    private static final Random randomData = new Random();
    private static final String dirName = "fileaccessservice.dir.tst";
    private static final String fileName = "fileaccessservice.tst";

    public TestFileAccessService(String name) {
        super(name);
        BundleContext context = FileAccessServiceLick.bc;
        ServiceReference ref = context.getServiceReference(FileAccessService.class.getName());
        this.fileAccessService = (FileAccessService)context.getService(ref);
    }

    public void testCreateReadWriteTemporaryFile() {
        try {
            File tempFile = this.fileAccessService.getTemporaryFile();
            TestFileAccessService.assertEquals((long)tempFile.length(), (long)0L);
            this.writeReadFile(tempFile);
        }
        catch (IOException e) {
            TestFileAccessService.fail((String)("Error while opening the temp file: " + e.getMessage()));
        }
    }

    public void testCreateTemporaryDirectory() throws Exception {
        try {
            this.fileAccessService.getTemporaryDirectory();
        }
        catch (IOException e) {
            TestFileAccessService.fail((String)("Error creating the temp directory: " + e.getMessage()));
        }
    }

    public void testCreateReadWriteFileInTemporaryDirectory() throws Exception {
        int i;
        int testFiles = 10;
        File[] files = new File[testFiles];
        byte[][] randomData = new byte[testFiles][];
        for (i = 0; i < testFiles; ++i) {
            File tempDir = null;
            try {
                tempDir = this.fileAccessService.getTemporaryDirectory();
            }
            catch (IOException e) {
                TestFileAccessService.fail((String)("Error creating the temp directory: " + e.getMessage()));
            }
            files[i] = new File(tempDir, fileName);
            TestFileAccessService.assertTrue((String)"Error creating file in temp dir", (boolean)files[i].createNewFile());
            randomData[i] = this.generateRandomData();
            this.writeFile(files[i], randomData[i]);
        }
        for (i = 0; i < testFiles; ++i) {
            this.readFile(files[i], randomData[i]);
        }
    }

    public void testCreatePersistentDirectory() throws Exception {
        try {
            this.fileAccessService.getPrivatePersistentDirectory(dirName, FileCategory.PROFILE);
        }
        catch (IOException e) {
            TestFileAccessService.fail((String)("Error creating the temp directory: " + e.getMessage()));
        }
    }

    public void testCreateReadWriteFileInPersistentDirectory() throws Exception {
        File privateDir = null;
        try {
            privateDir = this.fileAccessService.getPrivatePersistentDirectory(dirName, FileCategory.PROFILE);
        }
        catch (IOException e) {
            TestFileAccessService.fail((String)("Error creating the private directory: " + e.getMessage()));
        }
        File file = new File(privateDir, fileName);
        if (file.exists()) {
            TestFileAccessService.assertTrue((String)("Persistent file exists. Delete attempt failed. Have you ran the tests with other user? Is the file locked?" + file.getAbsolutePath()), (boolean)file.delete());
        }
        TestFileAccessService.assertTrue((String)("Error creating file in dir" + file.getAbsolutePath()), (boolean)file.createNewFile());
        this.writeReadFile(file);
        file.delete();
        TestFileAccessService.assertFalse((String)("Could not clean up created file " + file.getAbsolutePath()), (boolean)file.exists());
    }

    public void testCreatePersistentFile() {
        try {
            File file = this.fileAccessService.getPrivatePersistentFile(fileName, FileCategory.PROFILE);
            if (!file.exists()) {
                TestFileAccessService.assertTrue((boolean)file.createNewFile());
            }
        }
        catch (Exception e) {
            TestFileAccessService.fail((String)e.getMessage());
        }
    }

    public void testDeletePersistentFile() {
        try {
            File file = this.fileAccessService.getPrivatePersistentFile(fileName, FileCategory.PROFILE);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testCreateReadWritePersistentFile() {
        try {
            File file = this.fileAccessService.getPrivatePersistentFile(fileName, FileCategory.PROFILE);
            if (!file.exists()) {
                TestFileAccessService.assertTrue((boolean)file.createNewFile());
            }
            this.writeReadFile(file);
        }
        catch (Exception e) {
            TestFileAccessService.fail((String)e.getMessage());
        }
    }

    public void testPersistentFilePersistency() {
        try {
            File file = this.fileAccessService.getPrivatePersistentFile(fileName, FileCategory.PROFILE);
            if (!file.exists()) {
                TestFileAccessService.assertTrue((boolean)file.createNewFile());
            }
            this.writeReadFile(file);
            File newFile = this.fileAccessService.getPrivatePersistentFile(fileName, FileCategory.PROFILE);
            TestFileAccessService.assertEquals((Object)file, (Object)newFile);
            TestFileAccessService.assertEquals((long)file.length(), (long)newFile.length());
        }
        catch (Exception e) {
            TestFileAccessService.fail((String)e.getMessage());
        }
    }

    private void writeReadFile(File file) {
        byte[] randomData = this.generateRandomData();
        this.writeFile(file, randomData);
        this.readFile(file, randomData);
    }

    private byte[] generateRandomData() {
        int rndInt = randomData.nextInt(Integer.MAX_VALUE);
        return Integer.toHexString(rndInt).getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File file, byte[] randomData) {
        TestFileAccessService.assertTrue((boolean)file.canWrite());
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(file);
            output.write(testData);
            output.write(randomData);
            output.flush();
        }
        catch (Exception e) {
            TestFileAccessService.fail((String)("Could not write to file: " + e.getMessage()));
        }
        finally {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(File file, byte[] randomData) {
        int i;
        TestFileAccessService.assertTrue((boolean)file.canRead());
        FileInputStream input = null;
        byte[] readBuff = new byte[testData.length + randomData.length];
        try {
            input = new FileInputStream(file);
            input.read(readBuff);
        }
        catch (Exception e) {
            TestFileAccessService.fail((String)("Could not read from file: " + e.getMessage()));
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {}
        }
        for (i = 0; i < testData.length; ++i) {
            TestFileAccessService.assertEquals((byte)readBuff[i], (byte)testData[i]);
        }
        for (i = 0; i < randomData.length; ++i) {
            TestFileAccessService.assertEquals((byte)readBuff[testData.length + i], (byte)randomData[i]);
        }
    }
}

