/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.callhistory;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import net.java.sip.communicator.impl.callhistory.CallHistoryContactSource;
import net.java.sip.communicator.impl.callhistory.CallHistoryServiceImpl;
import net.java.sip.communicator.service.callhistory.CallHistoryService;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.history.HistoryService;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CallHistoryActivator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(CallHistoryActivator.class);
    public static BundleContext bundleContext;
    private static CallHistoryServiceImpl callHistoryService;
    private static ResourceManagementService resourcesService;
    private static final Map<Object, ProtocolProviderFactory> providerFactoriesMap;

    public void start(BundleContext bc) throws Exception {
        bundleContext = bc;
        try {
            logger.logEntry();
            HistoryService historyService = (HistoryService)ServiceUtils.getService((BundleContext)bundleContext, HistoryService.class);
            callHistoryService = new CallHistoryServiceImpl();
            callHistoryService.setHistoryService(historyService);
            callHistoryService.start(bundleContext);
            bundleContext.registerService(CallHistoryService.class.getName(), (Object)callHistoryService, null);
            bundleContext.registerService(ContactSourceService.class.getName(), (Object)new CallHistoryContactSource(), null);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Call History Service ...[REGISTERED]");
            }
        }
        finally {
            logger.logExit();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (callHistoryService != null) {
            callHistoryService.stop(bundleContext);
        }
    }

    public static CallHistoryService getCallHistoryService() {
        return callHistoryService;
    }

    public static ResourceManagementService getResources() {
        if (resourcesService == null) {
            resourcesService = (ResourceManagementService)ServiceUtils.getService((BundleContext)bundleContext, ResourceManagementService.class);
        }
        return resourcesService;
    }

    public static Map<Object, ProtocolProviderFactory> getProtocolProviderFactories() {
        Collection serRefs = ServiceUtils.getServiceReferences((BundleContext)bundleContext, ProtocolProviderFactory.class);
        if (!serRefs.isEmpty()) {
            for (ServiceReference serRef : serRefs) {
                ProtocolProviderFactory providerFactory = (ProtocolProviderFactory)bundleContext.getService(serRef);
                providerFactoriesMap.put(serRef.getProperty("PROTOCOL_NAME"), providerFactory);
            }
        }
        return providerFactoriesMap;
    }

    static {
        callHistoryService = null;
        providerFactoriesMap = new Hashtable<Object, ProtocolProviderFactory>();
    }
}

