/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.msghistory;

import java.util.EventObject;
import java.util.regex.Pattern;
import net.java.sip.communicator.impl.msghistory.MessageSourceContact;
import net.java.sip.communicator.impl.msghistory.MessageSourceService;
import net.java.sip.communicator.service.contactsource.AsyncContactQuery;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.PresenceStatus;

public class MessageSourceContactQuery
extends AsyncContactQuery<MessageSourceService> {
    MessageSourceContactQuery(MessageSourceService messageSourceService) {
        super((ContactSourceService)messageSourceService, Pattern.compile("", 18), false);
    }

    public void run() {
        ((MessageSourceService)this.getContactSource()).updateRecentMessages();
    }

    public void updateCapabilities(Object srcObj, EventObject eventObj) {
        for (SourceContact msc : this.getQueryResults()) {
            if (!srcObj.equals(msc) || !(msc instanceof MessageSourceContact)) continue;
            ((MessageSourceContact)msc).initDetails(eventObj);
            break;
        }
    }

    public void updateCapabilities(Object srcObj, Contact contact) {
        for (SourceContact msc : this.getQueryResults()) {
            if (!srcObj.equals(msc) || !(msc instanceof MessageSourceContact)) continue;
            ((MessageSourceContact)msc).initDetails(false, contact);
            break;
        }
    }

    public void updateContact(Object srcObj, EventObject eventObject) {
        for (SourceContact msc : this.getQueryResults()) {
            if (!srcObj.equals(msc) || !(msc instanceof MessageSourceContact)) continue;
            ((MessageSourceContact)msc).update(eventObject);
            super.fireContactChanged(msc);
            break;
        }
    }

    public void fireContactChanged(Object srcObj) {
        for (SourceContact msc : this.getQueryResults()) {
            if (!srcObj.equals(msc) || !(msc instanceof MessageSourceContact)) continue;
            super.fireContactChanged(msc);
            break;
        }
    }

    public void updateContactStatus(Object srcObj, PresenceStatus status) {
        for (SourceContact msc : this.getQueryResults()) {
            if (!srcObj.equals(msc) || !(msc instanceof MessageSourceContact)) continue;
            ((MessageSourceContact)msc).setStatus(status);
            super.fireContactChanged(msc);
            break;
        }
    }

    public void updateContactDisplayName(Object srcObj, String newName) {
        for (SourceContact msc : this.getQueryResults()) {
            if (!srcObj.equals(msc) || !(msc instanceof MessageSourceContact)) continue;
            ((MessageSourceContact)msc).setDisplayName(newName);
            super.fireContactChanged(msc);
            break;
        }
    }

    public void fireContactRemoved(Object srcObj) {
        for (SourceContact msc : this.getQueryResults()) {
            if (!srcObj.equals(msc)) continue;
            super.fireContactRemoved(msc);
            break;
        }
    }

    public boolean addQueryResult(SourceContact sourceContact) {
        return super.addQueryResult(sourceContact, false);
    }
}

