/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.msghistory;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.msghistory.MessageHistoryActivator;
import net.java.sip.communicator.impl.msghistory.MessageSourceService;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.event.MetaContactListListener;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.history.History;
import net.java.sip.communicator.service.history.HistoryID;
import net.java.sip.communicator.service.history.HistoryReader;
import net.java.sip.communicator.service.history.HistoryService;
import net.java.sip.communicator.service.history.HistoryWriter;
import net.java.sip.communicator.service.history.QueryResultSet;
import net.java.sip.communicator.service.history.event.HistorySearchProgressListener;
import net.java.sip.communicator.service.history.event.ProgressEvent;
import net.java.sip.communicator.service.history.records.HistoryRecord;
import net.java.sip.communicator.service.history.records.HistoryRecordStructure;
import net.java.sip.communicator.service.msghistory.MessageHistoryAdvancedService;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.service.msghistory.event.MessageHistorySearchProgressListener;
import net.java.sip.communicator.service.protocol.AbstractMessage;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.AdHocChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetSmsMessaging;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.AdHocChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.ContactCapabilitiesListener;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.LocalUserAdHocChatRoomPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserAdHocChatRoomPresenceListener;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceListener;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageListener;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.SubscriptionListener;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusEnum;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.UtilActivator;
import net.java.sip.communicator.util.account.AccountUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class MessageHistoryServiceImpl
implements MessageHistoryService,
MessageHistoryAdvancedService,
MessageListener,
ChatRoomMessageListener,
AdHocChatRoomMessageListener,
ServiceListener,
LocalUserChatRoomPresenceListener,
LocalUserAdHocChatRoomPresenceListener {
    private static Logger logger = Logger.getLogger(MessageHistoryServiceImpl.class);
    static String[] STRUCTURE_NAMES = new String[]{"dir", "msg_CDATA", "msgTyp", "enc", "uid", "sub", "receivedTimestamp", "msgSubTyp"};
    private static HistoryRecordStructure recordStructure = new HistoryRecordStructure(STRUCTURE_NAMES);
    private static final String SEARCH_FIELD = "msg";
    static final String MSG_SUBTYPE_SMS = "sms";
    private BundleContext bundleContext = null;
    private HistoryService historyService = null;
    private Object syncRoot_HistoryService = new Object();
    private Hashtable<MessageHistorySearchProgressListener, HistorySearchProgressListener> progressListeners = new Hashtable();
    private ConfigurationService configService;
    private MessageHistoryPropertyChangeListener msgHistoryPropListener;
    private static boolean isHistoryLoggingEnabled;
    private MessageSourceService messageSourceService;
    private ServiceRegistration messageSourceServiceReg = null;

    public HistoryService getHistoryService() {
        return this.historyService;
    }

    @Override
    public Collection<EventObject> findByStartDate(MetaContact contact, Date startDate) throws RuntimeException {
        HashSet<EventObject> result = new HashSet<EventObject>();
        Map<Contact, HistoryReader> readers = this.getHistoryReaders(contact);
        int recordsCount = this.countRecords(readers);
        for (Map.Entry<Contact, HistoryReader> readerEntry : readers.entrySet()) {
            Contact item = readerEntry.getKey();
            HistoryReader reader = readerEntry.getValue();
            this.addHistorySearchProgressListeners(reader, recordsCount);
            QueryResultSet recs = reader.findByStartDate(startDate);
            while (recs.hasNext()) {
                result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), item));
            }
        }
        this.removeHistorySearchProgressListeners(readers);
        return result;
    }

    private void removeHistorySearchProgressListeners(Map<?, HistoryReader> readers) {
        for (HistoryReader item : readers.values()) {
            this.removeHistorySearchProgressListeners(item);
        }
    }

    @Override
    public Collection<EventObject> findByEndDate(MetaContact contact, Date endDate) throws RuntimeException {
        HashSet<EventObject> result = new HashSet<EventObject>();
        Map<Contact, HistoryReader> readers = this.getHistoryReaders(contact);
        int recordsCount = this.countRecords(readers);
        for (Map.Entry<Contact, HistoryReader> readerEntry : readers.entrySet()) {
            Contact item = readerEntry.getKey();
            HistoryReader reader = readerEntry.getValue();
            this.addHistorySearchProgressListeners(reader, recordsCount);
            QueryResultSet recs = reader.findByEndDate(endDate);
            while (recs.hasNext()) {
                result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), item));
            }
        }
        this.removeHistorySearchProgressListeners(readers);
        return result;
    }

    @Override
    public Collection<EventObject> findByPeriod(MetaContact contact, Date startDate, Date endDate) throws RuntimeException {
        HashSet<EventObject> result = new HashSet<EventObject>();
        Map<Contact, HistoryReader> readers = this.getHistoryReaders(contact);
        int recordsCount = this.countRecords(readers);
        for (Map.Entry<Contact, HistoryReader> readerEntry : readers.entrySet()) {
            Contact item = readerEntry.getKey();
            HistoryReader reader = readerEntry.getValue();
            this.addHistorySearchProgressListeners(reader, recordsCount);
            QueryResultSet recs = reader.findByPeriod(startDate, endDate);
            while (recs.hasNext()) {
                result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), item));
            }
        }
        this.removeHistorySearchProgressListeners(readers);
        return result;
    }

    @Override
    public Collection<EventObject> findByPeriod(MetaContact contact, Date startDate, Date endDate, String[] keywords) throws RuntimeException {
        return this.findByPeriod(contact, startDate, endDate, keywords, false);
    }

    @Override
    public Collection<EventObject> findByKeyword(MetaContact contact, String keyword) throws RuntimeException {
        return this.findByKeyword(contact, keyword, false);
    }

    @Override
    public Collection<EventObject> findByKeywords(MetaContact contact, String[] keywords) throws RuntimeException {
        return this.findByKeywords(contact, keywords, false);
    }

    @Override
    public Collection<EventObject> findLast(MetaContact contact, int count) throws RuntimeException {
        LinkedList<EventObject> result = new LinkedList<EventObject>();
        Iterator iter = contact.getContacts();
        while (iter.hasNext()) {
            Contact item = (Contact)iter.next();
            try {
                History history = this.getHistory(null, item);
                HistoryReader reader = history.getReader();
                QueryResultSet recs = reader.findLast(count);
                while (recs.hasNext()) {
                    result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), item));
                }
            }
            catch (IOException e) {
                logger.error((Object)"Could not read history", (Throwable)e);
            }
        }
        Collections.sort(result, new MessageEventComparator());
        int startIndex = result.size() - count;
        if (startIndex < 0) {
            startIndex = 0;
        }
        return result.subList(startIndex, result.size());
    }

    private boolean hasMessages(HistoryID historyID, String[] keywords, String field, boolean caseSensitive) throws IOException {
        if (!this.historyService.isHistoryCreated(historyID)) {
            return false;
        }
        History history = this.historyService.createHistory(historyID, recordStructure);
        return history.getReader().findLast(1, keywords, field, caseSensitive).hasNext();
    }

    Collection<EventObject> findRecentMessagesPerContact(int count, String providerToFilter, String contactToFilter, boolean isSMSEnabled) throws RuntimeException {
        HashSet<EventObject> result = new HashSet<EventObject>();
        List historyIDs = this.historyService.getExistingHistories(new String[]{"messages", "default"});
        String providerFilterStr = null;
        if (providerToFilter != null) {
            providerFilterStr = HistoryID.readableHash((String)providerToFilter);
        }
        for (HistoryID id : historyIDs) {
            if (result.size() >= count) break;
            try {
                EventObject o;
                Object descriptor;
                if (id.getID().length != 4 || providerFilterStr != null && !id.getID()[2].startsWith(providerFilterStr) || contactToFilter != null && !id.getID()[3].startsWith(contactToFilter) || (descriptor = this.getContactOrRoomByID(providerToFilter, id.getID()[3], id, isSMSEnabled)) == null) continue;
                History history = this.historyService.createHistory(id, recordStructure);
                HistoryReader reader = history.getReader();
                QueryResultSet recs = isSMSEnabled ? reader.findLast(1, new String[]{MSG_SUBTYPE_SMS}, STRUCTURE_NAMES[7], true) : reader.findLast(1);
                if (!recs.hasNext()) continue;
                if (descriptor instanceof Contact) {
                    o = this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), (Contact)descriptor);
                    result.add(o);
                }
                if (!(descriptor instanceof ChatRoom)) continue;
                o = this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), (ChatRoom)descriptor);
                result.add(o);
            }
            catch (IOException ex) {
                logger.error((Object)"Could not read history", (Throwable)ex);
            }
        }
        return result;
    }

    private Object getContactOrRoomByID(String accountID, String id, HistoryID historyID, boolean isSMSEnabled) throws IOException {
        AccountID account = null;
        for (AccountID acc : AccountUtils.getStoredAccounts()) {
            if (acc.isHidden() || !acc.isEnabled() || !accountID.startsWith(acc.getAccountUniqueID())) continue;
            account = acc;
            break;
        }
        if (account == null) {
            return null;
        }
        ProtocolProviderService pps = AccountUtils.getRegisteredProviderForAccount(account);
        if (pps == null) {
            return null;
        }
        OperationSetPersistentPresence opSetPresence = (OperationSetPersistentPresence)pps.getOperationSet(OperationSetPersistentPresence.class);
        if (opSetPresence == null) {
            return null;
        }
        Contact contact = opSetPresence.findContactByID(id);
        if (isSMSEnabled) {
            if (contact != null && this.hasMessages(historyID, new String[]{MSG_SUBTYPE_SMS}, STRUCTURE_NAMES[7], true)) {
                return contact;
            }
            OperationSetSmsMessaging opSetSMS = (OperationSetSmsMessaging)pps.getOperationSet(OperationSetSmsMessaging.class);
            if (opSetSMS == null || !this.hasMessages(historyID, new String[]{MSG_SUBTYPE_SMS}, STRUCTURE_NAMES[7], true)) {
                return null;
            }
            return opSetSMS.getContact(id);
        }
        if (contact != null) {
            return contact;
        }
        OperationSetMultiUserChat opSetMuc = (OperationSetMultiUserChat)pps.getOperationSet(OperationSetMultiUserChat.class);
        if (opSetMuc == null) {
            return null;
        }
        try {
            id = id.substring(0, id.lastIndexOf(64));
            return opSetMuc.findRoom(id);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Collection<EventObject> findFirstMessagesAfter(MetaContact contact, Date date, int count) throws RuntimeException {
        LinkedList<EventObject> result = new LinkedList<EventObject>();
        Iterator iter = contact.getContacts();
        while (iter.hasNext()) {
            Contact item = (Contact)iter.next();
            try {
                History history = this.getHistory(null, item);
                HistoryReader reader = history.getReader();
                QueryResultSet recs = reader.findFirstRecordsAfter(date, count + 4);
                while (recs.hasNext()) {
                    result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), item));
                }
            }
            catch (IOException e) {
                logger.error((Object)"Could not read history", (Throwable)e);
            }
        }
        int startIx = 0;
        Iterator i = result.iterator();
        boolean isRecordOK = false;
        while (i.hasNext() && !isRecordOK) {
            Object object = i.next();
            if (object instanceof MessageDeliveredEvent) {
                isRecordOK = ((MessageDeliveredEvent)object).getTimestamp().getTime() > date.getTime();
            } else if (object instanceof MessageReceivedEvent) {
                boolean bl = isRecordOK = ((MessageReceivedEvent)object).getTimestamp().getTime() > date.getTime();
            }
            if (isRecordOK) continue;
            ++startIx;
        }
        Collections.sort(result, new MessageEventComparator());
        int toIndex = startIx + count;
        if (toIndex > result.size()) {
            toIndex = result.size();
        }
        return result.subList(startIx, toIndex);
    }

    @Override
    public Collection<EventObject> findLastMessagesBefore(MetaContact contact, Date date, int count) throws RuntimeException {
        LinkedList<EventObject> result = new LinkedList<EventObject>();
        Iterator iter = contact.getContacts();
        while (iter.hasNext()) {
            Contact item = (Contact)iter.next();
            try {
                History history = this.getHistory(null, item);
                HistoryReader reader = history.getReader();
                QueryResultSet recs = reader.findLastRecordsBefore(date, count);
                while (recs.hasNext()) {
                    result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), item));
                }
            }
            catch (IOException e) {
                logger.error((Object)"Could not read history", (Throwable)e);
            }
        }
        Collections.sort(result, new MessageEventComparator());
        int startIndex = result.size() - count;
        if (startIndex < 0) {
            startIndex = 0;
        }
        return result.subList(startIndex, result.size());
    }

    private History getHistory(Contact localContact, Contact remoteContact) throws IOException {
        HistoryID historyId_old;
        HistoryID historyId;
        String localId = localContact == null ? "default" : localContact.getAddress();
        String remoteId = remoteContact == null ? "default" : remoteContact.getAddress();
        String account = "unkown";
        if (remoteContact != null) {
            account = remoteContact.getProtocolProvider().getAccountID().getAccountUniqueID();
        }
        if (!this.historyService.isHistoryCreated(historyId = HistoryID.createFromRawID((String[])new String[]{"messages", localId, account, remoteId})) && this.historyService.isHistoryCreated(historyId_old = HistoryID.createFromRawID((String[])new String[]{"messages", localId, remoteId}))) {
            try {
                this.historyService.moveHistory(historyId_old, historyId);
            }
            catch (IOException iOException) {
                historyId = historyId_old;
            }
        }
        return this.historyService.createHistory(historyId, recordStructure);
    }

    private History getHistoryForMultiChat(ChatRoom room) throws IOException {
        AccountID account = room.getParentProvider().getAccountID();
        return this.getHistoryForMultiChat(null, account.getAccountUniqueID(), account.getService(), room.getName());
    }

    private History getHistoryForAdHocMultiChat(AdHocChatRoom room) throws IOException {
        AccountID account = room.getParentProvider().getAccountID();
        return this.getHistoryForMultiChat(null, account.getAccountUniqueID(), account.getService(), room.getName());
    }

    private History getHistoryForMultiChat(Contact localContact, String account, String server, String channel) throws IOException {
        String localId = localContact == null ? "default" : localContact.getAddress();
        HistoryID historyId = HistoryID.createFromRawID((String[])new String[]{"messages", localId, account, channel + "@" + server});
        return this.historyService.createHistory(historyId, recordStructure);
    }

    private EventObject convertHistoryRecordToMessageEvent(HistoryRecord hr, Contact contact) {
        MessageImpl msg = this.createMessageFromHistoryRecord(hr);
        Date messageReceivedDate = msg.getMessageReceivedDate();
        Date hrTimestamp = hr.getTimestamp();
        Date timestamp = messageReceivedDate.getTime() != 0L ? (messageReceivedDate.getTime() - hrTimestamp.getTime() > 86400000L ? hrTimestamp : msg.getMessageReceivedDate()) : hrTimestamp;
        if (msg.isOutgoing) {
            MessageDeliveredEvent evt = new MessageDeliveredEvent((Message)msg, contact, timestamp);
            if (msg.getMsgSubType() != null && msg.getMsgSubType().equals(MSG_SUBTYPE_SMS)) {
                evt.setSmsMessage(true);
            }
            return evt;
        }
        int eventType = 1;
        if (msg.getMsgSubType() != null && msg.getMsgSubType().equals(MSG_SUBTYPE_SMS)) {
            eventType = 3;
        }
        return new MessageReceivedEvent((Message)msg, contact, timestamp, eventType);
    }

    private EventObject convertHistoryRecordToMessageEvent(HistoryRecord hr, ChatRoom room) {
        MessageImpl msg = this.createMessageFromHistoryRecord(hr);
        Date messageReceivedDate = msg.getMessageReceivedDate();
        Date hrTimestamp = hr.getTimestamp();
        Date timestamp = messageReceivedDate.getTime() != 0L ? (messageReceivedDate.getTime() - hrTimestamp.getTime() > 86400000L ? hrTimestamp : msg.getMessageReceivedDate()) : hrTimestamp;
        String fromStr = hr.getPropertyValues()[5];
        ChatRoomMemberImpl from = new ChatRoomMemberImpl(fromStr, room, null);
        if (msg.isOutgoing) {
            return new ChatRoomMessageDeliveredEvent(room, timestamp, (Message)msg, 1);
        }
        return new ChatRoomMessageReceivedEvent(room, (ChatRoomMember)from, timestamp, (Message)msg, 1);
    }

    private MessageImpl createMessageFromHistoryRecord(HistoryRecord hr) {
        String textContent = null;
        String contentType = null;
        String contentEncoding = null;
        String messageUID = null;
        String subject = null;
        boolean isOutgoing = false;
        Date messageReceivedDate = new Date(0L);
        String msgSubType = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        for (int i = 0; i < hr.getPropertyNames().length; ++i) {
            String propName = hr.getPropertyNames()[i];
            if (propName.equals(SEARCH_FIELD) || propName.equals(STRUCTURE_NAMES[1])) {
                textContent = hr.getPropertyValues()[i];
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[2])) {
                contentType = hr.getPropertyValues()[i];
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[3])) {
                contentEncoding = hr.getPropertyValues()[i];
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[4])) {
                messageUID = hr.getPropertyValues()[i];
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[5])) {
                subject = hr.getPropertyValues()[i];
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[0])) {
                if (hr.getPropertyValues()[i].equals("in")) {
                    isOutgoing = false;
                    continue;
                }
                if (!hr.getPropertyValues()[i].equals("out")) continue;
                isOutgoing = true;
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[6])) {
                try {
                    messageReceivedDate = sdf.parse(hr.getPropertyValues()[i]);
                }
                catch (ParseException e) {
                    messageReceivedDate = new Date(Long.parseLong(hr.getPropertyValues()[i]));
                }
                continue;
            }
            if (!propName.equals(STRUCTURE_NAMES[7])) continue;
            msgSubType = hr.getPropertyValues()[i];
        }
        return new MessageImpl(textContent, contentType, contentEncoding, subject, messageUID, isOutgoing, messageReceivedDate, msgSubType);
    }

    public void start(BundleContext bc) {
        this.bundleContext = bc;
        ServiceReference refConfig = this.bundleContext.getServiceReference(ConfigurationService.class.getName());
        this.configService = (ConfigurationService)this.bundleContext.getService(refConfig);
        boolean isMessageHistoryEnabled = this.configService.getBoolean("net.java.sip.communicator.service.msghistory.IS_MESSAGE_HISTORY_ENABLED", Boolean.parseBoolean(MessageHistoryActivator.getResources().getSettingsString("net.java.sip.communicator.service.msghistory.IS_MESSAGE_HISTORY_ENABLED")));
        this.msgHistoryPropListener = new MessageHistoryPropertyChangeListener();
        isHistoryLoggingEnabled = this.configService.getBoolean("net.java.sip.communicator.service.msghistory.IS_MESSAGE_HISTORY_ENABLED", Boolean.parseBoolean(UtilActivator.getResources().getSettingsString("net.java.sip.communicator.service.msghistory.IS_MESSAGE_HISTORY_ENABLED")));
        this.configService.addPropertyChangeListener("net.java.sip.communicator.service.msghistory.IS_MESSAGE_HISTORY_ENABLED", (PropertyChangeListener)this.msgHistoryPropListener);
        if (isMessageHistoryEnabled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Starting the msg history implementation.");
            }
            this.loadMessageHistoryService();
        }
    }

    private void loadRecentMessages() {
        this.messageSourceService = new MessageSourceService(this);
        this.messageSourceServiceReg = this.bundleContext.registerService(ContactSourceService.class.getName(), (Object)this.messageSourceService, null);
        MessageHistoryActivator.getContactListService().addMetaContactListListener((MetaContactListListener)this.messageSourceService);
    }

    private void stopRecentMessages() {
        if (this.messageSourceServiceReg != null) {
            MessageHistoryActivator.getContactListService().removeMetaContactListListener((MetaContactListListener)this.messageSourceService);
            this.messageSourceServiceReg.unregister();
            this.messageSourceServiceReg = null;
            this.messageSourceService = null;
        }
    }

    public void stop(BundleContext bc) {
        if (this.configService != null) {
            this.configService.removePropertyChangeListener((PropertyChangeListener)this.msgHistoryPropListener);
        }
        this.stopMessageHistoryService();
    }

    public void messageReceived(MessageReceivedEvent evt) {
        this.writeMessage("in", null, evt.getSourceContact(), evt.getSourceMessage(), evt.getTimestamp(), evt.getEventType() == 3);
    }

    public void messageDelivered(MessageDeliveredEvent evt) {
        this.writeMessage("out", null, evt.getDestinationContact(), evt.getSourceMessage(), evt.getTimestamp(), evt.isSmsMessage());
    }

    public void messageDeliveryFailed(MessageDeliveryFailedEvent evt) {
    }

    public void messageReceived(ChatRoomMessageReceivedEvent evt) {
        if (!this.isHistoryLoggingEnabled(evt.getSourceChatRoom().getIdentifier())) {
            return;
        }
        try {
            if (evt.getEventType() != 1) {
                return;
            }
            History history = this.getHistoryForMultiChat(evt.getSourceChatRoom());
            if (evt.isHistoryMessage()) {
                Collection<EventObject> c = this.findFirstMessagesAfter(evt.getSourceChatRoom(), new Date(evt.getTimestamp().getTime() - 10000L), 20);
                Iterator<EventObject> iter = c.iterator();
                boolean isPresent = false;
                while (iter.hasNext()) {
                    EventObject e = iter.next();
                    if (!(e instanceof ChatRoomMessageReceivedEvent)) continue;
                    ChatRoomMessageReceivedEvent cev = (ChatRoomMessageReceivedEvent)e;
                    if (evt.getSourceChatRoomMember().getContactAddress() != null && evt.getSourceChatRoomMember().getContactAddress().equals(cev.getSourceChatRoomMember().getContactAddress()) && evt.getTimestamp() != null && evt.getTimestamp().equals(cev.getTimestamp())) {
                        isPresent = true;
                        break;
                    }
                    Message m1 = cev.getMessage();
                    Message m2 = evt.getMessage();
                    if (m1 == null || m2 == null || !m1.getContent().equals(m2.getContent())) continue;
                    isPresent = true;
                    break;
                }
                if (isPresent) {
                    return;
                }
            }
            this.writeMessage(history, "in", evt.getSourceChatRoomMember(), evt.getMessage(), evt.getTimestamp());
        }
        catch (IOException e) {
            logger.error((Object)"Could not add message to history", (Throwable)e);
        }
    }

    public void messageDelivered(ChatRoomMessageDeliveredEvent evt) {
        try {
            if (!this.isHistoryLoggingEnabled(evt.getSourceChatRoom().getIdentifier())) {
                return;
            }
            History history = this.getHistoryForMultiChat(evt.getSourceChatRoom());
            if (evt.isHistoryMessage()) {
                Collection<EventObject> c = this.findFirstMessagesAfter(evt.getSourceChatRoom(), new Date(evt.getTimestamp().getTime() - 10000L), 20);
                Iterator<EventObject> iter = c.iterator();
                boolean isPresent = false;
                while (iter.hasNext()) {
                    EventObject e = iter.next();
                    if (!(e instanceof ChatRoomMessageDeliveredEvent)) continue;
                    ChatRoomMessageDeliveredEvent cev = (ChatRoomMessageDeliveredEvent)e;
                    if (evt.getTimestamp() != null && evt.getTimestamp().equals(cev.getTimestamp())) {
                        isPresent = true;
                        break;
                    }
                    Message m1 = cev.getMessage();
                    Message m2 = evt.getMessage();
                    if (m1 == null || m2 == null || !m1.getContent().equals(m2.getContent())) continue;
                    isPresent = true;
                    break;
                }
                if (isPresent) {
                    return;
                }
            }
            this.writeMessage(history, "out", evt.getMessage(), evt.getTimestamp(), false);
        }
        catch (IOException e) {
            logger.error((Object)"Could not add message to history", (Throwable)e);
        }
    }

    public void messageDeliveryFailed(ChatRoomMessageDeliveryFailedEvent evt) {
    }

    private void writeMessage(String direction, Contact source, Contact destination, Message message, Date messageTimestamp, boolean isSmsSubtype) {
        try {
            MetaContact metaContact = MessageHistoryActivator.getContactListService().findMetaContactByContact(destination);
            if (metaContact != null && !this.isHistoryLoggingEnabled(metaContact.getMetaUID())) {
                return;
            }
            History history = this.getHistory(source, destination);
            this.writeMessage(history, direction, message, messageTimestamp, isSmsSubtype);
        }
        catch (IOException e) {
            logger.error((Object)"Could not add message to history", (Throwable)e);
        }
    }

    private void writeMessage(History history, String direction, Message message, Date messageTimestamp, boolean isSmsSubtype) {
        try {
            HistoryWriter historyWriter = history.getWriter();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            historyWriter.addRecord(new String[]{direction, message.getContent(), message.getContentType(), message.getEncoding(), message.getMessageUID(), message.getSubject(), sdf.format(messageTimestamp), isSmsSubtype ? MSG_SUBTYPE_SMS : null}, new Date());
        }
        catch (IOException e) {
            logger.error((Object)"Could not add message to history", (Throwable)e);
        }
    }

    private void writeMessage(History history, String direction, ChatRoomMember from, Message message, Date messageTimestamp) {
        try {
            if (from == null) {
                return;
            }
            HistoryWriter historyWriter = history.getWriter();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            historyWriter.addRecord(new String[]{direction, message.getContent(), message.getContentType(), message.getEncoding(), message.getMessageUID(), from.getContactAddress(), sdf.format(messageTimestamp), null}, new Date());
        }
        catch (IOException e) {
            logger.error((Object)"Could not add message to history", (Throwable)e);
        }
    }

    private void writeMessage(History history, String direction, Contact from, Message message, Date messageTimestamp) {
        try {
            HistoryWriter historyWriter = history.getWriter();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            historyWriter.addRecord(new String[]{direction, message.getContent(), message.getContentType(), message.getEncoding(), message.getMessageUID(), from.getAddress(), sdf.format(messageTimestamp), null}, new Date());
        }
        catch (IOException e) {
            logger.error((Object)"Could not add message to history", (Throwable)e);
        }
    }

    @Override
    public void insertMessage(String direction, Contact source, Contact destination, Message message, Date messageTimestamp, boolean isSmsSubtype) {
        try {
            MetaContact metaContact = MessageHistoryActivator.getContactListService().findMetaContactByContact(destination);
            if (metaContact != null && !this.isHistoryLoggingEnabled(metaContact.getMetaUID())) {
                return;
            }
            History history = this.getHistory(source, destination);
            HistoryWriter historyWriter = history.getWriter();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            historyWriter.insertRecord(new String[]{direction, message.getContent(), message.getContentType(), message.getEncoding(), message.getMessageUID(), message.getSubject(), sdf.format(messageTimestamp), isSmsSubtype ? MSG_SUBTYPE_SMS : null}, messageTimestamp, STRUCTURE_NAMES[6]);
        }
        catch (IOException e) {
            logger.error((Object)"Could not add message to history", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistoryService(HistoryService historyService) throws IllegalArgumentException, IOException {
        Object object = this.syncRoot_HistoryService;
        synchronized (object) {
            this.historyService = historyService;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"New history service registered.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetHistoryService(HistoryService historyService) {
        Object object = this.syncRoot_HistoryService;
        synchronized (object) {
            if (this.historyService == historyService) {
                this.historyService = null;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"History service unregistered.");
                }
            }
        }
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        Object sService = this.bundleContext.getService(serviceEvent.getServiceReference());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received a service event for: " + sService.getClass().getName()));
        }
        if (!(sService instanceof ProtocolProviderService)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Service is a protocol provider.");
        }
        if (serviceEvent.getType() == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Handling registration of a new Protocol Provider.");
            }
            this.handleProviderAdded((ProtocolProviderService)sService);
        } else if (serviceEvent.getType() == 4) {
            this.handleProviderRemoved((ProtocolProviderService)sService);
        }
    }

    private void handleProviderAdded(ProtocolProviderService provider) {
        OperationSetMultiUserChat opSetMultiUChat;
        OperationSetSmsMessaging opSetSMS;
        OperationSetBasicInstantMessaging opSetIm;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding protocol provider " + provider.getProtocolDisplayName()));
        }
        if ((opSetIm = (OperationSetBasicInstantMessaging)provider.getOperationSet(OperationSetBasicInstantMessaging.class)) != null) {
            opSetIm.addMessageListener((MessageListener)this);
            if (this.messageSourceService != null) {
                opSetIm.addMessageListener((MessageListener)this.messageSourceService);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)"Service did not have a im op. set.");
        }
        if ((opSetSMS = (OperationSetSmsMessaging)provider.getOperationSet(OperationSetSmsMessaging.class)) != null) {
            opSetSMS.addMessageListener((MessageListener)this);
            if (this.messageSourceService != null) {
                opSetSMS.addMessageListener((MessageListener)this.messageSourceService);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)"Service did not have a sms op. set.");
        }
        if ((opSetMultiUChat = (OperationSetMultiUserChat)provider.getOperationSet(OperationSetMultiUserChat.class)) != null) {
            for (ChatRoom room : opSetMultiUChat.getCurrentlyJoinedChatRooms()) {
                room.addMessageListener((ChatRoomMessageListener)this);
            }
            opSetMultiUChat.addPresenceListener((LocalUserChatRoomPresenceListener)this);
            if (this.messageSourceService != null) {
                opSetMultiUChat.addPresenceListener((LocalUserChatRoomPresenceListener)this.messageSourceService);
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)"Service did not have a multi im op. set.");
        }
        if (this.messageSourceService != null) {
            OperationSetPresence opSetPresence = (OperationSetPresence)provider.getOperationSet(OperationSetPresence.class);
            if (opSetPresence != null) {
                opSetPresence.addContactPresenceStatusListener((ContactPresenceStatusListener)this.messageSourceService);
                opSetPresence.addProviderPresenceStatusListener((ProviderPresenceStatusListener)this.messageSourceService);
                opSetPresence.addSubscriptionListener((SubscriptionListener)this.messageSourceService);
            }
            this.messageSourceService.handleProviderAdded(provider, false);
            OperationSetContactCapabilities capOpSet = (OperationSetContactCapabilities)provider.getOperationSet(OperationSetContactCapabilities.class);
            if (capOpSet != null) {
                capOpSet.addContactCapabilitiesListener((ContactCapabilitiesListener)this.messageSourceService);
            }
        }
    }

    private void handleProviderRemoved(ProtocolProviderService provider) {
        OperationSetMultiUserChat opSetMultiUChat;
        OperationSetSmsMessaging opSetSMS;
        OperationSetBasicInstantMessaging opSetIm = (OperationSetBasicInstantMessaging)provider.getOperationSet(OperationSetBasicInstantMessaging.class);
        if (opSetIm != null) {
            opSetIm.removeMessageListener((MessageListener)this);
            if (this.messageSourceService != null) {
                opSetIm.removeMessageListener((MessageListener)this.messageSourceService);
            }
        }
        if ((opSetSMS = (OperationSetSmsMessaging)provider.getOperationSet(OperationSetSmsMessaging.class)) != null) {
            opSetSMS.removeMessageListener((MessageListener)this);
            if (this.messageSourceService != null) {
                opSetSMS.removeMessageListener((MessageListener)this.messageSourceService);
            }
        }
        if ((opSetMultiUChat = (OperationSetMultiUserChat)provider.getOperationSet(OperationSetMultiUserChat.class)) != null) {
            for (ChatRoom room : opSetMultiUChat.getCurrentlyJoinedChatRooms()) {
                room.removeMessageListener((ChatRoomMessageListener)this);
            }
            opSetMultiUChat.removePresenceListener((LocalUserChatRoomPresenceListener)this);
            if (this.messageSourceService != null) {
                opSetMultiUChat.removePresenceListener((LocalUserChatRoomPresenceListener)this.messageSourceService);
            }
        }
        if (this.messageSourceService != null) {
            OperationSetPresence opSetPresence = (OperationSetPresence)provider.getOperationSet(OperationSetPresence.class);
            if (opSetPresence != null) {
                opSetPresence.removeContactPresenceStatusListener((ContactPresenceStatusListener)this.messageSourceService);
                opSetPresence.removeProviderPresenceStatusListener((ProviderPresenceStatusListener)this.messageSourceService);
                opSetPresence.removeSubscriptionListener((SubscriptionListener)this.messageSourceService);
            }
            this.messageSourceService.handleProviderRemoved(provider);
            OperationSetContactCapabilities capOpSet = (OperationSetContactCapabilities)provider.getOperationSet(OperationSetContactCapabilities.class);
            if (capOpSet != null) {
                capOpSet.removeContactCapabilitiesListener((ContactCapabilitiesListener)this.messageSourceService);
            }
        }
    }

    public void localUserPresenceChanged(LocalUserChatRoomPresenceChangeEvent evt) {
        if (evt.getEventType() == "LocalUserJoined") {
            if (!evt.getChatRoom().isSystem()) {
                evt.getChatRoom().addMessageListener((ChatRoomMessageListener)this);
                if (this.messageSourceService != null) {
                    evt.getChatRoom().addMessageListener((ChatRoomMessageListener)this.messageSourceService);
                }
            }
        } else {
            evt.getChatRoom().removeMessageListener((ChatRoomMessageListener)this);
            if (this.messageSourceService != null) {
                evt.getChatRoom().removeMessageListener((ChatRoomMessageListener)this.messageSourceService);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSearchProgressListener(MessageHistorySearchProgressListener listener) {
        Hashtable<MessageHistorySearchProgressListener, HistorySearchProgressListener> hashtable = this.progressListeners;
        synchronized (hashtable) {
            SearchProgressWrapper wrapperListener = new SearchProgressWrapper(listener);
            this.progressListeners.put(listener, wrapperListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSearchProgressListener(MessageHistorySearchProgressListener listener) {
        Hashtable<MessageHistorySearchProgressListener, HistorySearchProgressListener> hashtable = this.progressListeners;
        synchronized (hashtable) {
            this.progressListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHistorySearchProgressListeners(HistoryReader reader, int countRecords) {
        Hashtable<MessageHistorySearchProgressListener, HistorySearchProgressListener> hashtable = this.progressListeners;
        synchronized (hashtable) {
            for (SearchProgressWrapper searchProgressWrapper : this.progressListeners.values()) {
                searchProgressWrapper.setCurrentValues(reader, countRecords);
                reader.addSearchProgressListener((HistorySearchProgressListener)searchProgressWrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHistorySearchProgressListeners(HistoryReader reader) {
        Hashtable<MessageHistorySearchProgressListener, HistorySearchProgressListener> hashtable = this.progressListeners;
        synchronized (hashtable) {
            for (SearchProgressWrapper searchProgressWrapper : this.progressListeners.values()) {
                searchProgressWrapper.clear();
                reader.removeSearchProgressListener((HistorySearchProgressListener)searchProgressWrapper);
            }
        }
    }

    @Override
    public Collection<EventObject> findByPeriod(MetaContact contact, Date startDate, Date endDate, String[] keywords, boolean caseSensitive) throws RuntimeException {
        HashSet<EventObject> result = new HashSet<EventObject>();
        Map<Contact, HistoryReader> readers = this.getHistoryReaders(contact);
        int recordsCount = this.countRecords(readers);
        for (Map.Entry<Contact, HistoryReader> readerEntry : readers.entrySet()) {
            Contact item = readerEntry.getKey();
            HistoryReader reader = readerEntry.getValue();
            this.addHistorySearchProgressListeners(reader, recordsCount);
            QueryResultSet recs = reader.findByPeriod(startDate, endDate, keywords, SEARCH_FIELD, caseSensitive);
            while (recs.hasNext()) {
                result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), item));
            }
        }
        this.removeHistorySearchProgressListeners(readers);
        return result;
    }

    @Override
    public Collection<EventObject> findByKeyword(MetaContact contact, String keyword, boolean caseSensitive) throws RuntimeException {
        HashSet<EventObject> result = new HashSet<EventObject>();
        Map<Contact, HistoryReader> readers = this.getHistoryReaders(contact);
        int recordsCount = this.countRecords(readers);
        for (Map.Entry<Contact, HistoryReader> readerEntry : readers.entrySet()) {
            Contact item = readerEntry.getKey();
            HistoryReader reader = readerEntry.getValue();
            this.addHistorySearchProgressListeners(reader, recordsCount);
            QueryResultSet recs = reader.findByKeyword(keyword, SEARCH_FIELD, caseSensitive);
            while (recs.hasNext()) {
                result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), item));
            }
        }
        this.removeHistorySearchProgressListeners(readers);
        return result;
    }

    @Override
    public Collection<EventObject> findByKeywords(MetaContact contact, String[] keywords, boolean caseSensitive) throws RuntimeException {
        HashSet<EventObject> result = new HashSet<EventObject>();
        Map<Contact, HistoryReader> readers = this.getHistoryReaders(contact);
        int recordsCount = this.countRecords(readers);
        for (Map.Entry<Contact, HistoryReader> readerEntry : readers.entrySet()) {
            Contact item = readerEntry.getKey();
            HistoryReader reader = readerEntry.getValue();
            this.addHistorySearchProgressListeners(reader, recordsCount);
            QueryResultSet recs = reader.findByKeywords(keywords, SEARCH_FIELD, caseSensitive);
            while (recs.hasNext()) {
                result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), item));
            }
        }
        this.removeHistorySearchProgressListeners(readers);
        return result;
    }

    private Map<Contact, HistoryReader> getHistoryReaders(MetaContact contact) {
        Hashtable<Contact, HistoryReader> readers = new Hashtable<Contact, HistoryReader>();
        Iterator iter = contact.getContacts();
        while (iter.hasNext()) {
            Contact item = (Contact)iter.next();
            try {
                History history = this.getHistory(null, item);
                readers.put(item, history.getReader());
            }
            catch (IOException e) {
                logger.error((Object)"Could not read history", (Throwable)e);
            }
        }
        return readers;
    }

    public int countRecords(Map<?, HistoryReader> readers) {
        int result = 0;
        for (HistoryReader r : readers.values()) {
            result += r.countRecords();
        }
        return result;
    }

    @Override
    public Collection<EventObject> findByStartDate(ChatRoom room, Date startDate) throws RuntimeException {
        HashSet<EventObject> result = new HashSet<EventObject>();
        try {
            HistoryReader reader = this.getHistoryForMultiChat(room).getReader();
            this.addHistorySearchProgressListeners(reader, 1);
            QueryResultSet recs = reader.findByStartDate(startDate);
            while (recs.hasNext()) {
                result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), room));
            }
            this.removeHistorySearchProgressListeners(reader);
        }
        catch (IOException e) {
            logger.error((Object)"Could not read history", (Throwable)e);
        }
        return result;
    }

    @Override
    public Collection<EventObject> findByEndDate(ChatRoom room, Date endDate) throws RuntimeException {
        HashSet<EventObject> result = new HashSet<EventObject>();
        try {
            HistoryReader reader = this.getHistoryForMultiChat(room).getReader();
            this.addHistorySearchProgressListeners(reader, 1);
            QueryResultSet recs = reader.findByEndDate(endDate);
            while (recs.hasNext()) {
                result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), room));
            }
            this.removeHistorySearchProgressListeners(reader);
        }
        catch (IOException e) {
            logger.error((Object)"Could not read history", (Throwable)e);
        }
        return result;
    }

    @Override
    public Collection<EventObject> findByPeriod(ChatRoom room, Date startDate, Date endDate) throws RuntimeException {
        HashSet<EventObject> result = new HashSet<EventObject>();
        try {
            HistoryReader reader = this.getHistoryForMultiChat(room).getReader();
            this.addHistorySearchProgressListeners(reader, 1);
            QueryResultSet recs = reader.findByPeriod(startDate, endDate);
            while (recs.hasNext()) {
                result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), room));
            }
            this.removeHistorySearchProgressListeners(reader);
        }
        catch (IOException e) {
            logger.error((Object)"Could not read history", (Throwable)e);
        }
        return result;
    }

    @Override
    public Collection<EventObject> findByPeriod(ChatRoom room, Date startDate, Date endDate, String[] keywords) throws RuntimeException {
        return this.findByPeriod(room, startDate, endDate, keywords, false);
    }

    @Override
    public Collection<EventObject> findByPeriod(ChatRoom room, Date startDate, Date endDate, String[] keywords, boolean caseSensitive) throws RuntimeException {
        HashSet<EventObject> result = new HashSet<EventObject>();
        try {
            HistoryReader reader = this.getHistoryForMultiChat(room).getReader();
            this.addHistorySearchProgressListeners(reader, 1);
            QueryResultSet recs = reader.findByPeriod(startDate, endDate, keywords, SEARCH_FIELD, caseSensitive);
            while (recs.hasNext()) {
                result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), room));
            }
            this.removeHistorySearchProgressListeners(reader);
        }
        catch (IOException e) {
            logger.error((Object)"Could not read history", (Throwable)e);
        }
        return result;
    }

    @Override
    public Collection<EventObject> findByKeyword(ChatRoom room, String keyword) throws RuntimeException {
        return this.findByKeyword(room, keyword, false);
    }

    @Override
    public Collection<EventObject> findByKeyword(ChatRoom room, String keyword, boolean caseSensitive) throws RuntimeException {
        HashSet<EventObject> result = new HashSet<EventObject>();
        try {
            HistoryReader reader = this.getHistoryForMultiChat(room).getReader();
            this.addHistorySearchProgressListeners(reader, 1);
            QueryResultSet recs = reader.findByKeyword(keyword, SEARCH_FIELD, caseSensitive);
            while (recs.hasNext()) {
                result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), room));
            }
            this.removeHistorySearchProgressListeners(reader);
        }
        catch (IOException e) {
            logger.error((Object)"Could not read history", (Throwable)e);
        }
        return result;
    }

    @Override
    public Collection<EventObject> findByKeywords(ChatRoom room, String[] keywords) throws RuntimeException {
        return this.findByKeywords(room, keywords, false);
    }

    @Override
    public Collection<EventObject> findByKeywords(ChatRoom room, String[] keywords, boolean caseSensitive) throws RuntimeException {
        HashSet<EventObject> result = new HashSet<EventObject>();
        try {
            HistoryReader reader = this.getHistoryForMultiChat(room).getReader();
            this.addHistorySearchProgressListeners(reader, 1);
            QueryResultSet recs = reader.findByKeywords(keywords, SEARCH_FIELD, caseSensitive);
            while (recs.hasNext()) {
                result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), room));
            }
            this.removeHistorySearchProgressListeners(reader);
        }
        catch (IOException e) {
            logger.error((Object)"Could not read history", (Throwable)e);
        }
        return result;
    }

    @Override
    public Collection<EventObject> findLast(ChatRoom room, int count) throws RuntimeException {
        LinkedList<EventObject> result = new LinkedList<EventObject>();
        try {
            HistoryReader reader = this.getHistoryForMultiChat(room).getReader();
            QueryResultSet recs = reader.findLast(count);
            while (recs.hasNext()) {
                result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), room));
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not read history", (Throwable)e);
        }
        Collections.sort(result, new ChatRoomMessageEventComparator());
        int startIndex = result.size() - count;
        if (startIndex < 0) {
            startIndex = 0;
        }
        return result.subList(startIndex, result.size());
    }

    @Override
    public Collection<EventObject> findFirstMessagesAfter(ChatRoom room, Date date, int count) throws RuntimeException {
        LinkedList<EventObject> result = new LinkedList<EventObject>();
        try {
            HistoryReader reader = this.getHistoryForMultiChat(room).getReader();
            QueryResultSet recs = reader.findFirstRecordsAfter(date, count);
            while (recs.hasNext()) {
                result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), room));
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not read history", (Throwable)e);
        }
        Collections.sort(result, new ChatRoomMessageEventComparator());
        int toIndex = count;
        if (toIndex > result.size()) {
            toIndex = result.size();
        }
        return result.subList(0, toIndex);
    }

    @Override
    public Collection<EventObject> findLastMessagesBefore(ChatRoom room, Date date, int count) throws RuntimeException {
        LinkedList<EventObject> result = new LinkedList<EventObject>();
        try {
            HistoryReader reader = this.getHistoryForMultiChat(room).getReader();
            QueryResultSet recs = reader.findLastRecordsBefore(date, count);
            while (recs.hasNext()) {
                result.add(this.convertHistoryRecordToMessageEvent((HistoryRecord)recs.next(), room));
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not read history", (Throwable)e);
        }
        Collections.sort(result, new ChatRoomMessageEventComparator());
        int startIndex = result.size() - count;
        if (startIndex < 0) {
            startIndex = 0;
        }
        return result.subList(startIndex, result.size());
    }

    private void loadMessageHistoryService() {
        this.configService.addPropertyChangeListener("net.java.sip.communicator.service.msghistory.IS_RECENT_MESSAGES_DISABLED", (PropertyChangeListener)this.msgHistoryPropListener);
        boolean isRecentMessagesDisabled = this.configService.getBoolean("net.java.sip.communicator.service.msghistory.IS_RECENT_MESSAGES_DISABLED", false);
        if (!isRecentMessagesDisabled) {
            this.loadRecentMessages();
        }
        this.bundleContext.addServiceListener((ServiceListener)this);
        for (ProtocolProviderService pps : this.getCurrentlyAvailableProviders()) {
            this.handleProviderAdded(pps);
        }
    }

    List<ProtocolProviderService> getCurrentlyAvailableProviders() {
        ArrayList<ProtocolProviderService> res = new ArrayList<ProtocolProviderService>();
        ServiceReference[] protocolProviderRefs = null;
        try {
            protocolProviderRefs = this.bundleContext.getServiceReferences(ProtocolProviderService.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            logger.error((Object)"Error while retrieving service refs", (Throwable)ex);
            return res;
        }
        if (protocolProviderRefs != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + protocolProviderRefs.length + " already installed providers."));
            }
            for (int i = 0; i < protocolProviderRefs.length; ++i) {
                ProtocolProviderService provider = (ProtocolProviderService)this.bundleContext.getService(protocolProviderRefs[i]);
                res.add(provider);
            }
        }
        return res;
    }

    private void stopMessageHistoryService() {
        this.bundleContext.removeServiceListener((ServiceListener)this);
        ServiceReference[] protocolProviderRefs = null;
        try {
            protocolProviderRefs = this.bundleContext.getServiceReferences(ProtocolProviderService.class.getName(), null);
        }
        catch (InvalidSyntaxException ex) {
            logger.error((Object)"Error while retrieving service refs", (Throwable)ex);
            return;
        }
        if (protocolProviderRefs != null) {
            for (int i = 0; i < protocolProviderRefs.length; ++i) {
                ProtocolProviderService provider = (ProtocolProviderService)this.bundleContext.getService(protocolProviderRefs[i]);
                this.handleProviderRemoved(provider);
            }
        }
    }

    public void messageDelivered(AdHocChatRoomMessageDeliveredEvent evt) {
        if (!this.isHistoryLoggingEnabled(evt.getSourceAdHocChatRoom().getIdentifier())) {
            return;
        }
        try {
            History history = this.getHistoryForAdHocMultiChat(evt.getSourceAdHocChatRoom());
            this.writeMessage(history, "out", evt.getMessage(), evt.getTimestamp(), false);
        }
        catch (IOException e) {
            logger.error((Object)"Could not add message to history", (Throwable)e);
        }
    }

    public void messageDeliveryFailed(AdHocChatRoomMessageDeliveryFailedEvent evt) {
    }

    public void messageReceived(AdHocChatRoomMessageReceivedEvent evt) {
        if (!this.isHistoryLoggingEnabled(evt.getSourceChatRoom().getIdentifier())) {
            return;
        }
        try {
            History history = this.getHistoryForAdHocMultiChat(evt.getSourceChatRoom());
            this.writeMessage(history, "in", evt.getSourceChatRoomParticipant(), evt.getMessage(), evt.getTimestamp());
        }
        catch (IOException e) {
            logger.error((Object)"Could not add message to history", (Throwable)e);
        }
    }

    public void localUserAdHocPresenceChanged(LocalUserAdHocChatRoomPresenceChangeEvent evt) {
        if (evt.getEventType() == "LocalUserJoined") {
            evt.getAdHocChatRoom().addMessageListener((AdHocChatRoomMessageListener)this);
        } else {
            evt.getAdHocChatRoom().removeMessageListener((AdHocChatRoomMessageListener)this);
        }
    }

    @Override
    public void eraseLocallyStoredHistory() throws IOException {
        HistoryID historyId = HistoryID.createFromRawID((String[])new String[]{"messages"});
        this.historyService.purgeLocallyStoredHistory(historyId);
        if (this.messageSourceService != null) {
            this.messageSourceService.eraseLocallyStoredHistory();
        }
    }

    @Override
    public void eraseLocallyStoredHistory(MetaContact contact) throws IOException {
        Iterator iter = contact.getContacts();
        while (iter.hasNext()) {
            Contact item = (Contact)iter.next();
            History history = this.getHistory(null, item);
            this.historyService.purgeLocallyStoredHistory(history.getID());
        }
        if (this.messageSourceService != null) {
            this.messageSourceService.eraseLocallyStoredHistory(contact);
        }
    }

    @Override
    public void eraseLocallyStoredHistory(ChatRoom room) throws IOException {
        History history = this.getHistoryForMultiChat(room);
        this.historyService.purgeLocallyStoredHistory(history.getID());
        if (this.messageSourceService != null) {
            this.messageSourceService.eraseLocallyStoredHistory(room);
        }
    }

    @Override
    public boolean isHistoryLoggingEnabled() {
        return isHistoryLoggingEnabled;
    }

    @Override
    public void setHistoryLoggingEnabled(boolean isEnabled) {
        isHistoryLoggingEnabled = isEnabled;
        this.configService.setProperty("net.java.sip.communicator.service.msghistory.IS_MESSAGE_HISTORY_ENABLED", (Object)Boolean.toString(isHistoryLoggingEnabled));
    }

    @Override
    public boolean isHistoryLoggingEnabled(String id) {
        return this.configService.getBoolean("net.java.sip.communicator.service.msghistory.contact." + id, true);
    }

    @Override
    public void setHistoryLoggingEnabled(boolean isEnabled, String id) {
        if (isEnabled) {
            this.configService.setProperty("net.java.sip.communicator.service.msghistory.contact." + id, null);
        } else {
            this.configService.setProperty("net.java.sip.communicator.service.msghistory.contact." + id, (Object)isEnabled);
        }
    }

    private class MessageHistoryPropertyChangeListener
    implements PropertyChangeListener {
        private MessageHistoryPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("net.java.sip.communicator.service.msghistory.IS_MESSAGE_HISTORY_ENABLED")) {
                String newPropertyValue = (String)evt.getNewValue();
                isHistoryLoggingEnabled = new Boolean(newPropertyValue);
                if (isHistoryLoggingEnabled) {
                    MessageHistoryServiceImpl.this.loadMessageHistoryService();
                } else {
                    MessageHistoryServiceImpl.this.stop(MessageHistoryServiceImpl.this.bundleContext);
                }
            } else if (evt.getPropertyName().equals("net.java.sip.communicator.service.msghistory.IS_RECENT_MESSAGES_DISABLED")) {
                String newPropertyValue = (String)evt.getNewValue();
                boolean isDisabled = new Boolean(newPropertyValue);
                if (isDisabled) {
                    MessageHistoryServiceImpl.this.stopRecentMessages();
                } else if (isHistoryLoggingEnabled) {
                    MessageHistoryServiceImpl.this.loadRecentMessages();
                }
            }
        }
    }

    static class ChatRoomMemberImpl
    implements ChatRoomMember {
        private final ChatRoom chatRoom;
        private final String name;
        private ChatRoomMemberRole role;
        private Contact contact = null;
        private OperationSetPersistentPresence opsetPresence = null;

        public ChatRoomMemberImpl(String name, ChatRoom chatRoom, ChatRoomMemberRole role) {
            this.chatRoom = chatRoom;
            this.name = name;
            this.role = role;
        }

        public ChatRoom getChatRoom() {
            return this.chatRoom;
        }

        public ProtocolProviderService getProtocolProvider() {
            return this.chatRoom.getParentProvider();
        }

        public String getContactAddress() {
            return this.name;
        }

        public String getName() {
            String name = this.name;
            if (this.getContact() != null && this.getContact().getDisplayName() != null) {
                name = this.getContact().getDisplayName();
            }
            return name;
        }

        public ChatRoomMemberRole getRole() {
            return this.role;
        }

        public byte[] getAvatar() {
            return null;
        }

        public void setRole(ChatRoomMemberRole newRole) {
            this.role = newRole;
        }

        public Contact getContact() {
            if (this.contact == null && this.opsetPresence == null) {
                this.opsetPresence = (OperationSetPersistentPresence)this.getProtocolProvider().getOperationSet(OperationSetPersistentPresence.class);
                if (this.opsetPresence != null) {
                    this.contact = this.opsetPresence.findContactByID(this.getContactAddress());
                }
            }
            return this.contact;
        }

        public ConferenceDescription getConferenceDescription() {
            return null;
        }

        public void setConferenceDescription(ConferenceDescription cd) {
        }

        public PresenceStatus getPresenceStatus() {
            return GlobalStatusEnum.ONLINE;
        }
    }

    private static class ChatRoomMessageEventComparator<T>
    implements Comparator<T> {
        private ChatRoomMessageEventComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            Date date2;
            Date date1;
            if (o1 instanceof ChatRoomMessageDeliveredEvent) {
                date1 = ((ChatRoomMessageDeliveredEvent)o1).getTimestamp();
            } else if (o1 instanceof ChatRoomMessageReceivedEvent) {
                date1 = ((ChatRoomMessageReceivedEvent)o1).getTimestamp();
            } else {
                return 0;
            }
            if (o2 instanceof ChatRoomMessageDeliveredEvent) {
                date2 = ((ChatRoomMessageDeliveredEvent)o2).getTimestamp();
            } else if (o2 instanceof ChatRoomMessageReceivedEvent) {
                date2 = ((ChatRoomMessageReceivedEvent)o2).getTimestamp();
            } else {
                return 0;
            }
            return date1.compareTo(date2);
        }
    }

    private static class MessageEventComparator<T>
    implements Comparator<T> {
        private final boolean reverseOrder;

        MessageEventComparator(boolean reverseOrder) {
            this.reverseOrder = reverseOrder;
        }

        MessageEventComparator() {
            this(false);
        }

        @Override
        public int compare(T o1, T o2) {
            Date date2;
            Date date1;
            if (o1 instanceof MessageDeliveredEvent) {
                date1 = ((MessageDeliveredEvent)o1).getTimestamp();
            } else if (o1 instanceof MessageReceivedEvent) {
                date1 = ((MessageReceivedEvent)o1).getTimestamp();
            } else if (o1 instanceof ChatRoomMessageDeliveredEvent) {
                date1 = ((ChatRoomMessageDeliveredEvent)o1).getTimestamp();
            } else if (o1 instanceof ChatRoomMessageReceivedEvent) {
                date1 = ((ChatRoomMessageReceivedEvent)o1).getTimestamp();
            } else {
                return 0;
            }
            if (o2 instanceof MessageDeliveredEvent) {
                date2 = ((MessageDeliveredEvent)o2).getTimestamp();
            } else if (o2 instanceof MessageReceivedEvent) {
                date2 = ((MessageReceivedEvent)o2).getTimestamp();
            } else if (o2 instanceof ChatRoomMessageDeliveredEvent) {
                date2 = ((ChatRoomMessageDeliveredEvent)o2).getTimestamp();
            } else if (o2 instanceof ChatRoomMessageReceivedEvent) {
                date2 = ((ChatRoomMessageReceivedEvent)o2).getTimestamp();
            } else {
                return 0;
            }
            if (this.reverseOrder) {
                return date2.compareTo(date1);
            }
            return date1.compareTo(date2);
        }
    }

    private static class MessageImpl
    extends AbstractMessage {
        private final boolean isOutgoing;
        private final Date messageReceivedDate;
        private String msgSubType;

        MessageImpl(String content, String contentType, String encoding, String subject, String messageUID, boolean isOutgoing, Date messageReceivedDate, String msgSubType) {
            super(content, contentType, encoding, subject, messageUID);
            this.isOutgoing = isOutgoing;
            this.messageReceivedDate = messageReceivedDate;
            this.msgSubType = msgSubType;
        }

        public Date getMessageReceivedDate() {
            return this.messageReceivedDate;
        }

        public String getMsgSubType() {
            return this.msgSubType;
        }
    }

    private class SearchProgressWrapper
    implements HistorySearchProgressListener {
        private MessageHistorySearchProgressListener listener = null;
        double currentReaderProgressRatio = 0.0;
        double accumulatedRatio = 0.0;
        double currentProgress = 0.0;
        double lastHistoryProgress = 0.0;
        int raiser = 1000;

        SearchProgressWrapper(MessageHistorySearchProgressListener listener) {
            this.listener = listener;
        }

        private void setCurrentValues(HistoryReader currentReader, int allRecords) {
            this.currentReaderProgressRatio = (double)currentReader.countRecords() / (double)allRecords * (double)this.raiser;
            this.accumulatedRatio += this.currentReaderProgressRatio;
        }

        public void progressChanged(ProgressEvent evt) {
            int progress = this.getProgressMapping(evt);
            this.currentProgress = progress;
            this.listener.progressChanged(new net.java.sip.communicator.service.msghistory.event.ProgressEvent(MessageHistoryServiceImpl.this, evt, progress / this.raiser));
        }

        private int getProgressMapping(ProgressEvent evt) {
            double tmpHistoryProgress = this.currentReaderProgressRatio * (double)evt.getProgress();
            this.currentProgress += tmpHistoryProgress - this.lastHistoryProgress;
            if (evt.getProgress() == 1000) {
                this.lastHistoryProgress = 0.0;
                if ((int)this.accumulatedRatio == this.raiser) {
                    this.currentProgress = this.raiser * 1000;
                }
            } else {
                this.lastHistoryProgress = tmpHistoryProgress;
            }
            return (int)this.currentProgress;
        }

        void clear() {
            this.currentProgress = 0.0;
            this.lastHistoryProgress = 0.0;
        }
    }
}

