/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPPushDataSource;
import javax.media.rtp.SessionAddress;
import net.sf.fmj.media.rtp.OverallStats;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPPacketParser;
import net.sf.fmj.media.rtp.RTCPPacketParserListener;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import net.sf.fmj.media.rtp.StreamSynch;
import net.sf.fmj.media.rtp.util.BadFormatException;
import net.sf.fmj.media.rtp.util.Packet;
import net.sf.fmj.media.rtp.util.PacketFilter;
import net.sf.fmj.media.rtp.util.RTPPacketReceiver;
import net.sf.fmj.media.rtp.util.UDPPacketReceiver;

public class RTCPRawReceiver
extends PacketFilter
implements RTCPPacketParserListener {
    public DatagramSocket socket;
    private StreamSynch streamSynch;
    private OverallStats stats = null;
    private RTCPPacketParser parser;

    public RTCPRawReceiver() {
    }

    public RTCPRawReceiver(DatagramSocket sock, OverallStats stats, StreamSynch streamSynch) {
        this.setSource(new UDPPacketReceiver(sock, 1000));
        this.stats = stats;
        this.streamSynch = streamSynch;
    }

    public RTCPRawReceiver(int localPort, String localAddress, OverallStats stats, StreamSynch streamSynch) throws UnknownHostException, IOException, SocketException {
        this.streamSynch = streamSynch;
        this.stats = stats;
        UDPPacketReceiver recv = new UDPPacketReceiver(localPort, localAddress, -1, null, 1000, null);
        this.setSource(recv);
        this.socket = recv.getSocket();
    }

    public RTCPRawReceiver(RTPConnector rtpConnector, OverallStats stats, StreamSynch streamSynch) {
        this.streamSynch = streamSynch;
        try {
            this.setSource(new RTPPacketReceiver(rtpConnector.getControlInputStream()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.stats = stats;
    }

    public RTCPRawReceiver(RTPPushDataSource networkdatasource, OverallStats stats, StreamSynch streamSynch) {
        this.streamSynch = streamSynch;
        this.setSource(new RTPPacketReceiver(networkdatasource));
        this.stats = stats;
    }

    public RTCPRawReceiver(SessionAddress localAddress, SessionAddress remoteAddress, OverallStats stats, StreamSynch streamSynch, DatagramSocket controlSocket) throws UnknownHostException, IOException, SocketException {
        this.streamSynch = streamSynch;
        this.stats = stats;
        UDPPacketReceiver recv = new UDPPacketReceiver(localAddress.getControlPort(), localAddress.getControlHostAddress(), remoteAddress.getControlPort(), remoteAddress.getControlHostAddress(), 1000, controlSocket);
        this.setSource(recv);
        this.socket = recv.getSocket();
    }

    @Override
    public void close() {
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.getSource() instanceof RTPPacketReceiver) {
            this.getSource().closeSource();
        }
    }

    @Override
    public String filtername() {
        return "RTCP Raw Receiver";
    }

    @Override
    public Packet handlePacket(Packet p) {
        RTCPPacket result;
        this.stats.update(0, 1);
        this.stats.update(11, 1);
        this.stats.update(1, p.length);
        if (this.parser == null) {
            this.parser = new RTCPPacketParser();
            this.parser.addRTCPPacketParserListener(this);
        }
        try {
            result = this.parser.parse(p);
        }
        catch (BadFormatException e) {
            this.stats.update(13, 1);
            return null;
        }
        return result;
    }

    @Override
    public Packet handlePacket(Packet p, int i) {
        return null;
    }

    @Override
    public Packet handlePacket(Packet p, SessionAddress a) {
        return null;
    }

    public Packet handlePacket(Packet p, SessionAddress a, boolean control) {
        return null;
    }

    @Override
    public void enterSenderReport() {
        this.stats.update(12, 1);
    }

    @Override
    public void malformedSenderReport() {
        this.stats.update(18, 1);
    }

    @Override
    public void malformedReceiverReport() {
        this.stats.update(15, 1);
    }

    @Override
    public void malformedSourceDescription() {
        this.stats.update(16, 1);
    }

    @Override
    public void malformedEndOfParticipation() {
        this.stats.update(17, 1);
    }

    @Override
    public void uknownPayloadType() {
        this.stats.update(14, 1);
    }

    @Override
    public void visitSendeReport(RTCPSRPacket rtcpSRPacket) {
        this.streamSynch.update(rtcpSRPacket.ssrc, rtcpSRPacket.rtptimestamp, rtcpSRPacket.ntptimestampmsw, rtcpSRPacket.ntptimestamplsw);
    }
}

