/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.ldap;

import java.util.HashMap;
import java.util.Map;
import net.java.sip.communicator.impl.ldap.LdapContactSourceService;
import net.java.sip.communicator.impl.ldap.LdapServiceImpl;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.ldap.LdapDirectory;
import net.java.sip.communicator.service.ldap.LdapService;
import net.java.sip.communicator.service.protocol.PhoneNumberI18nService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class LdapActivator
implements BundleActivator {
    private static Logger logger = Logger.getLogger(LdapActivator.class);
    private static BundleContext bundleContext = null;
    private static LdapServiceImpl ldapService = null;
    private static ResourceManagementService resourceService = null;
    private static Map<LdapContactSourceService, ServiceRegistration> cssList = new HashMap<LdapContactSourceService, ServiceRegistration>();
    private static PhoneNumberI18nService phoneNumberI18nService;

    public static LdapService getLdapService() {
        return ldapService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bundleContext) throws Exception {
        LdapActivator.bundleContext = bundleContext;
        try {
            logger.logEntry();
            ldapService = new LdapServiceImpl();
            ldapService.start(bundleContext);
            bundleContext.registerService(LdapService.class.getName(), (Object)ldapService, null);
            logger.trace((Object)"LDAP Service ...[REGISTERED]");
            if (ldapService.getServerSet().size() == 0) {
                return;
            }
            for (LdapDirectory ldapDir : LdapActivator.getLdapService().getServerSet()) {
                if (!ldapDir.getSettings().isEnabled()) continue;
                LdapActivator.registerContactSource(ldapDir);
            }
        }
        finally {
            logger.logExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        if (ldapService != null) {
            ldapService.stop(bundleContext);
        }
        for (Map.Entry<LdapContactSourceService, ServiceRegistration> entry : cssList.entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                entry.getValue().unregister();
            }
            finally {
                entry.getKey().stop();
            }
        }
        cssList.clear();
    }

    public static ResourceManagementService getResourceService() {
        if (resourceService == null) {
            ServiceReference confReference = bundleContext.getServiceReference(ResourceManagementService.class.getName());
            resourceService = (ResourceManagementService)bundleContext.getService(confReference);
        }
        return resourceService;
    }

    public static ContactSourceService registerContactSource(LdapDirectory ldapDir) {
        LdapContactSourceService css = new LdapContactSourceService(ldapDir);
        ServiceRegistration cssServiceRegistration = null;
        try {
            cssServiceRegistration = bundleContext.registerService(ContactSourceService.class.getName(), (Object)css, null);
        }
        finally {
            if (cssServiceRegistration == null) {
                css.stop();
                css = null;
            } else {
                cssList.put(css, cssServiceRegistration);
            }
        }
        return css;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterContactSource(LdapDirectory ldapDir) {
        LdapContactSourceService found = null;
        for (Map.Entry<LdapContactSourceService, ServiceRegistration> entry : cssList.entrySet()) {
            String name;
            String cssName = entry.getKey().getLdapDirectory().getSettings().getName();
            if (!cssName.equals(name = ldapDir.getSettings().getName())) continue;
            try {
                entry.getValue().unregister();
            }
            finally {
                entry.getKey().stop();
            }
            found = entry.getKey();
            break;
        }
        if (found != null) {
            cssList.remove(found);
        }
    }

    public static PhoneNumberI18nService getPhoneNumberI18nService() {
        if (phoneNumberI18nService == null) {
            phoneNumberI18nService = (PhoneNumberI18nService)ServiceUtils.getService((BundleContext)bundleContext, PhoneNumberI18nService.class);
        }
        return phoneNumberI18nService;
    }
}

