/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import net.java.sip.communicator.plugin.desktoputil.SIPCommHTMLEditorKit;
import net.java.sip.communicator.util.Logger;

public class StyledHTMLEditorPane
extends JEditorPane {
    private static final long serialVersionUID = 1L;
    private final Logger logger = Logger.getLogger(StyledHTMLEditorPane.class);
    private final HTMLEditorKit editorKit = new SIPCommHTMLEditorKit(this);
    private final HTMLDocument document = (HTMLDocument)this.editorKit.createDefaultDocument();

    public StyledHTMLEditorPane() {
        this.setContentType("text/html");
        this.setEditorKitForContentType("text/html", this.editorKit);
        this.setEditorKit(this.editorKit);
        this.setDocument(this.document);
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
    }

    public void appendToEnd(String text) {
        Element root = this.document.getDefaultRootElement();
        try {
            this.document.insertAfterEnd(root.getElement(root.getElementCount() - 1), text);
        }
        catch (BadLocationException e) {
            this.logger.error((Object)"Insert in the HTMLDocument failed.", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"Insert in the HTMLDocument failed.", (Throwable)e);
        }
    }

    public void insertAfterStart(String text) {
        Element root = this.document.getDefaultRootElement();
        try {
            this.document.insertBeforeStart(root.getElement(0), text);
        }
        catch (BadLocationException e) {
            this.logger.error((Object)"Insert in the HTMLDocument failed.", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"Insert in the HTMLDocument failed.", (Throwable)e);
        }
    }
}

