/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.UIAction;
import net.java.sip.communicator.service.gui.AuthenticationWindowService;
import net.java.sip.communicator.service.gui.ExportedWindow;
import net.java.sip.communicator.service.protocol.ProtocolIcon;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.OSUtils;

public class AuthenticationWindow
extends SIPCommDialog
implements ActionListener,
AuthenticationWindowService.AuthenticationWindow {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(AuthenticationWindow.class);
    private final JTextArea infoTextArea = new JTextArea();
    private JComponent uinValue;
    private final JPasswordField passwdField = new JPasswordField(15);
    private final JButton loginButton = new JButton(DesktopUtilActivator.getResources().getI18NString("service.gui.OK"));
    private final JButton cancelButton = new JButton(DesktopUtilActivator.getResources().getI18NString("service.gui.CANCEL"));
    private final JCheckBox rememberPassCheckBox = new SIPCommCheckBox(DesktopUtilActivator.getResources().getI18NString("service.gui.REMEMBER_PASSWORD"), DesktopUtilActivator.getConfigurationService().getBoolean("net.java.sip.communicator.util.swing.auth.SAVE_PASSWORD_TICKED", false));
    private static final String PNAME_ALLOW_SAVE_PASSWORD = "net.java.sip.communicator.util.swing.auth.ALLOW_SAVE_PASSWORD";
    private static final String PNAME_SAVE_PASSWORD_TICKED = "net.java.sip.communicator.util.swing.auth.SAVE_PASSWORD_TICKED";
    private String server;
    private String userName;
    private char[] password;
    private boolean isRememberPassword = false;
    private boolean isCanceled = false;
    private final Object lock = new Object();
    private boolean buttonClicked = false;
    private String windowTitle = null;
    private String windowText = null;
    private String usernameLabelText = null;
    private String passwordLabelText = null;
    private String signupLink = null;

    public AuthenticationWindow(String server, boolean isUserNameEditable, ImageIcon icon) {
        this(null, null, server, isUserNameEditable, false, icon, null, null, null, null, null, null);
    }

    AuthenticationWindow(String userName, char[] password, String server, boolean isUserNameEditable, boolean isRememberPassword, ImageIcon icon, String windowTitle, String windowText, String usernameLabelText, String passwordLabelText, String errorMessage, String signupLink) {
        super((Window)(DesktopUtilActivator.getUIService() == null ? null : DesktopUtilActivator.getUIService().getExportedWindow(ExportedWindow.MAIN_WINDOW)), false);
        this.windowTitle = windowTitle;
        this.windowText = windowText;
        this.usernameLabelText = usernameLabelText;
        this.passwordLabelText = passwordLabelText;
        this.isRememberPassword = isRememberPassword;
        this.signupLink = signupLink;
        this.init(userName, password, server, isUserNameEditable, icon, errorMessage);
    }

    private void init(String userName, char[] password, String server, boolean isUserNameEditable, ImageIcon icon, String errorMessage) {
        this.server = server;
        this.initIcon(icon);
        this.uinValue = !isUserNameEditable ? new JLabel() : new JTextField();
        this.init(isUserNameEditable);
        this.setDefaultCloseOperation(2);
        this.enableKeyActions();
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                AuthenticationWindow.this.pack();
                AuthenticationWindow.this.removeWindowListener(this);
            }
        });
        if (OSUtils.IS_MAC) {
            this.getRootPane().putClientProperty("apple.awt.brushMetalLook", Boolean.TRUE);
        }
        if (userName != null) {
            if (this.uinValue instanceof JLabel) {
                ((JLabel)this.uinValue).setText(userName);
            } else if (this.uinValue instanceof JTextField) {
                ((JTextField)this.uinValue).setText(userName);
            }
        }
        if (password != null) {
            this.passwdField.setText(new String(password));
        }
        if (errorMessage != null) {
            this.infoTextArea.setForeground(Color.RED);
            this.infoTextArea.setText(errorMessage);
        }
    }

    public AuthenticationWindow(String userName, char[] password, String server, boolean isUserNameEditable, ImageIcon icon, String errorMessage) {
        this(userName, password, server, isUserNameEditable, false, icon, null, null, null, null, errorMessage, null);
    }

    public AuthenticationWindow(String userName, char[] password, String server, boolean isUserNameEditable, ImageIcon icon, String errorMessage, String signupLink) {
        this(userName, password, server, isUserNameEditable, false, icon, null, null, null, null, errorMessage, signupLink);
    }

    public AuthenticationWindow(String userName, char[] password, String server, boolean isUserNameEditable, ImageIcon icon) {
        this(userName, password, server, isUserNameEditable, icon, null, null);
    }

    public AuthenticationWindow(Dialog owner, String userName, char[] password, String server, boolean isUserNameEditable, ImageIcon icon) {
        super(owner, false);
        this.init(userName, password, server, isUserNameEditable, icon, null);
    }

    public void setAllowSavePassword(boolean allow) {
        this.rememberPassCheckBox.setVisible(allow);
    }

    private void initIcon(ImageIcon icon) {
        if (icon == null) {
            icon = DesktopUtilActivator.getResources().getImage("service.gui.SIP_COMMUNICATOR_LOGO_64x64");
        }
        JLabel iconLabel = new JLabel(icon);
        iconLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        iconLabel.setAlignmentY(0.0f);
        TransparentPanel iconPanel = new TransparentPanel(new BorderLayout());
        ((Container)((Object)iconPanel)).add(iconLabel, "North");
        this.getContentPane().add((Component)((Object)iconPanel), "West");
    }

    private void init(boolean isUserNameEditable) {
        String uinText;
        String title = this.windowTitle != null ? this.windowTitle : DesktopUtilActivator.getResources().getI18NString("service.gui.AUTHENTICATION_WINDOW_TITLE", new String[]{this.server});
        String text = this.windowText != null ? this.windowText : DesktopUtilActivator.getResources().getI18NString("service.gui.AUTHENTICATION_REQUESTED_SERVER", new String[]{this.server});
        boolean showUsernameInDialog = true;
        if (this.usernameLabelText != null) {
            if (this.usernameLabelText.length() == 0 && !isUserNameEditable) {
                showUsernameInDialog = false;
            }
            uinText = this.usernameLabelText;
        } else {
            uinText = DesktopUtilActivator.getResources().getI18NString("service.gui.IDENTIFIER");
        }
        String passText = this.passwordLabelText != null ? this.passwordLabelText : DesktopUtilActivator.getResources().getI18NString("service.gui.PASSWORD");
        this.setTitle(title);
        this.infoTextArea.setEditable(false);
        this.infoTextArea.setOpaque(false);
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setWrapStyleWord(true);
        this.infoTextArea.setFont(this.infoTextArea.getFont().deriveFont(1));
        this.infoTextArea.setText(text);
        this.infoTextArea.setAlignmentX(0.5f);
        JLabel uinLabel = new JLabel(uinText);
        uinLabel.setFont(uinLabel.getFont().deriveFont(1));
        JLabel passwdLabel = new JLabel(passText);
        passwdLabel.setFont(passwdLabel.getFont().deriveFont(1));
        TransparentPanel labelsPanel = new TransparentPanel(new GridLayout(0, 1, 8, 8));
        if (showUsernameInDialog) {
            labelsPanel.add(uinLabel);
        }
        labelsPanel.add(passwdLabel);
        TransparentPanel textFieldsPanel = new TransparentPanel(new GridLayout(0, 1, 8, 8));
        if (showUsernameInDialog) {
            textFieldsPanel.add(this.uinValue);
        }
        textFieldsPanel.add(this.passwdField);
        TransparentPanel southFieldsPanel = new TransparentPanel(new GridLayout(1, 2));
        this.rememberPassCheckBox.setOpaque(false);
        this.rememberPassCheckBox.setBorder(null);
        ((Container)((Object)southFieldsPanel)).add(this.rememberPassCheckBox);
        if (this.signupLink != null && this.signupLink.length() > 0) {
            ((Container)((Object)southFieldsPanel)).add(this.createWebSignupLabel(DesktopUtilActivator.getResources().getI18NString("plugin.simpleaccregwizz.SIGNUP"), this.signupLink));
        } else {
            ((Container)((Object)southFieldsPanel)).add(new JLabel());
        }
        boolean allowRememberPassword = true;
        String allowRemPassStr = DesktopUtilActivator.getResources().getSettingsString(PNAME_ALLOW_SAVE_PASSWORD);
        if (allowRemPassStr != null) {
            allowRememberPassword = Boolean.parseBoolean(allowRemPassStr);
        }
        allowRememberPassword = DesktopUtilActivator.getConfigurationService().getBoolean(PNAME_ALLOW_SAVE_PASSWORD, allowRememberPassword);
        this.setAllowSavePassword(allowRememberPassword);
        TransparentPanel buttonPanel = new TransparentPanel(new FlowLayout(1));
        ((Container)((Object)buttonPanel)).add(this.loginButton);
        ((Container)((Object)buttonPanel)).add(this.cancelButton);
        TransparentPanel southEastPanel = new TransparentPanel(new BorderLayout());
        ((Container)((Object)southEastPanel)).add((Component)((Object)buttonPanel), "East");
        TransparentPanel mainPanel = new TransparentPanel(new BorderLayout(10, 10));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 0, 20, 20));
        TransparentPanel mainFieldsPanel = new TransparentPanel(new BorderLayout(0, 10));
        ((Container)((Object)mainFieldsPanel)).add((Component)((Object)labelsPanel), "West");
        ((Container)((Object)mainFieldsPanel)).add((Component)((Object)textFieldsPanel), "Center");
        ((Container)((Object)mainFieldsPanel)).add((Component)((Object)southFieldsPanel), "South");
        mainPanel.add(this.infoTextArea, "North");
        mainPanel.add((Component)((Object)mainFieldsPanel), "Center");
        mainPanel.add((Component)((Object)southEastPanel), "South");
        this.getContentPane().add((Component)((Object)mainPanel), "East");
        this.loginButton.setName("ok");
        this.cancelButton.setName("cancel");
        if (this.loginButton.getPreferredSize().width > this.cancelButton.getPreferredSize().width) {
            this.cancelButton.setPreferredSize(this.loginButton.getPreferredSize());
        } else {
            this.loginButton.setPreferredSize(this.cancelButton.getPreferredSize());
        }
        this.loginButton.setMnemonic(DesktopUtilActivator.getResources().getI18nMnemonic("service.gui.OK"));
        this.cancelButton.setMnemonic(DesktopUtilActivator.getResources().getI18nMnemonic("service.gui.CANCEL"));
        this.loginButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.loginButton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent evt) {
        JButton button = (JButton)evt.getSource();
        String buttonName = button.getName();
        if ("ok".equals(buttonName)) {
            if (this.uinValue instanceof JLabel) {
                this.userName = ((JLabel)this.uinValue).getText();
            } else if (this.uinValue instanceof JTextField) {
                this.userName = ((JTextField)this.uinValue).getText();
            }
            this.password = this.passwdField.getPassword();
            this.isRememberPassword = this.rememberPassCheckBox.isSelected();
        } else {
            this.isCanceled = true;
        }
        this.buttonClicked = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
        this.dispose();
    }

    private void enableKeyActions() {
        UIAction act = new UIAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuthenticationWindow.this.close(true);
            }
        };
        this.getRootPane().getActionMap().put("close", act);
        InputMap imap = this.getRootPane().getInputMap(1);
        imap.put(KeyStroke.getKeyStroke(27, 0), "close");
    }

    @Override
    protected void close(boolean isEscaped) {
        this.cancelButton.doClick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean isVisible) {
        this.setName("AUTHENTICATION");
        if (this.getOwner() != null) {
            this.setModal(true);
        }
        if (isVisible) {
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    AuthenticationWindow.this.removeWindowFocusListener(this);
                    if (AuthenticationWindow.this.uinValue instanceof JTextField && "".equals(((JTextField)AuthenticationWindow.this.uinValue).getText())) {
                        AuthenticationWindow.this.uinValue.requestFocusInWindow();
                    } else {
                        AuthenticationWindow.this.passwdField.requestFocusInWindow();
                    }
                }
            });
        }
        super.setVisible(isVisible);
        if (isVisible) {
            if (this.getOwner() != null) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                while (!this.buttonClicked) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public String getUserName() {
        return this.userName;
    }

    public char[] getPassword() {
        return this.password;
    }

    public boolean isRememberPassword() {
        return this.isRememberPassword;
    }

    private Component createWebSignupLabel(String linkName, final String linkURL) {
        JLabel subscribeLabel = new JLabel("<html><a href=''>" + linkName + "</a></html>", 4);
        subscribeLabel.setCursor(new Cursor(12));
        subscribeLabel.setToolTipText(DesktopUtilActivator.getResources().getI18NString("plugin.simpleaccregwizz.SPECIAL_SIGNUP"));
        subscribeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                try {
                    DesktopUtilActivator.getBrowserLauncher().openURL(linkURL);
                }
                catch (UnsupportedOperationException ex) {
                    logger.error((Object)"The web sign up is not supported.", (Throwable)ex);
                }
            }
        });
        return subscribeLabel;
    }

    public static ImageIcon getAuthenticationWindowIcon(ProtocolProviderService protocolProvider) {
        Image image = null;
        if (protocolProvider != null) {
            ProtocolIcon protocolIcon = protocolProvider.getProtocolIcon();
            if (protocolIcon.isSizeSupported("IconSize64x64")) {
                image = ImageUtils.getBytesInImage(protocolIcon.getIcon("IconSize64x64"));
            } else if (protocolIcon.isSizeSupported("IconSize48x48")) {
                image = ImageUtils.getBytesInImage(protocolIcon.getIcon("IconSize48x48"));
            }
        }
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }
}

