/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.mock;

import net.java.sip.communicator.impl.protocol.mock.MockCallPeer;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.service.protocol.AbstractCall;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.service.protocol.event.SoundLevelListener;
import net.java.sip.communicator.util.Logger;

public class MockCall
extends AbstractCall<MockCallPeer, MockProvider>
implements CallPeerListener {
    private static final Logger logger = Logger.getLogger(MockCall.class);

    public MockCall(MockProvider sourceProvider) {
        super((ProtocolProviderService)sourceProvider);
    }

    public void addCallPeer(MockCallPeer callPeer) {
        if (!this.doAddCallPeer((CallPeer)callPeer)) {
            return;
        }
        callPeer.addCallPeerListener(this);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Will fire peer added");
        }
        this.fireCallPeerEvent((CallPeer)callPeer, 1);
    }

    public void removeCallPeer(MockCallPeer callPeer) {
        if (!this.doRemoveCallPeer((CallPeer)callPeer)) {
            return;
        }
        callPeer.removeCallPeerListener(this);
        this.fireCallPeerEvent((CallPeer)callPeer, 2);
        if (this.getCallPeerCount() == 0) {
            this.setCallState(CallState.CALL_ENDED);
        }
    }

    public void peerStateChanged(CallPeerChangeEvent evt) {
        CallPeerState newValue = (CallPeerState)evt.getNewValue();
        if (newValue == CallPeerState.DISCONNECTED || newValue == CallPeerState.FAILED) {
            this.removeCallPeer((MockCallPeer)evt.getSourceCallPeer());
        } else if (newValue == CallPeerState.CONNECTED && this.getCallState().equals(CallState.CALL_INITIALIZATION)) {
            this.setCallState(CallState.CALL_IN_PROGRESS);
        }
    }

    public void peerDisplayNameChanged(CallPeerChangeEvent evt) {
    }

    public void peerAddressChanged(CallPeerChangeEvent evt) {
    }

    public void peerImageChanged(CallPeerChangeEvent evt) {
    }

    public void peerTransportAddressChanged(CallPeerChangeEvent evt) {
    }

    public boolean isConferenceFocus() {
        return false;
    }

    public void addLocalUserSoundLevelListener(SoundLevelListener l) {
    }

    public void removeLocalUserSoundLevelListener(SoundLevelListener l) {
    }
}

