/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.sctp4j;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jitsi.sctp4j.SctpSocket;
import org.jitsi.util.JNIUtils;
import org.jitsi.util.Logger;

public class Sctp {
    private static boolean initialized;
    private static final Logger logger;
    public static final int MSG_NOTIFICATION = 8192;
    private static int sctpEngineCount;
    private static final Map<Long, SctpSocket> sockets;

    static void closeSocket(long ptr) {
        Sctp.usrsctp_close(ptr);
        sockets.remove(ptr);
    }

    public static SctpSocket createSocket(int localPort) {
        SctpSocket socket;
        long ptr = Sctp.usrsctp_socket(localPort);
        if (ptr == 0L) {
            socket = null;
        } else {
            socket = new SctpSocket(ptr, localPort);
            sockets.put(ptr, socket);
        }
        return socket;
    }

    public static synchronized void finish() throws IOException {
    }

    public static synchronized void init() {
        if (!initialized) {
            logger.error("Init'ing brian's patched usrsctp");
            Sctp.usrsctp_init(0);
            initialized = true;
        }
    }

    private static native void on_network_in(long var0, byte[] var2, int var3, int var4);

    static void onConnIn(long socketPtr, byte[] packet, int offset, int len) {
        Sctp.on_network_in(socketPtr, packet, offset, len);
    }

    public static void onSctpInboundPacket(long socketAddr, byte[] data, int sid, int ssn, int tsn, long ppid, int context, int flags) {
        SctpSocket socket = sockets.get(socketAddr);
        if (socket == null) {
            logger.error("No SctpSocket found for ptr: " + socketAddr);
        } else {
            socket.onSctpInboundPacket(data, sid, ssn, tsn, ppid, context, flags);
        }
    }

    public static int onSctpOutboundPacket(long socketAddr, byte[] data, int tos, int set_df) {
        int ret;
        SctpSocket socket = sockets.get(socketAddr);
        if (socket == null) {
            ret = -1;
            logger.error("No SctpSocket found for ptr: " + socketAddr);
        } else {
            ret = socket.onSctpOut(data, tos, set_df);
        }
        return ret;
    }

    static native boolean usrsctp_accept(long var0);

    private static native void usrsctp_close(long var0);

    static native boolean usrsctp_connect(long var0, int var2);

    private static native boolean usrsctp_finish();

    private static native boolean usrsctp_init(int var0);

    static native void usrsctp_listen(long var0);

    static native int usrsctp_send(long var0, byte[] var2, int var3, int var4, boolean var5, int var6, int var7);

    private static native long usrsctp_socket(int var0);

    static {
        logger = Logger.getLogger(Sctp.class);
        sockets = new ConcurrentHashMap<Long, SctpSocket>();
        String lib = "jnsctp";
        try {
            JNIUtils.loadLibrary(lib, Sctp.class.getClassLoader());
        }
        catch (Throwable t) {
            logger.error("Failed to load native library " + lib + ": " + t.getMessage());
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }
}

