/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util.parser;

import com.google.gdata.util.parser.Parser;
import java.util.ArrayList;
import java.util.BitSet;

public class Chset
extends Parser<Object>
implements Cloneable {
    protected static final char MIN_CHAR = '\u0000';
    protected static final char MAX_CHAR = '\uffff';
    private static final char MAX_ASCII_CHAR = '\u007f';
    public static final Chset ANYCHAR = new Chset('\u0000', '\uffff');
    public static final Chset NOTHING = new Chset();
    public static final Chset ALNUM = new Chset("a-zA-Z0-9");
    public static final Chset ALPHA = new Chset("a-zA-Z");
    public static final Chset DIGIT = new Chset("0-9");
    public static final Chset XDIGIT = new Chset("0-9a-fA-F");
    public static final Chset LOWER = new Chset("a-z");
    public static final Chset UPPER = new Chset("A-Z");
    public static final Chset WHITESPACE = new Chset(" \t\r\n\f");
    public static final Chset ASCII = new Chset('\u0000', '\u007f');
    private ArrayList<Range> ranges = new ArrayList();
    private BitSet asciiSet = new BitSet(128);

    public Chset() {
    }

    public Chset(char ch) {
        this(ch, ch);
    }

    public Chset(char min, char max) {
        this.ranges.add(new Range(min, max));
        this.refreshAsciiSet();
    }

    public Chset(String spec) {
        int i = 0;
        while (i < spec.length()) {
            char n;
            char s = spec.charAt(i);
            if (i + 1 < spec.length() && (n = spec.charAt(i + 1)) == '-') {
                if (i + 2 < spec.length()) {
                    char e = spec.charAt(i + 2);
                    this.set(new Range(s, e));
                    i += 3;
                    continue;
                }
                this.set(new Range(s, s));
                this.set(new Range(45, 45));
                break;
            }
            this.set(new Range(s, s));
            ++i;
        }
    }

    public Object clone() {
        Chset n = new Chset();
        for (Range r : this.ranges) {
            n.ranges.add(new Range(r.first, r.last));
        }
        n.refreshAsciiSet();
        return n;
    }

    @Override
    public int parse(char[] buf, int start, int end, Object data) {
        if (start < end && this.test(buf[start])) {
            return 1;
        }
        return -1;
    }

    public boolean test(char ch) {
        if (ch <= '\u007f') {
            return this.asciiSet.get(ch);
        }
        return this.testRanges(ch);
    }

    protected boolean testRanges(char ch) {
        int range_size = this.ranges.size();
        if (range_size == 0) {
            return false;
        }
        if (range_size == 1) {
            return this.ranges.get(0).includes(ch);
        }
        int pos = this.find(ch);
        if (pos != range_size && this.ranges.get(pos).includes(ch)) {
            return true;
        }
        return pos != 0 && this.ranges.get(pos - 1).includes(ch);
    }

    protected void set(char min, char max) {
        this.set(new Range(min, max));
    }

    private void set(Range r) {
        if (this.ranges.isEmpty()) {
            this.ranges.add(r);
            this.refreshAsciiSet();
            return;
        }
        int pos = this.find(r.first);
        if (pos != this.ranges.size() && this.ranges.get(pos).includes(r) || pos != 0 && this.ranges.get(pos - 1).includes(r)) {
            return;
        }
        if (pos != 0 && this.ranges.get(pos - 1).mergeable(r)) {
            this.merge(pos - 1, r);
        } else if (pos != this.ranges.size() && this.ranges.get(pos).mergeable(r)) {
            this.merge(pos, r);
        } else {
            this.ranges.add(pos, r);
        }
        this.refreshAsciiSet();
    }

    protected void clear(char min, char max) {
        this.clear(new Range(min, max));
    }

    private void clear(Range r) {
        Range prev;
        if (this.ranges.isEmpty()) {
            return;
        }
        int pos = this.find(r.first);
        if (pos > 0 && (prev = this.ranges.get(pos - 1)).includes(r.first)) {
            if (prev.last > r.last) {
                Range n = new Range(r.last + 1, prev.last);
                prev.last = r.first - 1;
                this.ranges.add(pos, n);
                this.refreshAsciiSet();
                return;
            }
            prev.last = r.first - 1;
        }
        while (pos < this.ranges.size() && r.includes(this.ranges.get(pos))) {
            this.ranges.remove(pos);
        }
        if (pos < this.ranges.size() && this.ranges.get(pos).includes(r.last)) {
            this.ranges.get((int)pos).first = r.last + 1;
        }
        this.refreshAsciiSet();
    }

    private void refreshAsciiSet() {
        this.asciiSet.clear();
        for (char ch = '\u0000'; ch <= '\u007f'; ch = (char)(ch + '\u0001')) {
            if (!this.testRanges(ch)) continue;
            this.asciiSet.set(ch);
        }
    }

    protected int size() {
        return this.ranges.size();
    }

    private int find(int first) {
        int s = 0;
        int e = this.ranges.size() - 1;
        while (s <= e) {
            int m = (s + e) / 2;
            Range r = this.ranges.get(m);
            if (r.first < first) {
                s = m + 1;
                continue;
            }
            if (r.first > first) {
                e = m - 1;
                continue;
            }
            return m;
        }
        return s;
    }

    private void merge(int pos, Range r) {
        Range t = this.ranges.get(pos);
        t.merge(r);
        ++pos;
        while (pos < this.ranges.size() && t.mergeable(this.ranges.get(pos))) {
            t.merge(this.ranges.get(pos));
            this.ranges.remove(pos);
        }
    }

    public static Chset not(Chset subject) {
        return Chset.difference(ANYCHAR, subject);
    }

    public static Chset union(Chset left, Chset right) {
        Chset n = (Chset)left.clone();
        for (Range r : right.ranges) {
            n.set(r);
        }
        return n;
    }

    public static Chset difference(Chset left, Chset right) {
        Chset n = (Chset)left.clone();
        for (Range r : right.ranges) {
            n.clear(r);
        }
        return n;
    }

    public static Chset intersection(Chset left, Chset right) {
        return Chset.difference(left, Chset.not(right));
    }

    public static Chset xor(Chset left, Chset right) {
        return Chset.union(Chset.difference(left, right), Chset.difference(right, left));
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.ranges.size(); ++i) {
            Range r = this.ranges.get(i);
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(r.first);
            buf.append("-");
            buf.append(r.last);
        }
        return buf.toString();
    }

    static class Range {
        int first;
        int last;

        Range(int first, int last) {
            if (first > last) {
                throw new IllegalArgumentException("descending ranges not supported: " + first + "-" + last);
            }
            this.first = first;
            this.last = last;
        }

        boolean includes(int ch) {
            return this.first <= ch && ch <= this.last;
        }

        boolean includes(Range r) {
            return this.first <= r.first && r.last <= this.last;
        }

        boolean mergeable(Range r) {
            return 1 + Math.max(this.last, r.last) - Math.min(this.first, r.first) <= 1 + r.last - r.first + (1 + this.last - this.first);
        }

        void merge(Range r) {
            this.first = Math.min(this.first, r.first);
            this.last = Math.max(this.last, r.last);
        }
    }
}

