/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.atom;

import com.google.gdata.data.ILink;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.QName;
import com.google.gdata.model.ValidationContext;
import com.google.gdata.model.atom.Content;
import com.google.gdata.util.Namespaces;
import java.net.URI;
import java.net.URISyntaxException;

public class Link
extends Element
implements ILink {
    public static final ElementKey<Void, Link> KEY = ElementKey.of(new QName(Namespaces.atomNs, "link"), Link.class);
    public static final AttributeKey<String> HREF = AttributeKey.of(new QName("href"));
    public static final AttributeKey<String> REL = AttributeKey.of(new QName("rel"));
    public static final AttributeKey<String> TYPE = AttributeKey.of(new QName("type"));
    public static final AttributeKey<String> HREFLANG = AttributeKey.of(new QName("hreflang"));
    public static final AttributeKey<String> TITLE = AttributeKey.of(new QName("title"));
    public static final AttributeKey<String> XML_LANG = AttributeKey.of(new QName(Namespaces.xmlNs, "lang"));
    public static final AttributeKey<Long> LENGTH = AttributeKey.of(new QName("length"), Long.class);
    public static final AttributeKey<String> ETAG = AttributeKey.of(new QName(Namespaces.gNs, "etag"));
    protected long length = -1L;

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        ElementCreator builder = registry.build(KEY).setCardinality(ElementMetadata.Cardinality.MULTIPLE);
        builder.addAttribute(REL);
        builder.addAttribute(TYPE);
        builder.addAttribute(HREF).setRequired(true);
        builder.addAttribute(HREFLANG);
        builder.addAttribute(TITLE);
        builder.addAttribute(XML_LANG);
        builder.addAttribute(LENGTH);
        builder.addAttribute(ETAG);
        builder.addElement(Content.KEY);
    }

    public Link() {
        super(KEY);
    }

    protected Link(ElementKey<?, ? extends Link> key) {
        super(key);
    }

    protected Link(ElementKey<?, ? extends Link> key, Element source) {
        super(key, source);
    }

    @Deprecated
    public Link(String rel, String type, String href) {
        this();
        this.setRel(rel);
        this.setType(type);
        this.setHref(href);
    }

    public Link(String rel, String type, URI href) {
        this();
        this.setRel(rel);
        this.setType(type);
        this.setHref(href);
    }

    @Override
    public String getRel() {
        String rel = this.getAttributeValue(REL);
        return rel != null ? rel : "alternate";
    }

    @Override
    public void setRel(String v) {
        this.setAttributeValue(REL, (Object)v);
    }

    @Override
    public String getType() {
        return this.getAttributeValue(TYPE);
    }

    @Override
    public void setType(String v) {
        this.setAttributeValue(TYPE, (Object)v);
    }

    @Override
    public String getHref() {
        return this.getAttributeValue(HREF);
    }

    public URI getHrefUri() {
        String href = this.getHref();
        try {
            return href == null ? null : new URI(href);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void setHref(String v) {
        this.setAttributeValue(HREF, (Object)v);
    }

    public void setHref(URI v) {
        String href = v == null ? null : v.toString();
        this.setHref(href);
    }

    public String getHrefLang() {
        return this.getAttributeValue(HREFLANG);
    }

    public void setHrefLang(String v) {
        this.setAttributeValue(HREFLANG, (Object)v);
    }

    public String getTitle() {
        return this.getAttributeValue(TITLE);
    }

    public void setTitle(String v) {
        this.setAttributeValue(TITLE, (Object)v);
    }

    public String getTitleLang() {
        return this.getAttributeValue(XML_LANG);
    }

    public void setTitleLang(String v) {
        this.setAttributeValue(XML_LANG, (Object)v);
    }

    public long getLength() {
        Long value = this.getAttributeValue(LENGTH);
        if (value == null) {
            return -1L;
        }
        return value;
    }

    public void setLength(long v) {
        this.setAttributeValue(LENGTH, (Object)v);
    }

    public String getEtag() {
        return this.getAttributeValue(ETAG);
    }

    public void setEtag(String v) {
        this.setAttributeValue(ETAG, (Object)v);
    }

    public Content getContent() {
        return this.getElement(Content.KEY);
    }

    public void setContent(Content c) {
        this.setElement(Content.KEY, (Element)c);
    }

    public boolean matches(String relToMatch, String typeToMatch) {
        return !(relToMatch != null && !relToMatch.equals(this.getRel()) || typeToMatch != null && !typeToMatch.equals(this.getType()));
    }

    @Override
    protected Element narrow(ElementMetadata<?, ?> meta, ValidationContext vc) {
        return this.adapt(this, meta, this.getRel());
    }
}

