/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.OscarTools;

public final class LEBinaryTools {
    public static final long UINT_MAX = 0xFFFFFFFFL;
    public static final int USHORT_MAX = 65535;
    public static final short UBYTE_MAX = 255;

    private LEBinaryTools() {
    }

    public static long getUInt(ByteBlock data, int pos) {
        if (data.getLength() - pos < 4) {
            return -1L;
        }
        return ((long)data.get(pos + 3) & 0xFFL) << 24 | ((long)data.get(pos + 2) & 0xFFL) << 16 | ((long)data.get(pos + 1) & 0xFFL) << 8 | (long)data.get(pos) & 0xFFL;
    }

    public static int getUShort(ByteBlock data, int pos) {
        if (data.getLength() - pos < 2) {
            return -1;
        }
        return (data.get(pos + 1) & 0xFF) << 8 | data.get(pos) & 0xFF;
    }

    public static int readUShort(InputStream is) throws IOException {
        if (is.available() < 2) {
            return -1;
        }
        int b1 = is.read();
        int b2 = is.read();
        return (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public static String readUShortLengthString(InputStream is, String charset) throws IOException {
        int length = LEBinaryTools.readUShort(is);
        if (length < 0 || is.available() < length) {
            return null;
        }
        byte[] data = new byte[length - 1];
        is.read(data);
        is.read();
        return new String(data, charset);
    }

    public static String readUShortLengthString(InputStream is) throws IOException {
        return LEBinaryTools.readUShortLengthString(is, OscarTools.getDefaultCharsetName());
    }

    public static short getUByte(ByteBlock data, int pos) {
        if (data.getLength() - pos < 1) {
            return -1;
        }
        return (short)(data.get(pos) & 0xFF);
    }

    public static void writeUInt(OutputStream out, long number) throws IOException {
        out.write(LEBinaryTools.getUInt(number));
    }

    public static void writeUShort(OutputStream out, int number) throws IOException {
        out.write(LEBinaryTools.getUShort(number));
    }

    public static void writeUByte(OutputStream out, int number) throws IOException {
        out.write(LEBinaryTools.getUByte(number));
    }

    public static void writeUShortLengthString(OutputStream out, String value) throws IOException {
        LEBinaryTools.writeUShort(out, value.length() + 1);
        byte[] bytes = BinaryTools.getAsciiBytes(value + '\u0000');
        out.write(bytes);
    }

    public static byte[] getUInt(long number) {
        return new byte[]{(byte)(number & 0xFFL), (byte)(number >> 8 & 0xFFL), (byte)(number >> 16 & 0xFFL), (byte)(number >> 24 & 0xFFL)};
    }

    public static byte[] getUShort(int number) {
        return new byte[]{(byte)(number & 0xFF), (byte)(number >> 8 & 0xFF)};
    }

    public static byte[] getUByte(int number) {
        return new byte[]{(byte)(number & 0xFF)};
    }
}

