/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import net.java.sip.communicator.impl.protocol.icq.IcqActivator;
import net.java.sip.communicator.service.protocol.ProtocolIcon;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.ServiceReference;

public class ProtocolIconAimImpl
implements ProtocolIcon {
    private static Logger logger = Logger.getLogger(ProtocolIconAimImpl.class);
    private static ResourceManagementService resourcesService;
    private static Hashtable<String, byte[]> iconsTable;
    private static Hashtable<String, String> iconPathsTable;

    public Iterator<String> getSupportedSizes() {
        return iconsTable.keySet().iterator();
    }

    public boolean isSizeSupported(String iconSize) {
        return iconsTable.containsKey(iconSize);
    }

    public byte[] getIcon(String iconSize) {
        return iconsTable.get(iconSize);
    }

    public String getIconPath(String iconSize) {
        return iconPathsTable.get(iconSize);
    }

    public byte[] getConnectingIcon() {
        return ProtocolIconAimImpl.getImageInBytes("aimConnectingIcon");
    }

    private static byte[] getImageInBytes(String imageID) {
        InputStream in = ProtocolIconAimImpl.getResources().getImageInputStream(imageID);
        if (in == null) {
            return null;
        }
        byte[] image = null;
        try {
            image = new byte[in.available()];
            in.read(image);
        }
        catch (IOException e) {
            logger.error((Object)("Failed to load image:" + imageID), (Throwable)e);
        }
        return image;
    }

    public static ResourceManagementService getResources() {
        if (resourcesService == null) {
            ServiceReference serviceReference = IcqActivator.bundleContext.getServiceReference(ResourceManagementService.class.getName());
            if (serviceReference == null) {
                return null;
            }
            resourcesService = (ResourceManagementService)IcqActivator.bundleContext.getService(serviceReference);
        }
        return resourcesService;
    }

    static {
        iconsTable = new Hashtable();
        iconsTable.put("IconSize16x16", ProtocolIconAimImpl.getImageInBytes("service.protocol.aim.AIM_16x16"));
        iconsTable.put("IconSize32x32", ProtocolIconAimImpl.getImageInBytes("service.protocol.aim.AIM_32x32"));
        iconsTable.put("IconSize48x48", ProtocolIconAimImpl.getImageInBytes("service.protocol.aim.AIM_48x48"));
        iconsTable.put("IconSize64x64", ProtocolIconAimImpl.getImageInBytes("service.protocol.aim.AIM_64x64"));
        iconPathsTable = new Hashtable();
        iconPathsTable.put("IconSize16x16", ProtocolIconAimImpl.getResources().getImagePath("service.protocol.aim.AIM_16x16"));
        iconPathsTable.put("IconSize32x32", ProtocolIconAimImpl.getResources().getImagePath("service.protocol.aim.AIM_32x32"));
        iconPathsTable.put("IconSize48x48", ProtocolIconAimImpl.getResources().getImagePath("service.protocol.aim.AIM_48x48"));
        iconPathsTable.put("IconSize64x64", ProtocolIconAimImpl.getResources().getImagePath("service.protocol.aim.AIM_64x64"));
    }
}

