/*
 * Decompiled with CFR 0.152.
 */
package nl.dannyvanheumen.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ProxiedSocketChannel
extends SocketChannel {
    private static final Set<SocketOption<?>> SUPPORTED_OPTIONS;
    private static final int TIMEOUT_INFINITE = 0;
    private static final int EOF = -1;
    private final Socket socket;

    public ProxiedSocketChannel(Proxy proxy) throws IOException {
        super(SelectorProvider.provider());
        this.socket = proxy == null ? new Socket(Proxy.NO_PROXY) : new Socket(proxy);
        this.socket.setSoTimeout(0);
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public SocketChannel bind(SocketAddress local) throws IOException {
        this.socket.bind(local);
        return this;
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    @Override
    public <T> T getOption(SocketOption<T> option) throws IOException {
        if (StandardSocketOptions.SO_KEEPALIVE.equals(option)) {
            return (T)StandardSocketOptions.SO_KEEPALIVE.type().cast(this.socket.getKeepAlive());
        }
        if (StandardSocketOptions.SO_RCVBUF.equals(option)) {
            return (T)StandardSocketOptions.SO_RCVBUF.type().cast(this.socket.getReceiveBufferSize());
        }
        if (StandardSocketOptions.SO_SNDBUF.equals(option)) {
            return (T)StandardSocketOptions.SO_SNDBUF.type().cast(this.socket.getSendBufferSize());
        }
        if (StandardSocketOptions.SO_REUSEADDR.equals(option)) {
            return (T)StandardSocketOptions.SO_REUSEADDR.type().cast(this.socket.getReuseAddress());
        }
        if (StandardSocketOptions.TCP_NODELAY.equals(option)) {
            return (T)StandardSocketOptions.TCP_NODELAY.type().cast(this.socket.getTcpNoDelay());
        }
        if (StandardSocketOptions.SO_LINGER.equals(option)) {
            return (T)StandardSocketOptions.SO_LINGER.type().cast(this.socket.getSoLinger());
        }
        throw new IllegalArgumentException("Unsupported option specified.");
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> option, T value) throws IOException {
        if (StandardSocketOptions.SO_KEEPALIVE.equals(option)) {
            Class<Boolean> keepaliveType = StandardSocketOptions.SO_KEEPALIVE.type();
            this.socket.setKeepAlive(keepaliveType.cast(value));
        } else if (StandardSocketOptions.SO_RCVBUF.equals(option)) {
            Class<Integer> rcvbufType = StandardSocketOptions.SO_RCVBUF.type();
            this.socket.setReceiveBufferSize(rcvbufType.cast(value));
        } else if (StandardSocketOptions.SO_SNDBUF.equals(option)) {
            Class<Integer> sndbufType = StandardSocketOptions.SO_SNDBUF.type();
            this.socket.setSendBufferSize(sndbufType.cast(value));
        } else if (StandardSocketOptions.SO_REUSEADDR.equals(option)) {
            Class<Boolean> reuseType = StandardSocketOptions.SO_REUSEADDR.type();
            this.socket.setReuseAddress(reuseType.cast(value));
        } else if (StandardSocketOptions.TCP_NODELAY.equals(option)) {
            Class<Boolean> nodelayType = StandardSocketOptions.TCP_NODELAY.type();
            this.socket.setTcpNoDelay(nodelayType.cast(value));
        } else if (StandardSocketOptions.SO_LINGER.equals(option)) {
            Class<Integer> lingerType = StandardSocketOptions.SO_LINGER.type();
            Integer lingerValue = lingerType.cast(value);
            boolean enabled = lingerValue >= 0;
            this.socket.setSoLinger(enabled, lingerValue);
        }
        throw new IllegalArgumentException("Unsupported option specified.");
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        this.socket.shutdownInput();
        return this;
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
        return this;
    }

    @Override
    public Socket socket() {
        return this.socket;
    }

    @Override
    public boolean isConnected() {
        return this.socket.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return false;
    }

    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        this.socket.connect(remote);
        return true;
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.socket.isConnected();
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.socket.getRemoteSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer dst) throws IOException {
        InputStream input;
        InputStream inputStream = input = this.socket.getInputStream();
        synchronized (inputStream) {
            return this.readBlocking(input, dst);
        }
    }

    private int readBlocking(InputStream input, ByteBuffer dst) throws IOException {
        byte[] buffer = new byte[dst.remaining()];
        int size = input.read(buffer);
        if (size > 0) {
            dst.put(buffer, 0, size);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        InputStream input;
        InputStream inputStream = input = this.socket.getInputStream();
        synchronized (inputStream) {
            return this.readBlocking(input, dsts, offset, length);
        }
    }

    private long readBlocking(InputStream input, ByteBuffer[] dsts, int offset, int length) throws IOException {
        int total = 0;
        for (int i = offset; i < offset + length; ++i) {
            int size = this.readBlocking(input, dsts[i]);
            if (size == -1) {
                if (total != 0) break;
                return -1L;
            }
            total += size;
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer src) throws IOException {
        OutputStream output;
        OutputStream outputStream = output = this.socket.getOutputStream();
        synchronized (outputStream) {
            return this.writeBlocking(output, src);
        }
    }

    private int writeBlocking(OutputStream output, ByteBuffer src) throws IOException {
        byte[] buffer = new byte[src.remaining()];
        src.get(buffer);
        output.write(buffer);
        return buffer.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        OutputStream output;
        OutputStream outputStream = output = this.socket.getOutputStream();
        synchronized (outputStream) {
            return this.writeBlocking(output, srcs, offset, length);
        }
    }

    private long writeBlocking(OutputStream output, ByteBuffer[] srcs, int offset, int length) throws IOException {
        int total = 0;
        for (int i = offset; i < offset + length; ++i) {
            total += this.writeBlocking(output, srcs[i]);
        }
        return total;
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        this.socket.close();
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        if (block) {
            return;
        }
        throw new UnsupportedOperationException("Non-blocking mode is not supported yet.");
    }

    static {
        HashSet<SocketOption<Comparable<Boolean>>> set = new HashSet<SocketOption<Comparable<Boolean>>>();
        set.add(StandardSocketOptions.SO_KEEPALIVE);
        set.add(StandardSocketOptions.SO_RCVBUF);
        set.add(StandardSocketOptions.SO_SNDBUF);
        set.add(StandardSocketOptions.SO_REUSEADDR);
        set.add(StandardSocketOptions.TCP_NODELAY);
        set.add(StandardSocketOptions.SO_LINGER);
        SUPPORTED_OPTIONS = Collections.unmodifiableSet(set);
    }
}

