/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.update;

import java.util.Calendar;
import java.util.Hashtable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.java.sip.communicator.plugin.update.CheckForUpdatesMenuItemComponent;
import net.java.sip.communicator.plugin.update.UpdateServiceImpl;
import net.java.sip.communicator.service.browserlauncher.BrowserLauncherService;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.shutdown.ShutdownService;
import net.java.sip.communicator.service.update.UpdateService;
import net.java.sip.communicator.util.AbstractServiceDependentActivator;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.OSUtils;
import org.osgi.framework.BundleContext;

public class UpdateActivator
extends AbstractServiceDependentActivator {
    private static final Logger logger = Logger.getLogger(UpdateActivator.class);
    private static final String UPDATE_ENABLED = "net.java.sip.communicator.plugin.updatechecker.ENABLED";
    private static final String CHECK_FOR_UPDATES_MENU_DISABLED_PROP = "net.java.sip.communicator.plugin.update.checkforupdatesmenu.DISABLED";
    private static final String CHECK_FOR_UPDATES_DAILY_ENABLED_PROP = "net.java.sip.communicator.plugin.update.checkforupdatesmenu.daily.ENABLED";
    private static final String CHECK_FOR_UPDATES_DAILY_TIME_PROP = "net.java.sip.communicator.plugin.update.checkforupdatesmenu.daily.HOUR";
    private static BrowserLauncherService browserLauncher;
    static BundleContext bundleContext;
    private static ConfigurationService configuration;
    private static UIService uiService;
    private static UpdateService updateService;
    private ScheduledExecutorService mUpdateExecutor = null;

    static BrowserLauncherService getBrowserLauncher() {
        if (browserLauncher == null) {
            browserLauncher = (BrowserLauncherService)ServiceUtils.getService((BundleContext)bundleContext, BrowserLauncherService.class);
        }
        return browserLauncher;
    }

    static ConfigurationService getConfiguration() {
        if (configuration == null) {
            configuration = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configuration;
    }

    static ShutdownService getShutdownService() {
        return (ShutdownService)ServiceUtils.getService((BundleContext)bundleContext, ShutdownService.class);
    }

    static UIService getUIService() {
        if (uiService == null) {
            uiService = (UIService)ServiceUtils.getService((BundleContext)bundleContext, UIService.class);
        }
        return uiService;
    }

    public void start(Object dependentService) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Update checker [STARTED]");
        }
        ConfigurationService cfg = UpdateActivator.getConfiguration();
        if (OSUtils.IS_WINDOWS) {
            updateService = new UpdateServiceImpl();
            bundleContext.registerService(UpdateService.class.getName(), (Object)updateService, null);
            if (!cfg.getBoolean(CHECK_FOR_UPDATES_MENU_DISABLED_PROP, false)) {
                Hashtable<String, String> toolsMenuFilter = new Hashtable<String, String>();
                toolsMenuFilter.put("CONTAINER_ID", Container.CONTAINER_HELP_MENU.getID());
                bundleContext.registerService(PluginComponentFactory.class.getName(), (Object)new PluginComponentFactory(Container.CONTAINER_HELP_MENU){

                    protected PluginComponent getPluginInstance() {
                        return new CheckForUpdatesMenuItemComponent(this.getContainer(), this);
                    }
                }, toolsMenuFilter);
            }
            if (cfg.getBoolean(UPDATE_ENABLED, true)) {
                updateService.checkForUpdates(false);
            }
        }
        if (cfg.getBoolean(CHECK_FOR_UPDATES_DAILY_ENABLED_PROP, false)) {
            logger.info((Object)"Scheduled update checking enabled");
            int hoursToWait = this.calcHoursToWait();
            Runnable updateRunnable = new Runnable(){

                @Override
                public void run() {
                    logger.debug((Object)"Performing scheduled update check");
                    UpdateActivator.getUpdateService().checkForUpdates(false);
                }
            };
            this.mUpdateExecutor = Executors.newSingleThreadScheduledExecutor();
            this.mUpdateExecutor.scheduleAtFixedRate(updateRunnable, hoursToWait, 86400L, TimeUnit.SECONDS);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Update checker [REGISTERED]");
        }
    }

    public Class<?> getDependentServiceClass() {
        return UIService.class;
    }

    public void setBundleContext(BundleContext context) {
        bundleContext = context;
    }

    private int calcHoursToWait() {
        return 24 - Calendar.getInstance().get(11) + configuration.getInt(CHECK_FOR_UPDATES_DAILY_TIME_PROP, 0);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Update checker [STOPPED]");
        }
        if (this.mUpdateExecutor != null) {
            this.mUpdateExecutor.shutdown();
            this.mUpdateExecutor = null;
        }
    }

    static UpdateService getUpdateService() {
        return updateService;
    }
}

