/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osdependent.systemtray.awt;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jitsi.util.OSUtils;

class AWTMouseAdapter
extends MouseAdapter {
    private JPopupMenu popup = null;
    private Window hiddenWindow = null;

    public AWTMouseAdapter(JPopupMenu p) {
        this.popup = p;
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (AWTMouseAdapter.this.hiddenWindow != null) {
                    AWTMouseAdapter.this.hiddenWindow.dispose();
                    AWTMouseAdapter.this.hiddenWindow = null;
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                if (AWTMouseAdapter.this.hiddenWindow != null) {
                    AWTMouseAdapter.this.hiddenWindow.dispose();
                    AWTMouseAdapter.this.hiddenWindow = null;
                }
            }
        });
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.showPopupMenu(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.showPopupMenu(e);
    }

    private void showPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger() && this.popup != null && this.hiddenWindow == null) {
            if (OSUtils.IS_WINDOWS) {
                this.hiddenWindow = new JDialog((Frame)null);
                ((JDialog)this.hiddenWindow).setUndecorated(true);
            } else {
                this.hiddenWindow = new JWindow((Frame)null);
            }
            this.hiddenWindow.setAlwaysOnTop(true);
            Dimension size = this.popup.getPreferredSize();
            Point centerPoint = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            if ((double)e.getY() > centerPoint.getY()) {
                this.hiddenWindow.setLocation(e.getX(), e.getY() - size.height);
            } else {
                this.hiddenWindow.setLocation(e.getX(), e.getY());
            }
            this.hiddenWindow.setVisible(true);
            this.popup.show(((RootPaneContainer)((Object)this.hiddenWindow)).getContentPane(), 0, 0);
            this.hiddenWindow.toFront();
        }
    }
}

