/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.contactinfo;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.java.sip.communicator.plugin.contactinfo.ContactInfoActivator;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleContext;

public class Resources {
    private static Logger log = Logger.getLogger(Resources.class);
    private static ResourceManagementService resourcesService;

    public static String getString(String key) {
        return Resources.getResources().getI18NString(key);
    }

    public static Image getImage(String imageID) {
        BufferedImage image = null;
        InputStream in = Resources.getResources().getImageInputStream(imageID);
        if (in == null) {
            return null;
        }
        try {
            image = ImageIO.read(in);
        }
        catch (IOException e) {
            log.error((Object)("Failed to load image:" + imageID), (Throwable)e);
        }
        return image;
    }

    public static ResourceManagementService getResources() {
        if (resourcesService == null) {
            resourcesService = ResourceManagementServiceUtils.getService((BundleContext)ContactInfoActivator.bundleContext);
        }
        return resourcesService;
    }
}

