/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.skinmanager;

import java.util.Arrays;
import java.util.Dictionary;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.skinmanager.BundleComparator;
import net.java.sip.communicator.plugin.skinmanager.Resources;
import net.java.sip.communicator.plugin.skinmanager.SkinManagerActivator;
import net.java.sip.communicator.plugin.skinmanager.SkinSelectionListener;
import net.java.sip.communicator.plugin.skinmanager.SkinSelectorRenderer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;

public class SkinSelector
extends JComboBox
implements BundleListener {
    private static final long serialVersionUID = 0L;
    public static final String DEFAULT_TEXT = Resources.getString("plugin.skinmanager.DEFAULT_SKIN");
    public static final String DEFAULT_DESCRIPTION_TEXT = Resources.getString("plugin.skinmanager.DEFAULT_SKIN_DESCRIPTION");
    public static final String ADD_TEXT = Resources.getString("plugin.skinmanager.ADD_NEW_SKIN");
    private SkinSelectionListener listener;
    private final Object lock = new Object();
    private final DefaultComboBoxModel dataModel;

    public SkinSelector() {
        this.dataModel = (DefaultComboBoxModel)((JComboBox)this).dataModel;
        SkinManagerActivator.bundleContext.addBundleListener((BundleListener)this);
        this.listener = new SkinSelectionListener();
        this.addActionListener(this.listener);
        this.setRenderer(new SkinSelectorRenderer());
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.listener != null) {
            this.listener.suppressAction(true);
        }
        Object object = this.lock;
        synchronized (object) {
            this.removeAllItems();
            this.addItem(DEFAULT_TEXT);
            this.addSkinBundles();
            this.addItem("separator");
            this.addItem(ADD_TEXT);
        }
        this.selectActiveSkin();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SkinSelector.this.listener != null) {
                    SkinSelector.this.listener.suppressAction(false);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectActiveSkin() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SkinSelector.this.selectActiveSkin();
                }
            });
        }
        if (this.listener != null) {
            this.listener.suppressAction(true);
        }
        Object object = this.lock;
        synchronized (object) {
            boolean found = false;
            for (int i = 0; i < this.dataModel.getSize(); ++i) {
                Bundle b;
                Object o = this.dataModel.getElementAt(i);
                if (!(o instanceof Bundle) || (b = (Bundle)o).getState() != 32 && b.getState() != 8) continue;
                this.setSelectedItem(b);
                found = true;
            }
            if (!found) {
                this.setSelectedIndex(0);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SkinSelector.this.listener != null) {
                    SkinSelector.this.listener.suppressAction(false);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectNoSkin() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SkinSelector.this.selectNoSkin();
                }
            });
        }
        this.setSelectedIndex(0);
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.getModel().getSize(); ++i) {
                Object o = this.getModel().getElementAt(i);
                if (!(o instanceof Bundle)) continue;
                Bundle b = (Bundle)o;
                try {
                    if (b.getState() != 32) continue;
                    b.stop();
                    continue;
                }
                catch (BundleException bundleException) {
                    // empty catch block
                }
            }
        }
    }

    private void addSkinBundles() {
        Bundle[] list = SkinManagerActivator.bundleContext.getBundles();
        Arrays.sort(list, new BundleComparator());
        if (list != null && list.length != 0) {
            for (Bundle b : list) {
                if (!this.isSkin(b)) continue;
                this.addItem(b);
            }
        }
    }

    public void bundleChanged(final BundleEvent be) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Bundle b = be.getBundle();
                int eventType = be.getType();
                if (eventType == 1 && SkinSelector.this.isSkin(b)) {
                    SkinSelector.this.insertItemAt(b, SkinSelector.this.dataModel.getSize() - 2);
                    return;
                }
                if (eventType == 16 && SkinSelector.this.isSkin(b)) {
                    if (SkinSelector.this.getSelectedItem().equals(b)) {
                        SkinSelector.this.selectNoSkin();
                        SkinSelector.this.removeItem(b);
                    }
                    return;
                }
                if (SkinSelector.this.dataModel.getIndexOf(b) < 0) {
                    return;
                }
                if ((eventType == 256 || eventType == 128) && SkinSelector.this.getSelectedItem().equals(b)) {
                    SkinSelector.this.selectNoSkin();
                } else if (eventType == 2 && !SkinSelector.this.getSelectedItem().equals(b)) {
                    SkinSelector.this.selectActiveSkin();
                }
            }
        });
    }

    private boolean isSkin(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        return headers.get("Bundle-Activator") != null && headers.get("Bundle-Activator").toString().equals("net.java.sip.communicator.plugin.skinresourcepack.SkinResourcePack");
    }
}

