/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.history;

public class HistoryID {
    private final String[] id;
    private final String stringRepresentation;
    private final int hashCode;

    private HistoryID(String[] id) {
        this.id = id;
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < id.length; ++i) {
            if (i > 0) {
                buff.append(' ');
            }
            buff.append(this.id[i]);
        }
        this.stringRepresentation = buff.toString();
        this.hashCode = this.stringRepresentation.hashCode();
    }

    public static HistoryID createFromRawID(String[] rawid) {
        String[] id = new String[rawid.length];
        for (int i = 0; i < rawid.length; ++i) {
            id[i] = HistoryID.readableHash(rawid[i]);
        }
        return new HistoryID(id);
    }

    public static HistoryID createFromRawStrings(String[] rawStrings) {
        String[] id = new String[rawStrings.length];
        for (int i = 0; i < rawStrings.length; ++i) {
            id[i] = HistoryID.decodeReadableHash(rawStrings[i]);
        }
        return new HistoryID(id);
    }

    public static HistoryID createFromID(String[] id) throws IllegalArgumentException {
        for (int i = 0; i < id.length; ++i) {
            if (HistoryID.isIDValid(id[i])) continue;
            throw new IllegalArgumentException("Not a valid ID: " + id[i]);
        }
        String[] newID = new String[id.length];
        System.arraycopy(id, 0, newID, 0, id.length);
        return new HistoryID(newID);
    }

    public String[] getID() {
        return this.id;
    }

    public String toString() {
        return this.stringRepresentation;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        String[] id;
        boolean eq = false;
        if (obj instanceof HistoryID && this.id.length == (id = ((HistoryID)obj).id).length) {
            eq = true;
            for (int i = 0; i < id.length; ++i) {
                String s1 = id[i];
                String s2 = this.id[i];
                if (s1 == s2 || s1 != null && s1.equals(s2)) continue;
                eq = false;
                break;
            }
        }
        return eq;
    }

    public static String readableHash(String rawString) {
        StringBuilder encodedString = new StringBuilder(rawString);
        boolean addHash = false;
        for (int i = 0; i < encodedString.length(); ++i) {
            if (!HistoryID.isSpecialChar(encodedString.charAt(i))) continue;
            addHash = true;
            encodedString.setCharAt(i, '_');
        }
        if (addHash) {
            encodedString.append('$');
            encodedString.append(Integer.toHexString(rawString.hashCode()));
        }
        return encodedString.toString();
    }

    public static String decodeReadableHash(String rawString) {
        int replaceCharIx = rawString.indexOf("_");
        int hashCharIx = rawString.indexOf("$");
        if (replaceCharIx > -1 && hashCharIx > -1 && replaceCharIx < hashCharIx) {
            return rawString;
        }
        return rawString;
    }

    private static boolean isIDValid(String id) {
        boolean isValid = true;
        int pos = id.indexOf(36);
        if (pos < 0) {
            isValid = !HistoryID.hasSpecialChar(id);
        } else if (pos + 1 < id.length()) {
            String start = id.substring(0, pos);
            String end = id.substring(pos + 1);
            boolean bl = isValid = !HistoryID.hasSpecialChar(start);
            if (isValid) {
                try {
                    Integer.parseInt(end, 16);
                    isValid = true;
                }
                catch (Exception e) {
                    isValid = false;
                }
            }
        } else {
            isValid = false;
        }
        return isValid;
    }

    private static boolean isSpecialChar(char c) {
        return !(c == '_' || c == '@' || c == '.' || c == '-' || c == '+' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9');
    }

    private static boolean hasSpecialChar(String str) {
        boolean hasSpecialChar = false;
        for (int i = 0; i < str.length(); ++i) {
            if (!HistoryID.isSpecialChar(str.charAt(i))) continue;
            hasSpecialChar = true;
            break;
        }
        return hasSpecialChar;
    }
}

