/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.ssi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joscar.snaccmd.ssi.CreateItemsCmd;
import net.kano.joscar.snaccmd.ssi.ItemsCmd;
import net.kano.joscar.snaccmd.ssi.ModifyItemsCmd;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.DefaultSsiItemObjFactory;
import net.kano.joscar.ssiitem.IconItem;
import net.kano.joscar.ssiitem.SsiItemObj;
import net.kano.joscar.ssiitem.SsiItemObjectFactory;
import net.kano.joustsim.oscar.oscar.service.ssi.MyBuddyIconItemListener;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiItemChangeListener;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiServiceImpl;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyBuddyIconItemManager {
    private static final Logger LOGGER = Logger.getLogger(MyBuddyIconItemManager.class.getName());
    private SsiServiceImpl service;
    private List<IconItem> items = new ArrayList<IconItem>();
    private SsiItemObjectFactory factory = new DefaultSsiItemObjFactory();
    private CopyOnWriteArrayList<MyBuddyIconItemListener> listeners = new CopyOnWriteArrayList();

    public MyBuddyIconItemManager(SsiServiceImpl service) {
        this.service = service;
        service.addItemChangeListener(new SsiItemChangeListener(){

            public void handleItemCreated(SsiItem item) {
                SsiItemObj itemObj;
                if (MyBuddyIconItemManager.isIconItem(item) && (itemObj = MyBuddyIconItemManager.this.factory.getItemObj(item)) instanceof IconItem) {
                    final IconItem iconItem = (IconItem)itemObj;
                    MyBuddyIconItemManager.this.runAndCheckModifications(new Runnable(){

                        public void run() {
                            MyBuddyIconItemManager.this.items.add(iconItem);
                        }
                    });
                }
            }

            public void handleItemModified(SsiItem item) {
                SsiItemObj itemObj;
                if (MyBuddyIconItemManager.isIconItem(item) && (itemObj = MyBuddyIconItemManager.this.factory.getItemObj(item)) instanceof IconItem) {
                    final IconItem iconItem = (IconItem)itemObj;
                    MyBuddyIconItemManager.this.runAndCheckModifications(new Runnable(){

                        public void run() {
                            int id = iconItem.getId();
                            boolean removed = MyBuddyIconItemManager.this.removeItemFromList(id);
                            if (!removed) {
                                LOGGER.warning("MyBuddyIconManager got modification of item " + iconItem + " which wasn't there (icons : " + MyBuddyIconItemManager.this.items + ")");
                            }
                            MyBuddyIconItemManager.this.items.add(iconItem);
                        }
                    });
                }
            }

            public void handleItemDeleted(SsiItem item) {
                if (MyBuddyIconItemManager.isIconItem(item) && !MyBuddyIconItemManager.this.removeItemFromList(item.getId())) {
                    LOGGER.warning("MyBuddyIconManager got removal of item " + item + " which wasn't there (icons : " + MyBuddyIconItemManager.this.items + ")");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAndCheckModifications(Runnable runnable) {
        IconItem newItem;
        IconItem oldItem;
        MyBuddyIconItemManager myBuddyIconItemManager = this;
        synchronized (myBuddyIconItemManager) {
            oldItem = this.getCurrentIconItem();
            runnable.run();
            newItem = this.getCurrentIconItem();
        }
        if (oldItem != newItem) {
            ExtraInfoData oldInfo = oldItem == null ? null : oldItem.getIconInfo();
            ExtraInfoData newInfo = newItem == null ? null : newItem.getIconInfo();
            for (MyBuddyIconItemListener listener : this.listeners) {
                listener.handleMyIconItemChanged(this, oldInfo, newInfo);
            }
        }
    }

    @Nullable
    private synchronized IconItem getCurrentIconItem() {
        for (IconItem iconItem : this.items) {
            if (!iconItem.getName().equals("1")) continue;
            return iconItem;
        }
        return null;
    }

    private synchronized boolean removeItemFromList(int id) {
        boolean good = false;
        Iterator<IconItem> it = this.items.iterator();
        while (it.hasNext()) {
            IconItem otherItem = it.next();
            if (otherItem.getId() != id) continue;
            it.remove();
            good = true;
            break;
        }
        return good;
    }

    private static boolean isIconItem(SsiItem item) {
        return item.getItemType() == 20;
    }

    public void setIcon(@Nullable ExtraInfoData iconInfo) {
        ItemsCmd cmd;
        IconItem currentItem;
        if (iconInfo != null && iconInfo.getData().getLength() != 16) {
            LOGGER.log(Level.WARNING, "Icon hash length should be 16, but it's " + iconInfo.getData().getLength(), new Throwable());
        }
        if ((currentItem = this.getCurrentIconItem()) == null) {
            int nextId = this.service.getUniqueItemId(20, 0);
            cmd = new CreateItemsCmd(new IconItem("1", nextId, iconInfo).toSsiItem());
        } else {
            IconItem newItem = new IconItem(currentItem);
            newItem.setIconInfo(iconInfo);
            cmd = new ModifyItemsCmd(newItem.toSsiItem());
        }
        this.service.sendSsiModification(cmd);
    }

    public CopyOnWriteArrayList<MyBuddyIconItemListener> getListeners() {
        return new CopyOnWriteArrayList<MyBuddyIconItemListener>(this.listeners);
    }
}

