/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.icq;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.slick.protocol.icq.IcqSlickFixture;
import net.java.sip.communicator.util.Logger;

public class TestOperationSetServerStoredInfo
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestOperationSetServerStoredInfo.class);
    private IcqSlickFixture fixture = new IcqSlickFixture();
    private OperationSetServerStoredAccountInfo opSetServerStoredAccountInfo = null;
    private OperationSetServerStoredContactInfo opSetServerStoredContactInfo = null;
    private OperationSetPresence opSetPresence = null;
    private static Object[][] countryIndexToLocaleString = new Object[][]{{new Integer(1), "us"}, {new Integer(101), "ai"}, {new Integer(102), "ag"}, {new Integer(1021), "ag"}, {new Integer(103), "bs"}, {new Integer(104), "bb"}, {new Integer(105), "bm"}, {new Integer(106), "vg"}, {new Integer(107), "ca"}, {new Integer(108), "ky"}, {new Integer(109), "dm"}, {new Integer(110), "do"}, {new Integer(111), "gd"}, {new Integer(112), "jm"}, {new Integer(113), "ms"}, {new Integer(114), "kn"}, {new Integer(1141), "kn"}, {new Integer(115), "kn"}, {new Integer(116), "vc"}, {new Integer(117), "tt"}, {new Integer(118), "tc"}, {new Integer(120), "ag"}, {new Integer(121), "pr"}, {new Integer(122), "lc"}, {new Integer(123), "vi"}, {new Integer(178), "es"}, {new Integer(20), "eg"}, {new Integer(212), "ma"}, {new Integer(213), "dz"}, {new Integer(216), "tn"}, {new Integer(218), "ly"}, {new Integer(220), "gm"}, {new Integer(221), "sn"}, {new Integer(222), "mr"}, {new Integer(223), "ml"}, {new Integer(224), "pg"}, {new Integer(225), "ci"}, {new Integer(226), "bf"}, {new Integer(227), "ne"}, {new Integer(228), "tg"}, {new Integer(229), "bj"}, {new Integer(230), "mu"}, {new Integer(231), "lr"}, {new Integer(232), "sl"}, {new Integer(233), "gh"}, {new Integer(234), "ng"}, {new Integer(235), "td"}, {new Integer(236), "cf"}, {new Integer(237), "cm"}, {new Integer(238), "cv"}, {new Integer(239), "st"}, {new Integer(240), "gq"}, {new Integer(241), "ga"}, {new Integer(242), "cg"}, {new Integer(243), "cd"}, {new Integer(244), "ao"}, {new Integer(245), "gw"}, {new Integer(248), "sc"}, {new Integer(249), "sd"}, {new Integer(250), "rw"}, {new Integer(251), "et"}, {new Integer(252), "so"}, {new Integer(253), "dj"}, {new Integer(254), "ke"}, {new Integer(255), "tz"}, {new Integer(256), "ug"}, {new Integer(257), "bi"}, {new Integer(258), "mz"}, {new Integer(260), "zm"}, {new Integer(261), "mg"}, {new Integer(263), "zw"}, {new Integer(264), "na"}, {new Integer(265), "mw"}, {new Integer(266), "ls"}, {new Integer(267), "bw"}, {new Integer(268), "sz"}, {new Integer(269), "yt"}, {new Integer(2691), "km"}, {new Integer(27), "za"}, {new Integer(290), "sh"}, {new Integer(291), "er"}, {new Integer(297), "aw"}, {new Integer(299), "gl"}, {new Integer(30), "gr"}, {new Integer(31), "nl"}, {new Integer(32), "be"}, {new Integer(33), "fr"}, {new Integer(34), "es"}, {new Integer(350), "gi"}, {new Integer(351), "pt"}, {new Integer(352), "lu"}, {new Integer(353), "ie"}, {new Integer(354), "is"}, {new Integer(355), "al"}, {new Integer(356), "mt"}, {new Integer(357), "cy"}, {new Integer(358), "fi"}, {new Integer(359), "bg"}, {new Integer(36), "hu"}, {new Integer(370), "lt"}, {new Integer(371), "lv"}, {new Integer(372), "ee"}, {new Integer(373), "md"}, {new Integer(374), "am"}, {new Integer(375), "by"}, {new Integer(376), "ad"}, {new Integer(377), "mc"}, {new Integer(378), "sm"}, {new Integer(379), "va"}, {new Integer(380), "ua"}, {new Integer(3811), "cs"}, {new Integer(382), "cs"}, {new Integer(385), "hr"}, {new Integer(386), "si"}, {new Integer(387), "ba"}, {new Integer(389), "mk"}, {new Integer(39), "it"}, {new Integer(40), "ro"}, {new Integer(41), "ch"}, {new Integer(4101), "li"}, {new Integer(42), "cz"}, {new Integer(4201), "sk"}, {new Integer(43), "at"}, {new Integer(44), "gb"}, {new Integer(45), "dk"}, {new Integer(46), "se"}, {new Integer(47), "no"}, {new Integer(48), "pl"}, {new Integer(49), "de"}, {new Integer(501), "bz"}, {new Integer(502), "gt"}, {new Integer(503), "sv"}, {new Integer(504), "hn"}, {new Integer(505), "ni"}, {new Integer(506), "cr"}, {new Integer(507), "pa"}, {new Integer(508), "pm"}, {new Integer(509), "ht"}, {new Integer(51), "pe"}, {new Integer(52), "mx"}, {new Integer(53), "cu"}, {new Integer(54), "ar"}, {new Integer(55), "br"}, {new Integer(56), "cl"}, {new Integer(57), "co"}, {new Integer(58), "ve"}, {new Integer(590), "gp"}, {new Integer(5901), "an"}, {new Integer(5902), "an"}, {new Integer(591), "bo"}, {new Integer(592), "gy"}, {new Integer(593), "ec"}, {new Integer(594), "gy"}, {new Integer(595), "py"}, {new Integer(596), "mq"}, {new Integer(597), "sr"}, {new Integer(598), "uy"}, {new Integer(599), "an"}, {new Integer(60), "my"}, {new Integer(61), "au"}, {new Integer(6101), "cc"}, {new Integer(6102), "cc"}, {new Integer(62), "id"}, {new Integer(63), "ph"}, {new Integer(64), "nz"}, {new Integer(65), "sg"}, {new Integer(66), "th"}, {new Integer(671), "gu"}, {new Integer(672), "cx"}, {new Integer(6722), "nf"}, {new Integer(673), "bn"}, {new Integer(674), "nr"}, {new Integer(675), "pg"}, {new Integer(676), "to"}, {new Integer(677), "sb"}, {new Integer(678), "vu"}, {new Integer(679), "fj"}, {new Integer(680), "pw"}, {new Integer(681), "wf"}, {new Integer(682), "ck"}, {new Integer(683), "nu"}, {new Integer(684), "as"}, {new Integer(685), "ws"}, {new Integer(686), "ki"}, {new Integer(687), "nc"}, {new Integer(688), "tv"}, {new Integer(689), "pf"}, {new Integer(690), "tk"}, {new Integer(691), "fm"}, {new Integer(692), "mh"}, {new Integer(7), "ru"}, {new Integer(705), "kz"}, {new Integer(706), "kg"}, {new Integer(708), "tj"}, {new Integer(709), "tm"}, {new Integer(711), "uz"}, {new Integer(81), "jp"}, {new Integer(82), "kr"}, {new Integer(84), "vn"}, {new Integer(850), "kp"}, {new Integer(852), "hk"}, {new Integer(853), "mo"}, {new Integer(855), "kh"}, {new Integer(856), "la"}, {new Integer(86), "cn"}, {new Integer(880), "bd"}, {new Integer(886), "tw"}, {new Integer(90), "tr"}, {new Integer(91), "in"}, {new Integer(92), "pk"}, {new Integer(93), "af"}, {new Integer(94), "lk"}, {new Integer(95), "mm"}, {new Integer(960), "mv"}, {new Integer(961), "lb"}, {new Integer(962), "jo"}, {new Integer(963), "sy"}, {new Integer(964), "iq"}, {new Integer(965), "kw"}, {new Integer(966), "sa"}, {new Integer(967), "ye"}, {new Integer(968), "om"}, {new Integer(971), "ae"}, {new Integer(972), "il"}, {new Integer(973), "bh"}, {new Integer(974), "qa"}, {new Integer(975), "bt"}, {new Integer(976), "mn"}, {new Integer(977), "np"}, {new Integer(98), "ir"}, {new Integer(994), "az"}, {new Integer(995), "ge"}};
    private static Locale[] spokenLanguages = new Locale[]{null, new Locale("ar"), new Locale("bh"), new Locale("bg"), new Locale("my"), new Locale("zh", "hk"), new Locale("ca"), Locale.CHINA, new Locale("hr"), new Locale("cs"), new Locale("da"), new Locale("nl"), new Locale("en"), new Locale("eo"), new Locale("et"), new Locale("fa"), new Locale("fi"), new Locale("fr"), new Locale("gd"), new Locale("de"), new Locale("el"), new Locale("he"), new Locale("hi"), new Locale("hu"), new Locale("is"), new Locale("id"), new Locale("it"), new Locale("ja"), new Locale("km"), new Locale("ko"), new Locale("lo"), new Locale("lv"), new Locale("lt"), new Locale("ms"), new Locale("no"), new Locale("pl"), new Locale("pt"), new Locale("ro"), new Locale("ru"), new Locale("sr"), new Locale("sk"), new Locale("sl"), new Locale("so"), new Locale("es"), new Locale("sw"), new Locale("sv"), new Locale("tl"), new Locale("tt"), new Locale("th"), new Locale("tr"), new Locale("uk"), new Locale("ur"), new Locale("vi"), new Locale("yi"), new Locale("yo"), new Locale("af"), new Locale("bs"), new Locale("fa"), new Locale("sq"), new Locale("hy"), new Locale("pa"), new Locale("ch"), new Locale("mn"), new Locale("zh"), Locale.TAIWAN, new Locale("mk"), new Locale("sd"), new Locale("cy"), new Locale("az"), new Locale("ku"), new Locale("gu"), new Locale("ta"), new Locale("be"), null};

    public TestOperationSetServerStoredInfo(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
        Map supportedOperationSets = this.fixture.provider.getSupportedOperationSets();
        if (supportedOperationSets == null || supportedOperationSets.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this ICQ implementation. ");
        }
        this.opSetServerStoredAccountInfo = (OperationSetServerStoredAccountInfo)supportedOperationSets.get(OperationSetServerStoredAccountInfo.class.getName());
        this.opSetServerStoredContactInfo = (OperationSetServerStoredContactInfo)supportedOperationSets.get(OperationSetServerStoredContactInfo.class.getName());
        if (this.opSetServerStoredAccountInfo == null) {
            throw new NullPointerException("No implementation for Account Info was found");
        }
        if (this.opSetServerStoredContactInfo == null) {
            throw new NullPointerException("No implementation for Contact Info was found");
        }
        this.opSetPresence = (OperationSetPresence)supportedOperationSets.get(OperationSetPresence.class.getName());
        if (this.opSetPresence == null) {
            throw new NullPointerException("An implementation of the ICQ service must provide an implementation of at least one of the PresenceOperationSets");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.fixture.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(TestOperationSetServerStoredInfo.class);
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadInfo() {
        block23: {
            ServerStoredDetails.SpokenLanguageDetail item;
            ServerStoredDetails.LastNameDetail item2;
            Object lock = new Object();
            int suffix = (int)(Math.random() * 100.0);
            String lastName = "TesterAgent" + String.valueOf(suffix);
            IcqSlickFixture.testerAgent.setUserInfoLastName(lastName);
            Object object = lock;
            synchronized (object) {
                try {
                    lock.wait(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            String phoneNumber = "+3591234" + suffix;
            IcqSlickFixture.testerAgent.setUserInfoPhoneNumber(phoneNumber);
            Object object2 = lock;
            synchronized (object2) {
                try {
                    lock.wait(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int lang1 = 1 + (int)(Math.random() * 72.0);
            int lang2 = 1 + (int)(Math.random() * 72.0);
            int lang3 = 1 + (int)(Math.random() * 72.0);
            IcqSlickFixture.testerAgent.setUserInfoLanguage(lang1, lang2, lang3);
            Object object3 = lock;
            synchronized (object3) {
                try {
                    lock.wait(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            int countryRandom = 0 + (int)(Math.random() * 232.0);
            int countryCode = (Integer)countryIndexToLocaleString[countryRandom][0];
            String countryAbr = (String)countryIndexToLocaleString[countryRandom][1];
            IcqSlickFixture.testerAgent.setUserInfoHomeCountry(countryCode);
            Object object4 = lock;
            synchronized (object4) {
                try {
                    lock.wait(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Contact testerAgentContact = this.opSetPresence.findContactByID(IcqSlickFixture.testerAgent.getIcqUIN());
            Iterator iter = this.opSetServerStoredContactInfo.getDetails(testerAgentContact, ServerStoredDetails.LastNameDetail.class);
            if (iter.hasNext()) {
                item2 = (ServerStoredDetails.LastNameDetail)iter.next();
                TestOperationSetServerStoredInfo.assertEquals((String)"The LastName we set is not set or not read properly", (String)item2.getName(), (String)lastName);
            }
            if ((iter = this.opSetServerStoredContactInfo.getDetails(testerAgentContact, ServerStoredDetails.PhoneNumberDetail.class)).hasNext()) {
                item2 = (ServerStoredDetails.PhoneNumberDetail)iter.next();
                TestOperationSetServerStoredInfo.assertEquals((String)"The PhoneNumber we set is not set or not read properly", (String)item2.getNumber(), (String)phoneNumber);
            }
            iter = this.opSetServerStoredContactInfo.getDetails(testerAgentContact, ServerStoredDetails.SpokenLanguageDetail.class);
            ArrayList<Locale> spokenLanguagesServer = new ArrayList<Locale>();
            while (iter.hasNext()) {
                item = (ServerStoredDetails.SpokenLanguageDetail)iter.next();
                spokenLanguagesServer.add(item.getLocale());
            }
            TestOperationSetServerStoredInfo.assertEquals((String)"spoken languages must be 3 ", (int)3, (int)spokenLanguagesServer.size());
            TestOperationSetServerStoredInfo.assertTrue((String)("Must contain langiage " + spokenLanguages[lang1]), (boolean)spokenLanguagesServer.contains(spokenLanguages[lang1]));
            TestOperationSetServerStoredInfo.assertTrue((String)("Must contain langiage " + spokenLanguages[lang2]), (boolean)spokenLanguagesServer.contains(spokenLanguages[lang2]));
            TestOperationSetServerStoredInfo.assertTrue((String)("Must contain langiage " + spokenLanguages[lang3]), (boolean)spokenLanguagesServer.contains(spokenLanguages[lang3]));
            iter = this.opSetServerStoredContactInfo.getDetails(testerAgentContact, ServerStoredDetails.CountryDetail.class);
            if (!iter.hasNext()) break block23;
            item = (ServerStoredDetails.CountryDetail)iter.next();
            logger.info((Object)("read item value: " + item.getLocale().getDisplayCountry()));
            TestOperationSetServerStoredInfo.assertEquals((String)"The Country we set is not set or not read properly", (Object)item.getLocale(), (Object)new Locale("", countryAbr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteInfo() {
        Object lock = new Object();
        ServerStoredDetails.LastNameDetail lastNameDetail = null;
        ServerStoredDetails.PhoneNumberDetail phoneNumberDetail = null;
        ServerStoredDetails.CountryDetail homeCountryDetail = null;
        Iterator iter = this.opSetServerStoredAccountInfo.getDetails(ServerStoredDetails.LastNameDetail.class);
        if (iter.hasNext()) {
            lastNameDetail = (ServerStoredDetails.LastNameDetail)iter.next();
        }
        if ((iter = this.opSetServerStoredAccountInfo.getDetails(ServerStoredDetails.PhoneNumberDetail.class)).hasNext()) {
            phoneNumberDetail = (ServerStoredDetails.PhoneNumberDetail)iter.next();
        }
        if ((iter = this.opSetServerStoredAccountInfo.getDetails(ServerStoredDetails.CountryDetail.class)).hasNext()) {
            homeCountryDetail = (ServerStoredDetails.CountryDetail)iter.next();
        }
        int suffix = (int)(Math.random() * 100.0);
        String newLastName = "TesterAgent" + String.valueOf(suffix);
        String newPhoneNumber = "+3591234" + suffix;
        int countryRandom = 0 + (int)(Math.random() * 232.0);
        int newCountryCode = (Integer)countryIndexToLocaleString[countryRandom][0];
        String newCountryAbr = (String)countryIndexToLocaleString[countryRandom][1];
        try {
            if (lastNameDetail != null) {
                TestOperationSetServerStoredInfo.assertTrue((String)("Cannot set Detail LastName : " + newLastName), (boolean)this.opSetServerStoredAccountInfo.replaceDetail((ServerStoredDetails.GenericDetail)lastNameDetail, (ServerStoredDetails.GenericDetail)new ServerStoredDetails.LastNameDetail(newLastName)));
            } else {
                this.opSetServerStoredAccountInfo.addDetail((ServerStoredDetails.GenericDetail)new ServerStoredDetails.LastNameDetail(newLastName));
            }
            Object object = lock;
            synchronized (object) {
                try {
                    lock.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (phoneNumberDetail != null) {
                TestOperationSetServerStoredInfo.assertTrue((String)("Cannot set Detail PhoneNumver : " + newPhoneNumber), (boolean)this.opSetServerStoredAccountInfo.replaceDetail((ServerStoredDetails.GenericDetail)phoneNumberDetail, (ServerStoredDetails.GenericDetail)new ServerStoredDetails.PhoneNumberDetail(newPhoneNumber)));
            } else {
                this.opSetServerStoredAccountInfo.addDetail((ServerStoredDetails.GenericDetail)new ServerStoredDetails.PhoneNumberDetail(newPhoneNumber));
            }
            object = lock;
            synchronized (object) {
                try {
                    lock.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (homeCountryDetail != null) {
                TestOperationSetServerStoredInfo.assertTrue((String)("Cannot set Detail Country : " + newCountryAbr), (boolean)this.opSetServerStoredAccountInfo.replaceDetail((ServerStoredDetails.GenericDetail)homeCountryDetail, (ServerStoredDetails.GenericDetail)new ServerStoredDetails.CountryDetail(new Locale("", newCountryAbr))));
            } else {
                this.opSetServerStoredAccountInfo.addDetail((ServerStoredDetails.GenericDetail)new ServerStoredDetails.CountryDetail(new Locale("", newCountryAbr)));
            }
            object = lock;
            synchronized (object) {
                try {
                    lock.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            logger.trace((Object)"Finished Setting values!");
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new RuntimeException("Error setting detail! Max detail instances is reached!", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Error setting detail! Detail max instances reached - cannot be set!", ex);
        }
        catch (OperationFailedException ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new RuntimeException("Error setting detail! Network Failure!", ex);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException("Error setting detail! ", ex);
        }
        logger.trace((Object)"Proceeding to Testing values!");
        Hashtable<String, Object> userInfo = IcqSlickFixture.testerAgent.getUserInfo(this.fixture.ourUserID);
        TestOperationSetServerStoredInfo.assertEquals((String)"The LastName we set is not set or not read properly", (Object)newLastName, (Object)userInfo.get("LastName"));
        TestOperationSetServerStoredInfo.assertEquals((String)"The PhoneNumber we set is not set or not read properly", (Object)newPhoneNumber, (Object)userInfo.get("PhoneNumber"));
        ArrayList languageCodes = (ArrayList)userInfo.get("SpeakingLanguage");
        ArrayList<Locale> languages = new ArrayList<Locale>();
        Iterator languageCodeIter = languageCodes.iterator();
        while (languageCodeIter.hasNext()) {
            languages.add(spokenLanguages[(Integer)languageCodeIter.next()]);
        }
        TestOperationSetServerStoredInfo.assertEquals((String)"The Country we set is not set or not read properly", (Object)new Integer(newCountryCode), (Object)userInfo.get("HomeCountry"));
    }

    public void errorHandling() {
        Iterator iter = this.opSetServerStoredAccountInfo.getDetails(ServerStoredDetails.SpokenLanguageDetail.class);
        ArrayList initialLanguages = new ArrayList();
        while (iter.hasNext()) {
            initialLanguages.add(iter.next());
        }
        TestOperationSetServerStoredInfo.assertEquals((String)"There must be 3 language details!", (int)3, (int)initialLanguages.size());
        try {
            this.opSetServerStoredAccountInfo.addDetail((ServerStoredDetails.GenericDetail)new ServerStoredDetails.SpokenLanguageDetail(null));
            TestOperationSetServerStoredInfo.fail((String)"As there is already reched the max instances of languages. Exception must be thrown");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (OperationFailedException operationFailedException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DummyDetail dummyDetail = new DummyDetail();
        try {
            TestOperationSetServerStoredInfo.assertFalse((String)"This class is not supported!", (boolean)this.opSetServerStoredAccountInfo.isDetailClassSupported(((Object)((Object)dummyDetail)).getClass()));
            this.opSetServerStoredAccountInfo.addDetail((ServerStoredDetails.GenericDetail)dummyDetail);
            TestOperationSetServerStoredInfo.fail((String)"As this class is not supperted. Exception must be thrown");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (OperationFailedException operationFailedException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.opSetServerStoredAccountInfo.replaceDetail((ServerStoredDetails.GenericDetail)new ServerStoredDetails.SpokenLanguageDetail(null), (ServerStoredDetails.GenericDetail)dummyDetail);
            TestOperationSetServerStoredInfo.fail((String)"The parameters are from different classes. Exception must be thrown");
        }
        catch (OperationFailedException operationFailedException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removingItems() {
        Object lock = new Object();
        try {
            Object object;
            Iterator iter = this.opSetServerStoredAccountInfo.getDetails(ServerStoredDetails.SpokenLanguageDetail.class);
            ArrayList initialLanguages = new ArrayList();
            while (iter.hasNext()) {
                initialLanguages.add(iter.next());
            }
            iter = initialLanguages.iterator();
            while (iter.hasNext()) {
                TestOperationSetServerStoredInfo.assertTrue((String)"Error removing language!", (boolean)this.opSetServerStoredAccountInfo.removeDetail((ServerStoredDetails.GenericDetail)iter.next()));
                object = lock;
                synchronized (object) {
                    try {
                        lock.wait(4000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            object = lock;
            synchronized (object) {
                try {
                    lock.wait(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            iter = this.opSetServerStoredAccountInfo.getDetails(ServerStoredDetails.SpokenLanguageDetail.class);
            ArrayList languages = new ArrayList();
            while (iter.hasNext()) {
                languages.add(iter.next());
            }
            logger.trace((Object)("languages " + languages.size()));
            TestOperationSetServerStoredInfo.assertEquals((String)"There must be no language details!", (int)0, (int)languages.size());
        }
        catch (OperationFailedException ex) {
            throw new RuntimeException("Error setting or retreiving detail! Network Failure!", ex);
        }
    }

    private class DummyDetail
    extends ServerStoredDetails.NameDetail {
        DummyDetail() {
            super("TestName", "mayName");
        }
    }
}

