/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.login;

import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.authorization.AuthorizationHandlerImpl;
import net.java.sip.communicator.plugin.desktoputil.MessageDialog;
import net.java.sip.communicator.service.muc.MUCService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.AuthorizationHandler;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.util.account.AccountStatusUtils;
import net.java.sip.communicator.util.account.LoginManager;
import net.java.sip.communicator.util.account.LoginRenderer;

public class LoginRendererSwingImpl
implements LoginRenderer {
    private final MainFrame mainFrame = GuiActivator.getUIService().getMainFrame();

    public void addProtocolProviderUI(ProtocolProviderService protocolProvider) {
        GuiActivator.getUIService().getMainFrame().addProtocolProvider(protocolProvider);
    }

    public void removeProtocolProviderUI(ProtocolProviderService protocolProvider) {
        this.mainFrame.removeProtocolProvider(protocolProvider);
    }

    public void startConnectingUI(ProtocolProviderService protocolProvider) {
        this.mainFrame.getAccountStatusPanel().startConnecting(protocolProvider);
    }

    public void stopConnectingUI(ProtocolProviderService protocolProvider) {
        this.mainFrame.getAccountStatusPanel().stopConnecting(protocolProvider);
    }

    public void protocolProviderConnected(ProtocolProviderService protocolProvider, long date) {
        MUCService mucService;
        OperationSetPresence presence = AccountStatusUtils.getProtocolPresenceOpSet((ProtocolProviderService)protocolProvider);
        OperationSetMultiUserChat multiUserChat = MUCService.getMultiUserChatOpSet((ProtocolProviderService)protocolProvider);
        if (presence != null) {
            presence.setAuthorizationHandler((AuthorizationHandler)new AuthorizationHandlerImpl(this.mainFrame));
        }
        if (multiUserChat != null && (mucService = GuiActivator.getMUCService()) != null) {
            mucService.synchronizeOpSetWithLocalContactList(protocolProvider, multiUserChat);
        }
    }

    public void protocolProviderConnectionFailed(ProtocolProviderService protocolProvider, LoginManager loginManagerCallback) {
        AccountID accountID = protocolProvider.getAccountID();
        String errorMessage = GuiActivator.getResources().getI18NString("service.gui.LOGIN_NETWORK_ERROR", new String[]{accountID.getUserID(), accountID.getService()});
        int result = new MessageDialog(null, GuiActivator.getResources().getI18NString("service.gui.ERROR"), errorMessage, GuiActivator.getResources().getI18NString("service.gui.RETRY"), false).showDialog();
        if (result == 0) {
            loginManagerCallback.login(protocolProvider);
        }
    }

    public SecurityAuthority getSecurityAuthorityImpl(ProtocolProviderService protocolProvider) {
        return GuiActivator.getUIService().getDefaultSecurityAuthority(protocolProvider);
    }

    public boolean containsProtocolProviderUI(ProtocolProviderService protocolProvider) {
        return this.mainFrame.hasProtocolProvider(protocolProvider);
    }
}

