/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.plugin.desktoputil.UIContactDetailImpl;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.gui.UIContactDetailAction;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.util.skin.Skinnable;

public class ChooseUIContactDetailPopupMenu
extends SIPCommPopupMenu
implements Skinnable {
    private static final long serialVersionUID = 0L;
    private final JComponent invoker;

    public ChooseUIContactDetailPopupMenu(JComponent invoker, List<UIContactDetail> contactDetails, UIContactDetailAction action) {
        this.invoker = invoker;
        this.init(GuiActivator.getResources().getI18NString("service.gui.CHOOSE_CONTACT"));
        for (UIContactDetail detail : contactDetails) {
            if (!(detail instanceof UIContactDetailImpl)) continue;
            this.addContactDetailItem((UIContactDetailImpl)detail, action);
        }
    }

    private void init(String infoString) {
        this.setInvoker(this.invoker);
        this.add(this.createInfoLabel(infoString));
        this.addSeparator();
        this.setFocusable(true);
    }

    private void addContactDetailItem(final UIContactDetailImpl contactDetail, final UIContactDetailAction contactDetailAction) {
        ContactMenuItem contactItem = new ContactMenuItem(contactDetail);
        contactItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                contactDetailAction.actionPerformed((UIContactDetail)contactDetail, ChooseUIContactDetailPopupMenu.this.getX(), ChooseUIContactDetailPopupMenu.this.getY());
                ChooseUIContactDetailPopupMenu.this.setVisible(false);
            }
        });
        this.add(contactItem);
    }

    public void showPopupMenu(int x, int y) {
        this.setLocation(x, y);
        this.setVisible(true);
    }

    public void showPopupMenu() {
        Point location = new Point(this.invoker.getX(), this.invoker.getY() + this.invoker.getHeight());
        SwingUtilities.convertPointToScreen(location, this.invoker.getParent());
        this.setLocation(location);
        this.setVisible(true);
    }

    private Component createInfoLabel(String infoString) {
        JMenuItem infoLabel = new JMenuItem();
        infoLabel.setEnabled(false);
        infoLabel.setFocusable(false);
        infoLabel.setText("<html><b>" + infoString + "</b></html>");
        return infoLabel;
    }

    public void loadSkin() {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof Skinnable)) continue;
            Skinnable skinnableComponent = (Skinnable)component;
            skinnableComponent.loadSkin();
        }
    }

    private class ContactMenuItem
    extends JMenuItem
    implements Skinnable {
        private static final long serialVersionUID = 0L;
        private final UIContactDetailImpl contact;

        public ContactMenuItem(UIContactDetailImpl contact) {
            this.contact = contact;
            String itemName = "<html>";
            Iterator labels = contact.getLabels();
            if (labels != null && labels.hasNext()) {
                while (labels.hasNext()) {
                    itemName = itemName + "<b style=\"color: gray\">" + ((String)labels.next()).toLowerCase() + "</b> ";
                }
            }
            itemName = itemName + contact.getAddress() + "</html>";
            this.setText(itemName);
            this.loadSkin();
        }

        public void loadSkin() {
            ImageIcon contactIcon = this.contact.getStatusIcon();
            if (contactIcon == null) {
                PresenceStatus status = this.contact.getPresenceStatus();
                BufferedImage statusIcon = null;
                if (status != null) {
                    statusIcon = Constants.getStatusIcon(status);
                }
                if (statusIcon != null) {
                    contactIcon = ImageLoader.getIndexedProtocolIcon(statusIcon, this.contact.getPreferredProtocolProvider(null));
                }
            }
            if (contactIcon != null) {
                this.setIcon(ImageLoader.getIndexedProtocolIcon(contactIcon.getImage(), this.contact.getPreferredProtocolProvider(null)));
            }
        }
    }
}

