/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chatroomslist;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatWindowManager;
import net.java.sip.communicator.impl.gui.main.chatroomslist.ServerChatRoomsChoiceDialog;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextField;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapperListener;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;

public class ChatRoomTableDialog
extends SIPCommDialog
implements ActionListener {
    private static final String REMOVE_ROOM_ON_FIRST_JOIN_FAILED = "net.java.sip.communicator.impl.gui.main.chatroomslist.REMOVE_ROOM_ON_FIRST_JOIN_FAILED";
    private static final String ENABLE_ROOM_AUTO_JOIN_ON_CREATION = "net.java.sip.communicator.impl.gui.main.chatroomslist.ENABLE_ROOM_AUTO_JOIN_ON_CREATION";
    private static ChatRoomTableDialog chatRoomTableDialog;
    private JComboBox providersCombo;
    private final JButton okButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.JOIN"));
    private final JButton cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
    private final JButton listButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.LIST"));
    private JTextField chatRoomNameField = null;
    private JLabel cmdExpandMoreFields;
    private JPanel moreFieldsPannel = new JPanel(new BorderLayout(5, 5));
    private JTextField nicknameField = new JTextField();
    private SIPCommTextField subject = new SIPCommTextField(DesktopUtilActivator.getResources().getI18NString("service.gui.SUBJECT"));
    private ServerChatRoomsChoiceDialog serverChatRoomsChoiceDialog = null;
    private final ChatRoomProviderWrapperListener chatRoomProviderWrapperListener = new ChatRoomProviderWrapperListener(){

        public void chatRoomProviderWrapperAdded(ChatRoomProviderWrapper provider) {
            ChatRoomTableDialog.this.providersCombo.addItem(provider);
        }

        public void chatRoomProviderWrapperRemoved(ChatRoomProviderWrapper provider) {
            ChatRoomTableDialog.this.providersCombo.removeItem(provider);
        }
    };

    public static void showChatRoomTableDialog() {
        if (chatRoomTableDialog == null) {
            chatRoomTableDialog = new ChatRoomTableDialog(GuiActivator.getUIService().getMainFrame());
            chatRoomTableDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    if (chatRoomTableDialog == e.getWindow()) {
                        chatRoomTableDialog = null;
                    }
                }
            });
        }
        chatRoomTableDialog.setVisible(true);
        chatRoomTableDialog.pack();
    }

    public ChatRoomTableDialog(MainFrame parentWindow) {
        super((Frame)((Object)parentWindow));
        this.setDefaultCloseOperation(2);
        this.setTitle(GuiActivator.getResources().getI18NString("service.gui.MY_CHAT_ROOMS_TITLE"));
        this.init();
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        TransparentPanel northPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        northPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 5, 15));
        TransparentPanel labels = new TransparentPanel((LayoutManager)new GridLayout(2, 2, 5, 5));
        labels.add(new JLabel(GuiActivator.getResources().getI18NString("service.gui.ACCOUNT")));
        labels.add(new JLabel(GuiActivator.getResources().getI18NString("service.gui.ROOM_NAME")));
        TransparentPanel valuesPanel = new TransparentPanel((LayoutManager)new GridLayout(2, 2, 5, 5));
        this.providersCombo = this.createProvidersCombobox();
        this.chatRoomNameField = new JTextField();
        valuesPanel.add(this.providersCombo);
        valuesPanel.add(this.chatRoomNameField);
        northPanel.add((Component)labels, "West");
        northPanel.add((Component)valuesPanel, "Center");
        northPanel.setPreferredSize(new Dimension(600, 80));
        TransparentPanel buttonPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15));
        TransparentPanel eastButtonPanel = new TransparentPanel();
        TransparentPanel westButtonPanel = new TransparentPanel();
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.listButton.addActionListener(this);
        this.okButton.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.JOIN_CHAT_ROOM"));
        this.updateOKButtonEnableState();
        eastButtonPanel.add(this.cancelButton);
        eastButtonPanel.add(this.okButton);
        westButtonPanel.add(this.listButton);
        buttonPanel.add((Component)eastButtonPanel, "East");
        buttonPanel.add((Component)westButtonPanel, "West");
        this.getContentPane().add((Component)northPanel, "North");
        this.getContentPane().add(this.initMoreFields(), "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ChatRoomTableDialog.this.updateOKButtonEnableState();
                if (e.getKeyCode() == 10 && ChatRoomTableDialog.this.okButton.isEnabled()) {
                    ChatRoomTableDialog.this.okButton.doClick();
                }
            }
        };
        this.chatRoomNameField.addKeyListener(keyListener);
        this.nicknameField.addKeyListener(keyListener);
        this.providersCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ChatRoomTableDialog.this.setNickname((ChatRoomProviderWrapper)ChatRoomTableDialog.this.providersCombo.getSelectedItem());
                if (ChatRoomTableDialog.this.serverChatRoomsChoiceDialog != null) {
                    ChatRoomTableDialog.this.serverChatRoomsChoiceDialog.changeProtocolProvider(ChatRoomTableDialog.this.getSelectedProvider());
                }
            }
        });
        GuiActivator.getMUCService().addChatRoomProviderWrapperListener(this.chatRoomProviderWrapperListener);
    }

    private void updateOKButtonEnableState() {
        this.okButton.setEnabled(this.chatRoomNameField.getText() != null && this.chatRoomNameField.getText().trim().length() > 0 && this.nicknameField.getText() != null && this.nicknameField.getText().trim().length() > 0);
    }

    private void setNickname(ChatRoomProviderWrapper provider) {
        if (provider == null) {
            return;
        }
        this.nicknameField.setText(GuiActivator.getGlobalDisplayDetailsService().getDisplayName(provider.getProtocolProvider()));
        this.updateOKButtonEnableState();
    }

    private Component initMoreFields() {
        TransparentPanel morePanel = new TransparentPanel((LayoutManager)new BorderLayout());
        morePanel.setOpaque(false);
        morePanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 5, 15));
        this.moreFieldsPannel.setBorder(BorderFactory.createEmptyBorder(10, 30, 0, 0));
        this.moreFieldsPannel.setOpaque(false);
        this.moreFieldsPannel.setVisible(false);
        TransparentPanel subjectPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        this.subject.setFont(this.getFont().deriveFont(12.0f));
        subjectPanel.add((Component)this.subject, "North");
        this.moreFieldsPannel.add((Component)subjectPanel, "Center");
        TransparentPanel nicknamePanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
        this.setNickname((ChatRoomProviderWrapper)this.providersCombo.getSelectedItem());
        nicknamePanel.add((Component)this.nicknameField, "Center");
        nicknamePanel.add((Component)new JLabel(GuiActivator.getResources().getI18NString("service.gui.NICKNAME")), "West");
        this.moreFieldsPannel.add((Component)nicknamePanel, "North");
        this.cmdExpandMoreFields = new JLabel();
        this.cmdExpandMoreFields.setBorder(new EmptyBorder(0, 5, 0, 0));
        this.cmdExpandMoreFields.setIcon(DesktopUtilActivator.getResources().getImage("service.gui.icons.RIGHT_ARROW_ICON"));
        this.cmdExpandMoreFields.setText(DesktopUtilActivator.getResources().getI18NString("service.gui.MORE_LABEL"));
        this.cmdExpandMoreFields.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChatRoomTableDialog.this.cmdExpandMoreFields.setIcon(GuiActivator.getResources().getImage(ChatRoomTableDialog.this.moreFieldsPannel.isVisible() ? "service.gui.icons.RIGHT_ARROW_ICON" : "service.gui.icons.DOWN_ARROW_ICON"));
                ChatRoomTableDialog.this.moreFieldsPannel.setVisible(!ChatRoomTableDialog.this.moreFieldsPannel.isVisible());
                ChatRoomTableDialog.this.pack();
            }
        });
        morePanel.add((Component)this.cmdExpandMoreFields, "North");
        morePanel.add((Component)this.moreFieldsPannel, "Center");
        return morePanel;
    }

    private JComboBox createProvidersCombobox() {
        Iterator providers = GuiActivator.getMUCService().getChatRoomProviders();
        JComboBox chatRoomProvidersCombobox = new JComboBox();
        while (providers.hasNext()) {
            chatRoomProvidersCombobox.addItem(providers.next());
        }
        chatRoomProvidersCombobox.setRenderer(new ChatRoomProviderRenderer());
        return chatRoomProvidersCombobox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String subject = null;
        JButton sourceButton = (JButton)e.getSource();
        if (sourceButton.equals(this.okButton)) {
            if (this.chatRoomNameField.getText() != null && this.chatRoomNameField.getText().trim().length() > 0 && this.nicknameField.getText() != null && this.nicknameField.getText().trim().length() > 0) {
                final ChatRoomWrapper chatRoomWrapper = GuiActivator.getMUCService().createChatRoom(this.chatRoomNameField.getText().trim(), this.getSelectedProvider().getProtocolProvider(), new ArrayList(), "", false, false, false);
                if (chatRoomWrapper == null) {
                    return;
                }
                if (!chatRoomWrapper.isPersistent()) {
                    chatRoomWrapper.setPersistent(true);
                    ConfigurationUtils.saveChatRoom((ProtocolProviderService)chatRoomWrapper.getParentProvider().getProtocolProvider(), (String)chatRoomWrapper.getChatRoomID(), (String)chatRoomWrapper.getChatRoomID(), (String)chatRoomWrapper.getChatRoomName());
                    if (GuiActivator.getConfigurationService().getBoolean(ENABLE_ROOM_AUTO_JOIN_ON_CREATION, false)) {
                        chatRoomWrapper.setAutoJoin(true);
                    }
                }
                String nickName = this.nicknameField.getText().trim();
                ConfigurationUtils.updateChatRoomProperty((ProtocolProviderService)chatRoomWrapper.getParentProvider().getProtocolProvider(), (String)chatRoomWrapper.getChatRoomID(), (String)"userNickName", (String)nickName);
                subject = this.subject.getText();
                if (nickName == null) {
                    return;
                }
                if (GuiActivator.getConfigurationService().getBoolean(REMOVE_ROOM_ON_FIRST_JOIN_FAILED, false)) {
                    chatRoomWrapper.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            if (evt.getPropertyName().equals("Success")) {
                                return;
                            }
                            GuiActivator.getUIService().closeChatRoomWindow(chatRoomWrapper);
                            GuiActivator.getMUCService().removeChatRoom(chatRoomWrapper);
                        }
                    });
                }
                GuiActivator.getMUCService().joinChatRoom(chatRoomWrapper, nickName, null, subject);
                ChatWindowManager chatWindowManager = GuiActivator.getUIService().getChatWindowManager();
                ChatPanel chatPanel = chatWindowManager.getMultiChat(chatRoomWrapper, true);
                chatWindowManager.openChat(chatPanel, true);
            }
            this.dispose();
        } else if (sourceButton.equals(this.cancelButton)) {
            this.dispose();
        } else if (sourceButton.equals(this.listButton)) {
            if (this.serverChatRoomsChoiceDialog == null) {
                this.serverChatRoomsChoiceDialog = new ServerChatRoomsChoiceDialog(this.getTitle(), this.getSelectedProvider());
            }
            this.serverChatRoomsChoiceDialog.setVisible(true);
        }
    }

    protected void close(boolean isEscaped) {
        this.dispose();
    }

    public void dispose() {
        if (chatRoomTableDialog == this) {
            chatRoomTableDialog = null;
        }
        GuiActivator.getMUCService().removeChatRoomProviderWrapperListener(this.chatRoomProviderWrapperListener);
        if (this.serverChatRoomsChoiceDialog != null) {
            this.serverChatRoomsChoiceDialog.dispose();
            this.serverChatRoomsChoiceDialog = null;
        }
        super.dispose();
    }

    public ChatRoomProviderWrapper getSelectedProvider() {
        return (ChatRoomProviderWrapper)this.providersCombo.getSelectedItem();
    }

    public void setChatRoomNameField(String chatRoom) {
        this.chatRoomNameField.setText(chatRoom);
        this.updateOKButtonEnableState();
    }

    public static void setChatRoomField(String chatRoom) {
        if (chatRoomTableDialog != null) {
            chatRoomTableDialog.setChatRoomNameField(chatRoom);
        }
    }

    class ChatRoomProviderRenderer
    extends JLabel
    implements ListCellRenderer {
        public ChatRoomProviderRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ChatRoomProviderWrapper provider = (ChatRoomProviderWrapper)value;
            if (provider == null) {
                return this;
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(provider.getProtocolProvider().getAccountID().getDisplayName());
            this.setIcon(new ImageIcon(provider.getProtocolProvider().getProtocolIcon().getIcon("IconSize16x16")));
            return this;
        }
    }
}

