/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.menus;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatContainer;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.util.skin.Skinnable;

public class WritePanelRightButtonMenu
extends SIPCommPopupMenu
implements ActionListener,
Skinnable {
    private ChatContainer chatContainer;
    private JMenuItem cutMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.CUT"), new ImageIcon(ImageLoader.getImage(ImageLoader.CUT_ICON)));
    private JMenuItem copyMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.COPY"), new ImageIcon(ImageLoader.getImage(ImageLoader.COPY_ICON)));
    private JMenuItem pasteMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.PASTE"), new ImageIcon(ImageLoader.getImage(ImageLoader.PASTE_ICON)));
    private JMenuItem closeMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.CLOSE"), new ImageIcon(ImageLoader.getImage(ImageLoader.CLOSE_ICON)));

    public WritePanelRightButtonMenu(ChatContainer chatContainer) {
        this.chatContainer = chatContainer;
        this.init();
    }

    private void init() {
        this.add(this.copyMenuItem);
        this.add(this.cutMenuItem);
        this.add(this.pasteMenuItem);
        this.addSeparator();
        this.add(this.closeMenuItem);
        this.copyMenuItem.setName("copy");
        this.cutMenuItem.setName("cut");
        this.pasteMenuItem.setName("paste");
        this.closeMenuItem.setName("service.gui.CLOSE");
        this.copyMenuItem.addActionListener(this);
        this.cutMenuItem.addActionListener(this);
        this.pasteMenuItem.addActionListener(this);
        this.closeMenuItem.addActionListener(this);
        this.copyMenuItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.COPY"));
        this.cutMenuItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CUT"));
        this.pasteMenuItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.PASTE"));
        this.closeMenuItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.CLOSE"));
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem menuItem = (JMenuItem)e.getSource();
        String itemText = menuItem.getName();
        if (itemText.equalsIgnoreCase("cut")) {
            this.chatContainer.getCurrentChat().cut();
        } else if (itemText.equalsIgnoreCase("copy")) {
            this.chatContainer.getCurrentChat().copyWriteArea();
        } else if (itemText.equalsIgnoreCase("paste")) {
            this.chatContainer.getCurrentChat().paste();
        } else if (itemText.equalsIgnoreCase("service.gui.CLOSE")) {
            this.chatContainer.getFrame().setVisible(false);
            this.chatContainer.getFrame().dispose();
        }
    }

    public void loadSkin() {
        this.cutMenuItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.CUT_ICON)));
        this.copyMenuItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.COPY_ICON)));
        this.pasteMenuItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.PASTE_ICON)));
        this.closeMenuItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.CLOSE_ICON)));
    }

    public JPopupMenu makeMenu(List<JMenuItem> entries) {
        JPopupMenu rightMenu = new JPopupMenu();
        for (JMenuItem entry : entries) {
            rightMenu.add(entry);
        }
        if (!entries.isEmpty()) {
            rightMenu.addSeparator();
        }
        rightMenu.add(this.copyMenuItem);
        rightMenu.add(this.cutMenuItem);
        rightMenu.add(this.pasteMenuItem);
        rightMenu.addSeparator();
        rightMenu.add(this.closeMenuItem);
        return rightMenu;
    }

    public void dispose() {
        this.chatContainer = null;
        this.cutMenuItem = null;
        this.copyMenuItem = null;
        this.pasteMenuItem = null;
        this.closeMenuItem = null;
    }
}

