/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JComponent;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.CallToolBarButton;
import net.java.sip.communicator.impl.gui.main.call.TransferActiveCallsMenu;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationSetAdvancedTelephony;

public class TransferCallButton
extends CallToolBarButton {
    private final Call call;

    public TransferCallButton(Call c) {
        super(ImageLoader.getImage(ImageLoader.TRANSFER_CALL_BUTTON), GuiActivator.getResources().getI18NString("service.gui.TRANSFER_BUTTON_TOOL_TIP"));
        this.call = c;
        OperationSetAdvancedTelephony telephony = (OperationSetAdvancedTelephony)this.call.getProtocolProvider().getOperationSet(OperationSetAdvancedTelephony.class);
        if (telephony == null) {
            this.setEnabled(false);
        }
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransferCallButton.this.transferCall();
            }
        });
    }

    private void transferCall() {
        OperationSetAdvancedTelephony telephony = (OperationSetAdvancedTelephony)this.call.getProtocolProvider().getOperationSet(OperationSetAdvancedTelephony.class);
        if (telephony == null) {
            return;
        }
        Collection<CallPeer> transferCalls = this.getTransferCallPeers();
        CallPeer initialPeer = (CallPeer)this.call.getCallPeers().next();
        if (transferCalls == null) {
            CallManager.openCallTransferDialog(initialPeer);
        } else {
            TransferActiveCallsMenu activeCallsMenu = new TransferActiveCallsMenu((JComponent)((Object)this), initialPeer, transferCalls);
            activeCallsMenu.showPopupMenu();
        }
    }

    private Collection<CallPeer> getTransferCallPeers() {
        LinkedList transferCalls = null;
        for (Call activeCall : CallManager.getInProgressCalls()) {
            if (activeCall.equals((Object)this.call) || activeCall.getCallPeerCount() != 1 || !this.call.getProtocolProvider().getProtocolName().equals(activeCall.getProtocolProvider().getProtocolName())) continue;
            if (transferCalls == null) {
                transferCalls = new LinkedList();
            }
            transferCalls.add(activeCall.getCallPeers().next());
        }
        return transferCalls;
    }
}

