/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.SecurityPanel;
import net.java.sip.communicator.service.protocol.AbstractCallPeer;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOffEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOnEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityTimeoutEvent;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.ZrtpControl;

public class ParanoiaTimerSecurityPanel<T extends SrtpControl>
extends SecurityPanel<SrtpControl> {
    private Timer timer = new Timer(true);

    ParanoiaTimerSecurityPanel(T securityControl) {
        super(securityControl);
        this.initComponents();
    }

    private void initComponents() {
        final SimpleDateFormat format = new SimpleDateFormat("mm:ss");
        final Calendar c = Calendar.getInstance();
        final JLabel counter = new JLabel();
        counter.setForeground(Color.red);
        counter.setFont(counter.getFont().deriveFont((float)(counter.getFont().getSize() + 5)));
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel messageLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.security.SECURITY_ALERT"));
        messageLabel.setForeground(Color.WHITE);
        constraints.anchor = 10;
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add(messageLabel, constraints);
        constraints.anchor = 10;
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 1;
        this.add(counter, constraints);
        ZrtpControl zrtpControl = null;
        if (this.securityControl instanceof ZrtpControl) {
            zrtpControl = (ZrtpControl)this.securityControl;
        }
        long initialSeconds = 0L;
        if (zrtpControl != null) {
            initialSeconds = zrtpControl.getTimeoutValue();
        }
        c.setTimeInMillis(initialSeconds);
        counter.setText(format.format(c.getTime()));
        if (initialSeconds > 0L) {
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (c.getTimeInMillis() - 1000L > 0L) {
                        c.add(13, -1);
                        counter.setText(format.format(c.getTime()));
                    }
                }
            }, 1000L, 1000L);
        }
    }

    @Override
    public void securityOn(CallPeerSecurityOnEvent evt) {
        this.timer.cancel();
    }

    @Override
    public void securityOff(CallPeerSecurityOffEvent evt) {
    }

    @Override
    public void securityTimeout(CallPeerSecurityTimeoutEvent evt) {
        this.timer.cancel();
        if (evt.getSource() instanceof AbstractCallPeer) {
            try {
                CallPeer peer = (CallPeer)evt.getSource();
                OperationSetBasicTelephony telephony = (OperationSetBasicTelephony)peer.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
                telephony.hangupCallPeer(peer, 609, "Encryption Required!");
            }
            catch (OperationFailedException ex) {
                Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"Failed to hangup peer", (Throwable)ex);
            }
        }
    }

    public void loadSkin() {
    }
}

